/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.RMIUtil;

public class QueueKey {
    public transient long val;
    public transient long acquire;
    public transient long start;
    public transient long enter;
    public transient long exit;
    public transient Object caller;
    public transient String callerInfo;
    public transient boolean nested;
    public transient Thread thread;

    public QueueKey(long val, Object caller, String callerInfo) {
        this.val = val;
        this.caller = caller;
        this.callerInfo = callerInfo;
        this.acquire = this.msecs();
        this.thread = Thread.currentThread();
    }

    public String toString() {
        String s = "" + this.caller + "::" + this.callerInfo;
        s = s + ":Q=" + RMIUtil.timeFormat((long)this.acquire);
        if (this.enter > 0L) {
            s = s + ":Wait=" + RMIUtil.timeFormat((long)(this.enter - this.acquire));
            s = this.exit > 0L ? s + ":Run=" + RMIUtil.timeFormat((long)(this.exit - this.enter)) : s + ":Run=" + RMIUtil.timeFormat((long)(this.msecs() - this.enter)) + "*";
        } else {
            s = s + ":Wait=" + RMIUtil.timeFormat((long)(this.msecs() - this.acquire)) + "*";
        }
        return s;
    }

    long msecs() {
        return System.currentTimeMillis();
    }

    public boolean equals(Object o2) {
        if (o2 instanceof QueueKey) {
            return this.val == ((QueueKey)o2).val;
        }
        return false;
    }
}

