/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CompileCommand;
import com.sas.rmi.Connection;
import com.sas.rmi.ProxyName;
import com.sas.rmi.RunCommand;
import java.io.File;
import java.util.Vector;

public class ProxyGenerator {
    boolean execute = true;
    boolean echo = true;
    boolean ruleOmitDeadMethods = false;
    boolean ruleDelOverProxySuper = false;
    boolean ruleOverDelInt = false;
    boolean precompile = true;
    boolean postcompile = true;
    int maxSleep = 120000;
    int sleepAmount = 50;
    String m_compiler;
    String m_rmicompiler;
    String m_execute;
    String m_dir = null;
    Vector compilerSwitches = new Vector();
    Vector generatorSwitches = new Vector();

    public static void main(String[] args) {
        int rc = new ProxyGenerator().doit(args);
        System.exit(rc);
    }

    public int doit(String[] args) {
        int rc = 0;
        Vector<String> am = new Vector<String>();
        this.m_compiler = CompileCommand.getCompileCommand();
        this.m_rmicompiler = CompileCommand.getRMICompileCommand();
        for (int y = 0; y < args.length; ++y) {
            String s = args[y];
            if (s.equals("-s")) {
                this.echo = false;
                continue;
            }
            if (s.equals("-n")) {
                this.execute = false;
                continue;
            }
            if (s.startsWith("-m")) {
                this.maxSleep = Integer.parseInt(s.substring(2));
                continue;
            }
            if (s.startsWith("-w")) {
                this.sleepAmount = Integer.parseInt(s.substring(2));
                continue;
            }
            if (s.startsWith("-a")) {
                am.addElement(s.substring(2));
                continue;
            }
            if (s.startsWith("-c")) {
                if (s.length() <= 2) continue;
                CompileCommand.setCompileCommand(s.substring(2));
                continue;
            }
            if (s.startsWith("-rmic")) {
                if (s.length() <= 5) continue;
                CompileCommand.setRMICompileCommand(s.substring(5));
                continue;
            }
            if (s.startsWith("-x")) {
                if (s.length() <= 2) continue;
                CompileCommand.setExecuteCommand(s.substring(2));
                continue;
            }
            if (s.startsWith("-v")) {
                if (s.length() <= 2) continue;
                CompileCommand.setVendor(s.substring(2));
                continue;
            }
            if (s.startsWith("-d")) {
                if (s.length() <= 2) continue;
                this.m_dir = s.substring(2);
                if (this.m_dir.startsWith("\"") && this.m_dir.endsWith("\"")) {
                    this.m_dir = this.m_dir.substring(1, this.m_dir.length() - 1);
                }
                if (this.m_dir.endsWith("/")) continue;
                this.m_dir = this.m_dir + "/";
                continue;
            }
            if (s.startsWith("-g")) {
                if (s.length() <= 2) continue;
                this.generatorSwitches.addElement(s.substring(2));
                continue;
            }
            if (s.startsWith("-precompileOff")) {
                this.precompile = false;
                continue;
            }
            if (s.startsWith("-postcompileOff")) {
                this.postcompile = false;
                continue;
            }
            if (s.startsWith("-ruledops")) {
                this.ruleDelOverProxySuper = true;
                this.generatorSwitches.addElement(s);
                continue;
            }
            if (s.startsWith("-ruleodm")) {
                this.ruleOmitDeadMethods = true;
                this.generatorSwitches.addElement(s);
                continue;
            }
            if (s.startsWith("-ruleodi")) {
                this.ruleOverDelInt = true;
                this.generatorSwitches.addElement(s);
                continue;
            }
            if (s.startsWith("-typecast")) {
                this.generatorSwitches.addElement(s);
                continue;
            }
            if (s.startsWith("-i")) {
                this.generatorSwitches.addElement(s);
                continue;
            }
            if (s.startsWith("-") || s.startsWith("/")) {
                this.compilerSwitches.addElement(s);
                continue;
            }
            this.m_compiler = CompileCommand.getCompileCommand();
            this.m_rmicompiler = CompileCommand.getRMICompileCommand();
            this.m_execute = CompileCommand.getExecuteCommand();
            System.out.println("NOTE: Java compiler='" + this.m_compiler + "'");
            System.out.println("NOTE: Java RMI compiler='" + this.m_rmicompiler + "'");
            System.out.println("NOTE: Java interpreter='" + this.m_execute + "'");
            System.out.println("NOTE: Maximum Execution Time = " + this.maxSleep + "ms");
            System.out.println("NOTE: Sleep = " + this.sleepAmount + "ms");
            if (this.ruleDelOverProxySuper) {
                System.out.println("NOTE: Using \"Delegate Overrides Super Proxy\" rule to determine delegated methods");
            }
            if (this.ruleOmitDeadMethods) {
                System.out.println("NOTE: Using \"Omit Dead Methods\" rule to not generate dead-end methods in proxy subclasses");
            }
            if (this.ruleOverDelInt) {
                System.out.println("NOTE: Using \"Override Delegate Interface\" rule to include _getDelegateInterfaceClass method in IOM proxy");
            }
            if (!this.precompile) {
                System.out.println("NOTE: Precompilation is off");
            }
            if (!this.postcompile) {
                System.out.println("NOTE: Postcompilation is off");
            }
            rc = this.genProxies(s, am);
        }
        return rc;
    }

    int genProxies(String s, Vector accessMethods) {
        ProxyName pn2 = new ProxyName();
        pn2.setClassName(s);
        pn2.setCompiler(this.m_compiler);
        pn2.setRMICompiler(this.m_rmicompiler);
        pn2.setHomeDir(this.m_dir);
        pn2.setGeneratorSwitches(this.generatorSwitches);
        pn2.setPostcompile(this.postcompile);
        if (this.precompile && this.processCommand(this.getPreCondition(pn2.getClassName(), pn2.getPackage())) != 0) {
            return 1;
        }
        if (accessMethods.size() == 0) {
            accessMethods.addElement(Connection.ACCESS_METHOD_J2);
            accessMethods.addElement(Connection.ACCESS_METHOD_REMOTEDESIGNTIME);
        }
        for (int z = 0; z < accessMethods.size(); ++z) {
            pn2.setAccessMethod((String)accessMethods.elementAt(z));
            if (!pn2.validAccessMethod()) {
                System.out.println("Invalid access method: " + (String)accessMethods.elementAt(z));
                continue;
            }
            String[][] svec = pn2.getBuildCommand();
            for (int l = 0; l < svec.length; ++l) {
                if (this.processCommand(svec[l]) == 0) continue;
                return 1;
            }
        }
        return 0;
    }

    String[] getPreCondition(String className, String pkg) {
        String[] s = new String[6];
        if (this.m_dir != null) {
            String name = className;
            className = this.m_dir;
            if (pkg != null) {
                className = className + pkg.replace('.', '/') + "/";
            }
            className = className + name;
        }
        int i = 0;
        s[i++] = this.m_compiler;
        s[i++] = className + "Interface.java";
        s[i++] = className + ".java";
        s[i++] = className + "Delegate.java";
        s[i++] = className + "InterfaceBeanInfo.java";
        s[i++] = className + "InterfaceSCLClassInfo.java";
        return s;
    }

    String[] filter(String[] cmd) {
        if (cmd == null || cmd.length == 0) {
            return cmd;
        }
        if (cmd[0].equals(this.m_compiler)) {
            int i;
            String[] newCmd = new String[cmd.length + this.compilerSwitches.size()];
            newCmd[0] = cmd[0];
            int j = 1;
            for (i = 0; i < this.compilerSwitches.size(); ++i) {
                newCmd[j++] = (String)this.compilerSwitches.elementAt(i);
            }
            for (i = 1; i < cmd.length; ++i) {
                if (cmd[i].startsWith("-")) {
                    newCmd[j++] = cmd[i];
                    continue;
                }
                File f = new File(cmd[i]);
                if (!f.exists()) continue;
                newCmd[j++] = cmd[i];
            }
            String[] cmd2 = new String[j];
            for (int i2 = 0; i2 < j; ++i2) {
                cmd2[i2] = newCmd[i2];
            }
            return cmd2;
        }
        if (cmd[0].equals("rmic")) {
            String f = cmd[cmd.length - 1];
            if (this.m_dir != null) {
                f = this.m_dir + f.replace('.', '/');
            } else {
                int index = f.lastIndexOf(".");
                if (index > 0) {
                    f = f.substring(index + 1);
                }
            }
            f = f + ".class";
            File file = new File(f);
            if (!file.exists()) {
                cmd = null;
            }
            return cmd;
        }
        return cmd;
    }

    int processCommand(String[] cmd) {
        if ((cmd = this.filter(cmd)) == null) {
            return 0;
        }
        RunCommand runcmd = new RunCommand();
        runcmd.setMaxSleep(this.maxSleep);
        runcmd.setSleepAmount(this.sleepAmount);
        return runcmd.processCommand(cmd);
    }
}

