/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.Connection;
import com.sas.rmi.OrbixGeneratorClientTarget;
import com.sas.rmi.OrbixServerTemplate;
import com.sas.rmi.ProxyName;
import com.sas.rmi.Template;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class OrbixGeneratorServerTarget
extends CodeGeneratorBaseTarget {
    @Override
    public String getGeneratorName() {
        return "OrbixWeb_Server";
    }

    @Override
    public Template getTemplate() {
        return new OrbixServerTemplate();
    }

    @Override
    public String getTargetName(String sourceName) {
        ProxyName pn = new ProxyName();
        pn.setAccessMethod(Connection.ACCESS_METHOD_ORBIX);
        pn.setClassName(sourceName);
        return pn.getServerProxyName();
    }

    @Override
    public void generateMethodCode(Class source, Method method, CodeGeneratorOutputStream out) throws Exception {
        int j;
        if (method.getName().equals("clone") && method.getParameterTypes().length == 0) {
            return;
        }
        int modifier = method.getModifiers();
        if (!Modifier.isPublic(modifier) || Modifier.isFinal(modifier)) {
            return;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        String methodName = method.getName();
        methodName = this.convertName(methodName);
        out.println("");
        out.println("// " + methodName, 1);
        String retType = ret;
        if (!OrbixGeneratorClientTarget.isTypeSupported(ret)) {
            retType = "byte_array";
        }
        String s = "public " + retType + " " + methodName + "(";
        out.println(s, 1);
        Class<?>[] params = method.getParameterTypes();
        String p = "";
        Vector<String> convertLines = new Vector<String>();
        for (j = 0; j < params.length; ++j) {
            String pType = CodeGenerator.convertType(params[j].getName());
            if (!OrbixGeneratorClientTarget.isTypeSupported(pType)) {
                convertLines.addElement(pType + " p" + (j + 1) + " = (" + pType + ") com.sas.rmi.CORBABaseClient._RemoteObject_convert(\"" + pType + "\", p" + (j + 1) + "_bytes.buffer);");
                s = "byte_array p" + (j + 1) + "_bytes";
            } else {
                s = pType + " p" + (j + 1);
            }
            p = p + "p" + (j + 1);
            if (j + 1 < params.length) {
                s = s + ",";
                p = p + ",";
            }
            out.println(s, 2);
        }
        out.println(")", 1);
        Class<?>[] exceptions = method.getExceptionTypes();
        for (j = 0; j < exceptions.length; ++j) {
            s = "";
            s = j == 0 ? "throws " : ", ";
            s = s + exceptions[j].getName();
            out.println(s, 3);
        }
        out.println("{", 1);
        for (j = 0; j < convertLines.size(); ++j) {
            out.println((String)convertLines.elementAt(j), 2);
        }
        if (!OrbixGeneratorClientTarget.isTypeSupported(ret)) {
            s = ret + " value = m_object." + method.getName() + "(" + p + ");";
            out.println(s, 2);
            s = "byte[] raw_bytes = com.sas.rmi.CORBABaseClient._RemoteObject_convert(\"" + ret + "\", value);";
            out.println(s, 2);
            s = "byte_array byte_value = new byte_array(raw_bytes.length);";
            out.println(s, 2);
            s = "byte_value.buffer = raw_bytes;";
            out.println(s, 2);
            s = "return byte_value;";
            out.println(s, 2);
        } else {
            s = "";
            if (!ret.equals("void")) {
                s = "return ";
            }
            s = s + "m_object." + method.getName() + "(" + p + ");";
            out.println(s, 2);
        }
        out.println("}", 1);
    }

    @Override
    public boolean implementationMustExist() {
        return true;
    }

    @Override
    public boolean generatesServerCode() {
        return true;
    }
}

