/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.RMIUtil;
import com.sas.security.BaseSecuritySupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;

public class MethodServer
implements Runnable {
    Thread m_thread;
    Object m_target;
    ServerSocket m_serverSocket;
    Socket m_socket;
    boolean m_debug;

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public int setup(Object target) throws IOException {
        if (this.m_debug) {
            System.out.println("Setting up MethodServer");
        }
        this.m_target = target;
        if (this.m_debug) {
            System.out.println("Server for " + this.m_target.getClass().getName());
        }
        this.m_serverSocket = new ServerSocket(0);
        int portNum = this.m_serverSocket.getLocalPort();
        if (this.m_debug) {
            System.out.println("MethodServer listening on port " + portNum);
        }
        return portNum;
    }

    public static String getHost() {
        String host = "";
        try {
            host = RMIUtil.getLocalHost();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return host;
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
        }
    }

    public void stop() {
        try {
            if (this.m_thread != null) {
                this.m_thread.stop();
                this.m_thread = null;
            }
            if (this.m_socket != null) {
                this.m_socket.close();
                this.m_socket = null;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public boolean isAlive() {
        boolean rc = false;
        if (this.m_thread != null) {
            rc = this.m_thread.isAlive();
        }
        return rc;
    }

    @Override
    public void run() {
        try {
            if (this.m_debug) {
                System.out.println("MethodServer starting");
            }
            if (this.m_serverSocket == null) {
                throw new Exception("MethodServer not setup");
            }
            this.m_socket = this.m_serverSocket.accept();
            if (this.m_debug) {
                System.out.println("MethodServer client detected");
            }
            DataInputStream in = new DataInputStream(this.m_socket.getInputStream());
            ObjectInputStream objectIn = new ObjectInputStream(in);
            while (true) {
                if (this.m_debug) {
                    System.out.println("MethodServer waiting for request");
                }
                String methodName = in.readUTF();
                if (this.m_debug) {
                    System.out.println("Method: " + methodName);
                }
                int numArgs = in.readInt();
                Object[] args = null;
                if (numArgs > 0) {
                    args = new Object[numArgs];
                }
                for (int i = 0; i < numArgs; ++i) {
                    boolean isNull = in.readBoolean();
                    args[i] = isNull ? null : objectIn.readObject();
                }
                this.invoke(methodName, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected void finalize() throws Exception {
        this.stop();
    }

    protected synchronized void invoke(String methodName, Object[] args) throws IOException {
        int numArgs = 0;
        if (args != null) {
            numArgs = args.length;
        }
        if (this.m_debug) {
            System.out.println("Attempting to invoke " + methodName + " with " + numArgs + " args");
            for (int i = 0; i < numArgs; ++i) {
                System.out.println("  " + args[i]);
            }
        }
        DataOutputStream out = new DataOutputStream(this.m_socket.getOutputStream());
        Method method = this.getMethod(this.m_target.getClass(), methodName);
        if (method == null) {
            this.sendException("Method '" + this.m_target.getClass().getName() + "." + methodName + "' not found", out);
            return;
        }
        try {
            Object ret = method.invoke(this.m_target, args);
            if (this.m_debug) {
                System.out.println("Return value: " + ret);
            }
            out.writeBoolean(false);
            if (ret == null) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
                ObjectOutputStream objectOut = new ObjectOutputStream(out);
                objectOut.writeObject(ret);
            }
            out.flush();
        }
        catch (IllegalAccessException e) {
            this.sendException("Method '" + this.m_target.getClass().getName() + "." + methodName + "' not found", out);
        }
        catch (IllegalArgumentException e) {
            this.sendException("Illegal argument in '" + this.m_target.getClass().getName() + "." + methodName + "': " + e.getMessage(), out);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            this.sendException("Exception in '" + this.m_target.getClass().getName() + "." + methodName + "': " + t.getMessage(), out);
        }
    }

    protected Method getMethod(Class c, String name) {
        Method method = null;
        Method[] m = c.getMethods();
        for (int i = 0; i < m.length; ++i) {
            if (!m[i].getName().equals(name)) continue;
            method = m[i];
            break;
        }
        return method;
    }

    protected void sendException(String msg, DataOutputStream out) throws IOException {
        out.writeBoolean(true);
        out.writeUTF(msg);
        out.flush();
    }
}

