/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;

public class MethodClient {
    Socket m_socket;
    DataOutputStream m_out;
    ObjectOutputStream m_objectOut;
    DataInputStream m_in;
    ObjectInputStream m_objectIn;
    boolean m_debug = false;

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public void setup(String host, int socketNum) throws IOException {
        if (this.m_debug) {
            System.out.println("MethodClient on " + host + ":" + socketNum);
        }
        this.m_socket = new Socket(host, socketNum);
        this.m_out = new DataOutputStream(this.m_socket.getOutputStream());
        this.m_objectOut = new ObjectOutputStream(this.m_out);
        this.m_in = new DataInputStream(this.m_socket.getInputStream());
    }

    public synchronized Object invoke(String methodName, Object[] args) throws IOException {
        boolean isNull;
        int i;
        if (this.m_debug) {
            System.out.println("MethodClient.invoke");
        }
        if (this.m_socket == null) {
            throw new IOException("MethodClient not setup");
        }
        int numArgs = 0;
        if (args != null) {
            numArgs = args.length;
        }
        if (this.m_debug) {
            System.out.println("Invoking " + methodName + " with:");
            for (i = 0; i < numArgs; ++i) {
                System.out.println("  " + args[i]);
            }
        }
        for (i = 0; i < numArgs; ++i) {
            if (args[i] instanceof Serializable) continue;
            throw new IOException("Argument " + i + " is not serializable");
        }
        Object returnValue = null;
        this.m_out.writeUTF(methodName);
        this.m_out.writeInt(numArgs);
        for (int i2 = 0; i2 < numArgs; ++i2) {
            isNull = args[i2] == null;
            this.m_out.writeBoolean(isNull);
            if (isNull) continue;
            this.m_objectOut.writeObject(args[i2]);
        }
        this.m_out.flush();
        try {
            if (this.m_debug) {
                System.out.println("Waiting for method completion");
            }
            if (this.m_debug) {
                System.out.println("Reading return value");
            }
            boolean isError = this.m_in.readBoolean();
            if (this.m_debug) {
                System.out.println("Returned error=" + isError);
            }
            if (isError) {
                String msg = this.m_in.readUTF();
                throw new IOException(msg);
            }
            isNull = this.m_in.readBoolean();
            if (!isNull) {
                this.m_objectIn = new ObjectInputStream(this.m_in);
                returnValue = this.m_objectIn.readObject();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        return returnValue;
    }
}

