/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.RMIUtil;
import com.sas.rmi.RocfORB;
import com.sas.rmi.RocfORBClient;
import com.sas.rmi.RocfORBMachine;
import com.sas.rmi.RocfORBResPool;
import com.sas.rmi.RocfORBSession;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.List;

public class MWSHtmlGen {
    private transient String htmlFile;
    private transient int htmlFileRefresh;
    private transient boolean creatingPage;
    private transient RocfORB orb;

    public MWSHtmlGen(String htmlFile, int htmlFileRefresh, RocfORB orb) {
        this.htmlFile = htmlFile;
        this.htmlFileRefresh = htmlFileRefresh;
        this.orb = orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genPage() {
        String origFileName;
        String tempFileName;
        if (this.htmlFile == null) {
            return;
        }
        String contents = null;
        Object _o = null;
        String methodName = "genStatusPage";
        try {
            _o = this.orb._RemoteObject_enter(methodName);
            contents = this.makeHtmlPageInMemory();
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.orb._RemoteObject_exit(methodName, _o);
        }
        if (contents == null || !this.delete(tempFileName = (origFileName = this.htmlFile) + "TMP") || !this.write(tempFileName, contents) || !this.delete(origFileName) || this.rename(tempFileName, origFileName)) {
            // empty if block
        }
    }

    boolean write(String fileName, String contents) {
        boolean didWrite = true;
        try {
            char[] ca = contents.toCharArray();
            FileWriter fw = new FileWriter(fileName);
            fw.write(ca);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            System.out.println("write(" + fileName + ") failed:" + e);
            didWrite = false;
        }
        return didWrite;
    }

    boolean rename(String fromName, String toName) {
        File f1 = new File(fromName);
        File f2 = new File(toName);
        boolean didRename = true;
        int maxtries = 3;
        long sleepTime = 1000L;
        for (int i = 0; !(didRename = f1.renameTo(f2)) && i < maxtries; ++i) {
            System.out.println("Warning: rename(" + fromName + "," + toName + ") failed, retry " + (i + 1) + "/" + maxtries + " after sleep " + sleepTime + "ms");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return didRename;
    }

    boolean delete(String s) {
        File f = new File(s);
        boolean didDelete = true;
        int maxtries = 3;
        long sleepTime = 1000L;
        if (f.exists()) {
            for (int i = 0; !(didDelete = f.delete()) && i < maxtries; ++i) {
                System.out.println("Warning: delete(" + s + ") failed,  retry " + (i + 1) + "/" + maxtries + " after sleep " + sleepTime + "ms");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return didDelete;
    }

    String makeHtmlPageInMemory() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<meta HTTP-EQUIV='pragma'  CONTENT='no-cache'>");
        pw.println("<meta HTTP-EQUIV='Refresh' CONTENT='" + this.htmlFileRefresh + "'>");
        pw.println("<title>MWS Status</title>");
        pw.println("<style>");
        pw.println("body {");
        pw.println("   color: #FFFFFF;");
        pw.println("   background-color: #33617B;");
        pw.println("   font-family: Verdana,Arial,sans-serif;");
        pw.println("};");
        pw.println("td {");
        pw.println("   color: #000000;");
        pw.println("   background-color: #FEFEF2;");
        pw.println("};");
        pw.println("</style>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h2>AppDev Studio Middleware Server</h2>");
        long curl = System.currentTimeMillis();
        long stal = this.orb._r_getConstructionTime();
        pw.println("<h4> Start: " + RMIUtil.dateFormat((long)stal) + " Update: " + RMIUtil.dateFormat((long)curl) + "</h4>");
        if (this.orb.getCommandCode() == 1) {
            pw.println("<h4>Middleware Shutdown at " + RMIUtil.dateFormat((long)curl) + "</h4>");
        } else if (this.orb.getCommandCode() == 2) {
            pw.println("<h4>Middleware Terminated at " + RMIUtil.dateFormat((long)curl) + "</h4>");
        } else if (this.orb.getCommandCode() == 3) {
            pw.println("<h4>Remote RELOAD</h4>");
        } else {
            RocfORBClient _client;
            int ic;
            int nc;
            RocfORBSession _session;
            int is;
            int ns;
            RocfORBMachine _machine;
            int im;
            int nm;
            RocfORBResPool _respool;
            int ir;
            int rp = 0;
            int mc = 0;
            int ss = 0;
            boolean cl = false;
            int rc = 0;
            int pc = 0;
            int nr = this.orb.getResPoolCount();
            for (ir = 0; ir < nr; ++ir) {
                _respool = this.orb.getResPool(ir);
                ++rp;
                nm = _respool.getMachineCount();
                for (im = 0; im < nm; ++im) {
                    _machine = _respool.getMachine(im);
                    ++mc;
                    ns = _machine.getSessionCount();
                    for (is = 0; is < ns; ++is) {
                        _session = _machine.getSession(is);
                        ++ss;
                        nc = _session.getClientCount();
                        for (ic = 0; ic < nc; ++ic) {
                            _client = _session.getClient(ic);
                            if (_client.isAvailable()) {
                                ++pc;
                                continue;
                            }
                            ++rc;
                        }
                    }
                }
            }
            pw.println("<table border='1'>");
            pw.println("<tr><th>Resource Pools</th><th>Machines</th><th>Sessions</th><th>Remote Clients</th><th>Available Preloads</th>");
            pw.println("<tr><td>" + rp + "</td><td>" + mc + "</td><td>" + ss + "</td><td>" + rc + "</td><td>" + pc + "</td>");
            pw.println("</table>");
            pw.println("<font size=2>");
            pw.println("<ul>");
            pw.println("<li>Middleware Server " + this.orb.getProps().getOrbName() + "</li>");
            this.plist(pw, this.orb._r_getSTQ().getQueue());
            pw.println("<ul>");
            nr = this.orb.getResPoolCount();
            for (ir = 0; ir < nr; ++ir) {
                _respool = this.orb.getResPool(ir);
                pw.println("<li>" + _respool);
                pw.println("<ul>");
                nm = _respool.getMachineCount();
                for (im = 0; im < nm; ++im) {
                    _machine = _respool.getMachine(im);
                    pw.println("<li>" + _machine);
                    pw.println("<ul>");
                    ns = _machine.getSessionCount();
                    for (is = 0; is < ns; ++is) {
                        _session = _machine.getSession(is);
                        pw.println("<li>" + _session);
                        this.plist(pw, _session._r_getSTQ().getQueue());
                        pw.println("<ul>");
                        nc = _session.getClientCount();
                        for (ic = 0; ic < nc; ++ic) {
                            _client = _session.getClient(ic);
                            pw.println("<li>" + _client);
                        }
                        pw.println("</ul>");
                    }
                    pw.println("</ul>");
                }
                pw.println("</ul>");
            }
            pw.println("</ul>");
            pw.println("</ul>");
            long l2 = System.currentTimeMillis();
            pw.println("</font>");
        }
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
        pw.close();
        return baos.toString();
    }

    void plist(PrintWriter pw, List list) {
        pw.println("<ul>");
        int nl = list.size();
        for (int il = 0; il < nl; ++il) {
            pw.println("<li>Queue[" + (il + 1) + "] " + list.get(il));
        }
        pw.println("</ul>");
    }
}

