/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.awt.Button;
import com.sas.awt.TextField;
import com.sas.awt.util.Util;
import com.sas.beans.CustomizerUtil;
import com.sas.rmi.Connection;
import com.sas.rmi.RB;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

class LoginDialogDefaultDialog
extends Dialog
implements ActionListener,
PropertyChangeListener,
WindowListener {
    Frame parentFrame;
    Connection connection;
    Container container;
    boolean done = false;
    int buttonStatus;
    boolean customizeEnabled;
    boolean systemUser;
    boolean applUser;
    int gridRows = 0;
    int hgap = 10;
    int vgap = 10;
    int numButtons = 0;
    int textLen = 15;
    Button cancelButton;
    Button okButton;
    Button customizeButton;
    com.sas.awt.Label userLabel;
    TextField userText;
    com.sas.awt.Label passwordLabel;
    TextField passwordText;
    com.sas.awt.Label applUserLabel;
    TextField applUserText;
    com.sas.awt.Label applPasswordLabel;
    TextField applPasswordText;
    public static final String RB_KEY = "Connection.";

    public LoginDialogDefaultDialog(Frame frame, boolean modal, Container cont, Connection c) {
        super(frame, modal);
        this.parentFrame = frame;
        this.connection = c;
        this.container = cont;
    }

    public void init() {
        this.customizeEnabled = this.connection.getAllowCustomize();
        this.systemUser = this.connection.isDeferUserInfoUntilRuntime() || this.connection.isDeferAllUntilRuntime();
        boolean bl = this.applUser = this.connection.isDeferApplicationUserInfoUntilRuntime() || this.connection.isDeferAllUntilRuntime();
        if (this.systemUser) {
            this.gridRows += 2;
        }
        if (this.applUser) {
            this.gridRows += 2;
        }
        this.numButtons = 2;
        if (this.customizeEnabled) {
            ++this.numButtons;
        }
        this.addWindowListener(this);
        this.setTitle();
        this.userLabel = new com.sas.awt.Label();
        this.userText = new TextField(this.textLen);
        this.passwordLabel = new com.sas.awt.Label();
        this.passwordText = new TextField(this.textLen);
        this.applUserLabel = new com.sas.awt.Label();
        this.applUserText = new TextField(this.textLen);
        this.applPasswordLabel = new com.sas.awt.Label();
        this.applPasswordText = new TextField(this.textLen);
        this.okButton = new Button();
        this.cancelButton = new Button();
        this.customizeButton = new Button();
        if (this.systemUser) {
            this.userLabel.setText(RB.getStringResource(RB_KEY, "userNameLabel.txt"));
            this.passwordLabel.setText(RB.getStringResource(RB_KEY, "passwordLabel.txt"));
            this.passwordText.setEchoChar('*');
        }
        if (this.applUser) {
            this.applUserLabel.setText(RB.getStringResource(RB_KEY, "applicationUserNameLabel.txt"));
            this.applPasswordLabel.setText(RB.getStringResource(RB_KEY, "applicationPasswordLabel.txt"));
            this.applPasswordText.setEchoChar('*');
        }
        this.okButton.setText(RB.getStringResource(RB_KEY, "okBtn.txt"));
        this.cancelButton.setText(RB.getStringResource(RB_KEY, "cancelBtn.txt"));
        if (this.customizeEnabled) {
            this.customizeButton.setText(RB.getStringResource(RB_KEY, "customizeBtn.txt"));
        }
        this.userLabel.initialize();
        this.userText.initialize();
        this.passwordLabel.initialize();
        this.passwordText.initialize();
        this.applUserLabel.initialize();
        this.applUserText.initialize();
        this.applPasswordLabel.initialize();
        this.applPasswordText.initialize();
        this.okButton.initialize();
        this.cancelButton.initialize();
        this.customizeButton.initialize();
        BorderLayout spaceLM = new BorderLayout();
        Panel outer = new Panel();
        BorderLayout outerLM = new BorderLayout(this.hgap, this.vgap);
        outer.setLayout(outerLM);
        Panel entry = new Panel();
        AutoSizingGridLayout entryLM = new AutoSizingGridLayout(this.gridRows, 2, this.hgap, this.vgap);
        entry.setLayout((LayoutManager)entryLM);
        if (this.systemUser) {
            entry.add(this.userLabel);
            entry.add(this.userText);
            entry.add(this.passwordLabel);
            entry.add(this.passwordText);
        }
        if (this.applUser) {
            entry.add(this.applUserLabel);
            entry.add(this.applUserText);
            entry.add(this.applPasswordLabel);
            entry.add(this.applPasswordText);
        }
        Panel south = new Panel();
        BorderLayout southLM = new BorderLayout(this.hgap, this.vgap);
        south.setLayout(southLM);
        Panel buttons = new Panel();
        GridLayout buttonLM = new GridLayout(1, this.numButtons, this.hgap, this.vgap);
        buttons.setLayout(buttonLM);
        buttons.add(this.okButton);
        buttons.add(this.cancelButton);
        if (this.customizeEnabled) {
            buttons.add(this.customizeButton);
        }
        south.add("North", buttons);
        this.setLayout(spaceLM);
        outer.add("Center", entry);
        outer.add("South", south);
        this.add("Center", outer);
        this.add("East", new Label(""));
        this.add("West", new Label(""));
        this.add("North", new Label(""));
        this.pack();
        Util.center(this);
        this.userText.setText(this.connection.getUsername());
        this.passwordText.setText(this.connection.getPassword());
        this.applUserText.setText(this.connection.getApplicationUsername());
        this.applPasswordText.setText(this.connection.getApplicationPassword());
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.customizeButton.addActionListener(this);
        this.userText.addPropertyChangeListener(this);
        this.passwordText.addPropertyChangeListener(this);
        this.applUserText.addPropertyChangeListener(this);
        this.applPasswordText.addPropertyChangeListener(this);
        this.connection.addPropertyChangeListener(this);
        this.pack();
        this.setVisible(true);
    }

    public void setTitle() {
        this.setTitle(RB.getStringResource(RB_KEY, "login.title.txt") + " " + this.connection.getHost());
    }

    @Override
    public void actionPerformed(ActionEvent _event) {
        Object _source = _event.getSource();
        if (_source != null) {
            if (_source == this.cancelButton) {
                this.cancel();
            } else if (_source == this.okButton) {
                this.buttonStatus = 0;
                this.done = true;
                this.dispose();
            } else if (_source == this.customizeButton) {
                CustomizerUtil.customize(this.connection, new Frame(), true);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent _event) {
        Object _source = _event.getSource();
        String _name = _event.getPropertyName();
        if (_name == null) {
            _name = "";
        }
        if (_source == this.userText && _name.equals("text")) {
            this.connection.setUsername(this.userText.getText());
        }
        if (_source == this.passwordText && _name.equals("text")) {
            this.connection.setPassword(this.passwordText.getText());
        }
        if (_source == this.applUserText && _name.equals("text")) {
            this.connection.setApplicationUsername(this.applUserText.getText());
        }
        if (_source == this.applPasswordText && _name.equals("text")) {
            this.connection.setApplicationPassword(this.applPasswordText.getText());
        }
        if (_source == this.connection && _name.equals("host")) {
            this.setTitle();
        }
        if (_source == this.connection && _name.equals("username")) {
            this.userText.setText(this.connection.getUsername());
        }
        if (_source == this.connection && _name.equals("password")) {
            this.passwordText.setText(this.connection.getPassword());
        }
        if (_source == this.connection && _name.equals("applicationUsername")) {
            this.applUserText.setText(this.connection.getApplicationUsername());
        }
        if (_source == this.connection && _name.equals("applicationPassword")) {
            this.applPasswordText.setText(this.connection.getApplicationPassword());
        }
    }

    public void cancel() {
        this.buttonStatus = 1;
        this.done = true;
        this.dispose();
    }

    public int waitForCompletion() {
        while (!this.done) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        return this.buttonStatus;
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
        this.cancel();
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }
}

