/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.Connection;
import com.sas.rmi.LoadBalancer;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class LoadBalanceBound {
    private String m_file;
    private int m_upperClientBound;
    private int m_upperObjectBound;
    private int m_maxClients;
    private int m_clientCount;
    private int m_timeout;
    private Connection m_con = new Connection();
    private Properties m_prop = new Properties();
    private boolean m_valid;
    private int m_lineNo;
    private LoadBalancer m_loadBalancer;

    public LoadBalanceBound(String line) {
        try {
            System.out.println("Processing " + line);
            this.m_file = line;
            FileInputStream fis = new FileInputStream(this.m_file);
            this.m_prop.load(fis);
            this.m_upperClientBound = this.consumeInt("UpperClientBound", -1);
            this.m_upperObjectBound = this.consumeInt("UpperObjectBound", -1);
            this.m_timeout = this.consumeInt("Timeout", 1);
            this.m_con.setHost(this.consumeString("Host", Connection.HOST_DEFAULT));
            this.m_con.setUsername(this.consumeString("Username", Connection.USERNAME_DEFAULT));
            this.m_con.setCommand(this.consumeString("Command", Connection.COMMAND_DEFAULT));
            Enumeration<?> e = this.m_prop.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.m_con.setString(key, this.m_prop.getProperty(key));
            }
            System.out.println("UpperClientBound=" + this.m_upperClientBound);
            System.out.println("UpperObjectBound=" + this.m_upperObjectBound);
            System.out.println("Timeout=" + this.m_timeout);
            System.out.println("Host=" + this.m_con.getHost());
            System.out.println("Username=" + this.m_con.getUsername());
            System.out.println("Command=" + this.m_con.getCommand());
        }
        catch (IOException ioe) {
            this.m_valid = false;
            throw new RuntimeException(ioe.toString());
        }
        this.m_valid = true;
    }

    public String getFilename() {
        return this.m_file;
    }

    public void setLoadBalancer(LoadBalancer value) {
        this.m_loadBalancer = value;
    }

    private int consumeInt(String key, int defaultVal) {
        return Integer.parseInt(this.consumeString(key, "" + defaultVal));
    }

    private String consumeString(String key, String defaultVal) {
        String ret = defaultVal;
        String s = this.m_prop.getProperty(key);
        if (s != null) {
            ret = s;
            this.m_prop.remove(key);
        }
        return ret;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public void setLineNo(int value) {
        this.m_lineNo = value;
    }

    public int getLineNo() {
        return this.m_lineNo;
    }

    public void setUpperClientBound(int value) {
        this.m_upperClientBound = value;
    }

    public int getUpperClientBound() {
        return this.m_upperClientBound;
    }

    public void setUpperObjectBound(int value) {
        this.m_upperObjectBound = value;
    }

    public int getUpperObjectBound() {
        return this.m_upperObjectBound;
    }

    public void setTimeout(int value) {
        this.m_timeout = value;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public Connection getConnection() {
        Connection c = null;
        if (this.m_valid) {
            c = this.m_con;
        }
        return c;
    }

    public Properties getProperties() {
        return this.m_prop;
    }

    public void setMaxClients(int value) {
        this.m_maxClients = value;
    }

    public int getMaxClients() {
        return this.m_maxClients;
    }

    public synchronized void addClient() {
        ++this.m_clientCount;
        System.out.println("" + this);
    }

    public synchronized void removeClient() {
        if (this.m_clientCount > 0) {
            --this.m_clientCount;
        }
        System.out.println("" + this);
    }

    public boolean isAcceptingClients() {
        boolean rc = false;
        if (this.m_maxClients > 0 && this.m_clientCount < this.m_maxClients) {
            rc = true;
        }
        return rc;
    }

    public String toString() {
        String s = "LoadBalanceBound ";
        s = this.m_con != null ? s + this.m_con.getHost() + ":" + this.m_con.getUsername() + ":" + this.m_con.getCommand() + ":" + this.m_maxClients : s + "null";
        s = s + " Clients=" + this.m_clientCount;
        return s;
    }

    protected void setConnection(Connection target) {
        if (this.m_loadBalancer != null) {
            this.m_loadBalancer.setConnection(target, this);
        }
    }
}

