/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.net.server.RemoteSasException;
import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.Connection;
import com.sas.rmi.J2Template;
import com.sas.rmi.ProxyName;
import com.sas.rmi.ServerBusyTimeoutException;
import com.sas.rmi.TargetMethod;
import com.sas.rmi.Template;
import java.lang.reflect.Method;

public class J2GeneratorTarget
extends CodeGeneratorBaseTarget {
    TargetMethod m_tm = new TargetMethod();

    @Override
    public String getGeneratorName() {
        return "J2";
    }

    public J2GeneratorTarget() {
        this.m_tm.addCastException(RemoteSasException.class);
        this.m_tm.addBroadcastException(ServerBusyTimeoutException.class);
    }

    @Override
    public Template getTemplate() {
        return new J2Template();
    }

    @Override
    public String getTargetName(String sourceName) {
        ProxyName pn = new ProxyName();
        pn.setAccessMethod(Connection.ACCESS_METHOD_J2);
        pn.setClassName(sourceName);
        return pn.getClientProxyName();
    }

    @Override
    public void generateMethodCode(Class source, Method method, String methodName, CodeGeneratorOutputStream out) throws Exception {
        String[] attrInfo;
        Class<?>[] params = method.getParameterTypes();
        if (!this.m_tm.generateMethodCodeHeader(source, method, methodName, out)) {
            return;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        boolean isAttribute = false;
        boolean isSetAttribute = false;
        String sclAttributeName = null;
        if (methodName.length() > 3 && (methodName.startsWith("get") || methodName.startsWith("set")) && (attrInfo = this.getAttributeInfo(source, methodName)) != null) {
            isAttribute = true;
            sclAttributeName = attrInfo[2];
            if (methodName.charAt(0) == 's') {
                isSetAttribute = true;
            }
        }
        String[][] tmv = new String[][]{{"boolean", "Boolean", "false", "Boolean"}, {"byte", "Byte", "(byte)0", "Byte"}, {"char", "Char", "(char)0", "Char"}, {"short", "Short", "(short)0", "Short"}, {"int", "Int", "0", "Int"}, {"long", "Long", "(long)0", "Long"}, {"float", "Float", "(float)0.0", "Float"}, {"double", "Double", "0.0", "Double"}, {"boolean[]", "BooleanArray", "null", "BooleanArray"}, {"byte[]", "ByteArray", "null", "ByteArray"}, {"char[]", "CharArray", "null", "CharacterArray"}, {"short[]", "ShortArray", "null", "ShortArray"}, {"int[]", "IntArray", "null", "IntArray"}, {"long[]", "LongArray", "null", "LongArray"}, {"float[]", "FloatArray", "null", "FloatArray"}, {"double[]", "DoubleArray", "null", "DoubleArray"}, {"java.lang.String", "String", "null", "Character"}, {"java.lang.String[]", "StringArray", "null", "StringArray"}, {"com.sas.collection.hlist.HListInterface", "List", "null", "List"}, {"boolean[][]", "BooleanArray2D", "null", null}, {"byte[][]", "ByteArray2D", "null", null}, {"char[][]", "CharArray2D", "null", null}, {"short[][]", "ShortArray2D", "null", null}, {"int[][]", "IntArray2D", "null", null}, {"long[][]", "LongArray2D", "null", null}, {"float[][]", "FloatArray2D", "null", null}, {"double[][]", "DoubleArray2D", "null", null}, {"java.lang.String[][]", "StringArray2D", "null", null}};
        if (isAttribute) {
            if (isSetAttribute) {
                String getSetMethodNamePart = null;
                for (int i = 0; i < tmv.length; ++i) {
                    if (!CodeGenerator.convertType(params[0].getName()).equals(tmv[i][0]) || tmv[i][3] == null) continue;
                    getSetMethodNamePart = tmv[i][3];
                    break;
                }
                if (getSetMethodNamePart == null) {
                    out.println("if ( false ) throw new RemoteSasException();", 3);
                } else {
                    out.println("set" + getSetMethodNamePart + "AttributeValue( _RemoteObject_getSCLHandle(), \"" + sclAttributeName + "\", p1 );", 3);
                    out.println("if ( false ) throw new RemoteSasException();", 3);
                }
            } else {
                String getSetMethodNamePart = null;
                for (int i = 0; i < tmv.length; ++i) {
                    if (!ret.equals(tmv[i][0]) || tmv[i][3] == null) continue;
                    getSetMethodNamePart = tmv[i][3];
                    break;
                }
                if (getSetMethodNamePart == null) {
                    out.println("value = null; // XXX", 3);
                    out.println("if ( false ) throw new RemoteSasException();", 3);
                } else {
                    out.println("value = get" + getSetMethodNamePart + "AttributeValue( _RemoteObject_getSCLHandle(), \"" + sclAttributeName + "\" ); // XXX", 3);
                    out.println("if ( false ) throw new RemoteSasException();", 3);
                }
            }
        } else {
            boolean found;
            String callMethodOn = "remoteObject";
            out.println("remoteObject.clearArguments();", 3);
            if (!ret.equals("void")) {
                found = false;
                for (int i = 0; i < tmv.length; ++i) {
                    found = ret.equals(tmv[i][0]);
                    if (!found) continue;
                    out.println(callMethodOn + ".add" + tmv[i][1] + "Argument(" + tmv[i][2] + ", AfRequestInterface.Output);", 3);
                    break;
                }
                if (!found) {
                    out.println(callMethodOn + ".addDoubleArgument(0.0, AfRequestInterface.Output);", 3);
                }
            }
            int argBase = 1;
            for (int j = 0; j < params.length; ++j) {
                String s = CodeGenerator.convertType(params[j].getName());
                if (s.equals("void")) continue;
                found = false;
                for (int i = 0; i < tmv.length; ++i) {
                    found = s.equals(tmv[i][0]);
                    if (!found) continue;
                    out.println(callMethodOn + ".add" + tmv[i][1] + "Argument(p" + argBase++ + ", pmode);", 3);
                    break;
                }
                if (found) continue;
                out.println("_j2bc_addObjectArgument(p" + argBase++ + ", pmode);", 3);
            }
            String remoteMethodName = method.getName();
            String[] methodInfo = this.getMethodInfo(source, method.getName());
            if (methodInfo != null) {
                remoteMethodName = methodInfo[1];
            }
            out.println(callMethodOn + ".invokeRemoteMethod(\"" + remoteMethodName + "\");", 3);
            if (!ret.equals("void")) {
                found = false;
                for (int i = 0; i < tmv.length; ++i) {
                    found = ret.equals(tmv[i][0]);
                    if (!found) continue;
                    out.println("value = " + callMethodOn + ".get" + tmv[i][1] + "Argument();", 3);
                    break;
                }
                if (!found) {
                    out.println("value = (" + ret + ") _j2bc_getObject(" + ret + ".class);", 3);
                }
            }
        }
        this.m_tm.generateMethodCodeTrailer(source, method, methodName, out);
    }
}

