/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.InterfaceTemplate;
import com.sas.rmi.Template;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class InterfaceGeneratorTarget
extends CodeGeneratorBaseTarget {
    @Override
    public String getGeneratorName() {
        return "Interface";
    }

    @Override
    public Template getTemplate() {
        return new InterfaceTemplate();
    }

    @Override
    public String getTargetName(String sourceName) {
        return sourceName + "Interface";
    }

    @Override
    public void generateConstructorCode(Class source, Constructor constructor, CodeGeneratorOutputStream out) throws Exception {
    }

    @Override
    public void generateConstructorCode(Class source, String className, CodeGeneratorOutputStream out) throws Exception {
    }

    @Override
    public void generateMethodCode(Class source, Method method, CodeGeneratorOutputStream out) throws Exception {
        int j;
        int modifier = method.getModifiers();
        if (!Modifier.isPublic(modifier) || Modifier.isFinal(modifier)) {
            return;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        out.println("");
        out.println("// " + method.getName(), 1);
        String s = ret + " " + method.getName() + "(";
        out.println(s, 1);
        Class<?>[] params = method.getParameterTypes();
        String p = "";
        for (j = 0; j < params.length; ++j) {
            s = CodeGenerator.convertType(params[j].getName()) + " p" + (j + 1);
            p = p + "p" + (j + 1);
            if (j + 1 < params.length) {
                s = s + ",";
                p = p + ",";
            }
            out.println(s, 2);
        }
        out.println(")", 1);
        Class<?>[] exceptions = method.getExceptionTypes();
        for (j = 0; j < exceptions.length; ++j) {
            s = j == 0 ? "throws " : ", ";
            s = s + exceptions[j].getName();
            out.println(s, 3);
        }
        out.println(";", 1);
    }

    @Override
    public boolean generateFromInterface() {
        return false;
    }

    @Override
    public boolean generatesInterfaceCode() {
        return true;
    }
}

