/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorOptions;
import com.sas.rmi.InterfaceGeneratorTarget;
import com.sas.rmi.RocfClass;
import java.io.PrintStream;

class InterfaceGenerator {
    InterfaceGenerator() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        boolean failed = false;
        int n = args.length;
        int namePos = 0;
        boolean overwrite = false;
        boolean verbose = false;
        String model = null;
        String dir = null;
        if (n <= 0) {
            n = namePos + 2;
        } else {
            for (int i = 0; i < n; ++i) {
                if (args[i].equals("-o")) {
                    ++namePos;
                    overwrite = true;
                }
                if (args[i].equals("-v")) {
                    ++namePos;
                    verbose = true;
                }
                if (args[i].equals("-m")) {
                    if (i + 1 < n) {
                        model = args[i + 1];
                        namePos += 2;
                    } else {
                        failed = true;
                        break;
                    }
                }
                if (!args[i].equals("-d")) continue;
                if (i + 1 < n) {
                    dir = args[i + 1];
                    namePos += 2;
                    continue;
                }
                failed = true;
                break;
            }
        }
        if (failed || namePos != n - 1) {
            System.out.println("\nUsage: InterfaceGenerator [-options] <class name>");
            System.out.println("\nwhere options include:");
            System.out.println("    -d        Directory");
            System.out.println("    -m        Specifies model name");
            System.out.println("    -o        Overwrite existing files");
            System.out.println("    -v        Verbose output");
            failed = true;
        }
        Class c = null;
        if (!failed && (c = InterfaceGenerator.getClass(args[namePos])) == null) {
            failed = true;
        }
        if (!failed) {
            PrintStream out = null;
            if (verbose) {
                out = System.out;
            }
            CodeGeneratorOptions options = new CodeGeneratorOptions();
            options.setOverwriteSource(overwrite);
            options.setVerboseStream(out);
            options.setDirectory(dir);
            InterfaceGeneratorTarget target = new InterfaceGeneratorTarget();
            CodeGenerator generator = new CodeGenerator(c, target, options);
            try {
                failed = generator.generate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                failed = true;
            }
        }
        if (failed) {
            System.out.println("\nInterfaceGenerator failed.");
            if (!verbose) {
                System.out.println("\nUse -v switch for more details");
            }
        }
    }

    private static Class getClass(String name) {
        Class c = null;
        try {
            c = RocfClass.forName(name);
        }
        catch (ClassNotFoundException ex) {
            System.out.println("\nClass not found: " + ex.getMessage());
        }
        catch (Exception ex) {
            System.out.println("\nUnable to get Class: " + ex.getMessage());
        }
        return c;
    }
}

