/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.Connection;
import com.sas.rmi.IOMTemplate;
import com.sas.rmi.ProxyName;
import com.sas.rmi.RocfClass;
import com.sas.rmi.TargetMethod;
import com.sas.rmi.Template;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class IOMGeneratorTarget
extends CodeGeneratorBaseTarget {
    TargetMethod m_tm = new TargetMethod();
    public static final int DIRECTION_IN = 1;
    public static final int DIRECTION_OUT = 2;
    public static final int DIRECTION_INOUT = 3;

    @Override
    public String getGeneratorName() {
        return "IOM";
    }

    public IOMGeneratorTarget() {
        this.m_tm.addCastException(IOException.class);
    }

    @Override
    public Template getTemplate() {
        return new IOMTemplate();
    }

    @Override
    public String getTargetName(String sourceName) {
        ProxyName pn = new ProxyName();
        pn.setAccessMethod(Connection.ACCESS_METHOD_IOM);
        pn.setClassName(sourceName);
        return pn.getClientProxyName();
    }

    Method getMethod(Class c, String methodName, Class[] methodParams) throws NoSuchMethodException {
        try {
            Method method = c.getDeclaredMethod(methodName, methodParams);
            return method;
        }
        catch (Exception e) {
            try {
                Method[] methodArray = c.getDeclaredMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    Class<?>[] method2Params;
                    if (!methodName.equals(methodArray[i].getName()) || methodParams.length != (method2Params = methodArray[i].getParameterTypes()).length) continue;
                    try {
                        for (int p = 0; p < methodParams.length; ++p) {
                            CodeGenerator.GetTypeCast(methodParams[p].getName(), method2Params[p].getName());
                        }
                        return methodArray[i];
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            throw new NoSuchMethodException(methodName);
        }
    }

    protected int[] getIntArrayField(Class c, String fieldName) {
        try {
            Field field = null;
            try {
                field = c.getDeclaredField(fieldName);
            }
            catch (Exception e) {
                field = c.getField(fieldName);
            }
            int[] values = (int[])field.get(null);
            return values;
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected int[] getParameterDirections(Class c, String methodName) {
        int[] directions = this.getIntArrayField(c, "method_" + methodName + "_parameters");
        return directions;
    }

    @Override
    public void generateMethodCode(Class source, Method method, String methodName, CodeGeneratorOutputStream out) throws Exception {
        boolean Hlist2DArrayToDouble;
        boolean Hlist1DArrayToDouble;
        boolean HlistToDouble;
        boolean stringArrayToHlist;
        String paramType;
        int j;
        int[] parameterDirections;
        String[] attrInfo;
        String remoteMethodName;
        String s = null;
        if (method.getName().equals("clone") && method.getParameterTypes().length == 0) {
            return;
        }
        String[] methodInfo = this.getMethodInfo(source, method.getName());
        if (this.getGenerator().methodInProxySuperclass(method)) {
            return;
        }
        if (methodInfo == null) {
            remoteMethodName = method.getName();
        } else if (methodInfo[2].length() > 0) {
            remoteMethodName = methodInfo[2];
        } else {
            String[] message = new String[]{"Reason: Forced stub from SCLClassInfo IOM method."};
            this.m_tm.generateMethodCodeStub(method, methodName, out, true, message);
            return;
        }
        boolean isAttribute = false;
        String corbaAttributeName = null;
        if (methodName.length() > 3 && (methodName.startsWith("get") || methodName.startsWith("set")) && (attrInfo = this.getAttributeInfo(source, methodName)) != null) {
            isAttribute = true;
            corbaAttributeName = attrInfo[1];
        }
        if (isAttribute) {
            parameterDirections = new int[]{1};
        } else {
            int i;
            try {
                Class infoClass = RocfClass.forName(ProxyName.getSCLClassInfoName(source.getName()));
                parameterDirections = this.getParameterDirections(infoClass, remoteMethodName);
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println("Using default directions for: " + source.getName() + ": " + remoteMethodName);
                parameterDirections = new int[method.getParameterTypes().length];
                for (i = 0; i < parameterDirections.length; ++i) {
                    parameterDirections[i] = 3;
                }
            }
            catch (IllegalArgumentException iae) {
                System.out.println("Using default directions for: " + source.getName() + ": " + remoteMethodName);
                parameterDirections = new int[method.getParameterTypes().length];
                for (i = 0; i < parameterDirections.length; ++i) {
                    parameterDirections[i] = 3;
                }
            }
        }
        Class[] params = method.getParameterTypes();
        String p = "";
        String CorbaClassName = "";
        Class CorbaClass = null;
        Method CorbaMethod = null;
        Class<?>[] CorbaMethodParameters = null;
        String CorbaMethodParameter = "";
        try {
            ProxyName pn = new ProxyName();
            CorbaClassName = pn.getCORBAInterfaceName(source, this.getGenerator().mOptions);
            CorbaClass = RocfClass.forName(CorbaClassName);
            CorbaMethod = isAttribute ? this.getMethod(CorbaClass, corbaAttributeName, params) : this.getMethod(CorbaClass, remoteMethodName, params);
            CorbaMethodParameters = CorbaMethod.getParameterTypes();
        }
        catch (Exception pn) {
            // empty catch block
        }
        if (CorbaMethod == null) {
            String[] message = new String[]{isAttribute ? "Reason: No \"" + corbaAttributeName + "\" CORBA method found." : "Reason: No \"" + remoteMethodName + "\" CORBA method found."};
            this.m_tm.generateMethodCodeStub(method, methodName, out, true, message);
            return;
        }
        if (!CodeGenerator.ParametersMatch(params, CorbaMethodParameters, true)) {
            int i;
            int msgArrSize = 3;
            if (params != null) {
                msgArrSize += params.length;
            }
            if (CorbaMethodParameters != null) {
                msgArrSize += CorbaMethodParameters.length;
            }
            String[] message = new String[msgArrSize];
            int mi = 0;
            message[mi++] = "Reason: Parameters mismatch.";
            if (params != null && params.length > 0) {
                message[mi++] = "Interface method parameters:";
                for (i = 0; i < params.length; ++i) {
                    message[mi++] = params[i].toString();
                }
            } else {
                message[mi++] = "Interface method parameters: none";
            }
            if (CorbaMethodParameters != null && CorbaMethodParameters.length > 0) {
                message[mi++] = "CORBA method parameters:";
                for (i = 0; i < CorbaMethodParameters.length; ++i) {
                    message[mi++] = CorbaMethodParameters[i].toString();
                }
            } else {
                message[mi++] = "CORBA method parameters: none";
            }
            this.m_tm.generateMethodCodeStub(method, methodName, out, true, message);
            return;
        }
        if (!this.m_tm.generateMethodCodeHeader(source, method, methodName, out)) {
            return;
        }
        boolean typeCastingEnabled = true;
        String option = this.getGenerator().mOptions.getArg("-typecast");
        if (option != null && option.equalsIgnoreCase("OFF")) {
            typeCastingEnabled = false;
        }
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        for (j = 0; j < params.length; ++j) {
            String paramTail;
            boolean doubleArrayToHlist;
            String paramType2 = CodeGenerator.convertType(params[j].getName());
            CorbaMethodParameter = "";
            if (CorbaMethodParameters != null && j < CorbaMethodParameters.length) {
                CorbaMethodParameter = CodeGenerator.convertType(CorbaMethodParameters[j].getName());
            }
            boolean corbaParamTypeIsList = CorbaMethodParameter.equals("double") || CorbaMethodParameter.equals("byte[]");
            boolean stringArrayToHlist2 = paramType2.equals("java.lang.String[]") && corbaParamTypeIsList;
            boolean bl = doubleArrayToHlist = paramType2.equals("double[]") && corbaParamTypeIsList;
            if (paramType2.equals("com.sas.collection.hlist.HListInterface") || stringArrayToHlist2) {
                paramTail = "";
                if (stringArrayToHlist2) {
                    paramTail = "Hlist";
                    out.println("com.sas.collection.hlist.HListInterface p" + (j + 1) + paramTail + " = stringArrayToHList(p" + (j + 1) + ");", 3);
                }
                if ((parameterDirections[j] & 1) != 0) {
                    if (CorbaMethodParameter.equals("double")) {
                        out.println("double listid" + (j + 1) + "= marshalListOutStart(p" + (j + 1) + paramTail + ");", 3);
                        out.println("org.omg.CORBA.DoubleHolder listidHolder" + (j + 1) + "= new org.omg.CORBA.DoubleHolder( listid" + (j + 1) + ");", 3);
                        p = parameterDirections[j] == 1 ? p + "listid" + (j + 1) : p + "listidHolder" + (j + 1);
                    } else if (CorbaMethodParameter.equals("byte[]")) {
                        out.println("byte[] p" + (j + 1) + "ByteArray = HListToByteArray(p" + (j + 1) + paramTail + ");", 3);
                        p = p + "p" + (j + 1) + "ByteArray";
                    } else if (CorbaMethodParameter.equals("com.sas.iom.SASIOMDefs.OctetSeqHolder")) {
                        out.println("com.sas.iom.SASIOMDefs.OctetSeqHolder p" + (j + 1) + "OctetSeqHolder = new com.sas.iom.SASIOMDefs.OctetSeqHolder();", 3);
                        out.println("byte[] p" + (j + 1) + "ByteArray = HListToByteArray(p" + (j + 1) + paramTail + ");", 3);
                        out.println("p" + (j + 1) + "OctetSeqHolder.value = p" + (j + 1) + "ByteArray;", 3);
                        p = p + "p" + (j + 1) + "OctetSeqHolder";
                    }
                } else if (CorbaMethodParameter.equals("double")) {
                    out.println("org.omg.CORBA.DoubleHolder listidHolder" + (j + 1) + "= new org.omg.CORBA.DoubleHolder( 0 );", 3);
                    p = p + "listidHolder" + (j + 1);
                } else if (CorbaMethodParameter.equals("byte[]")) {
                    out.println("byte[] p" + (j + 1) + "ByteArray = HListToByteArray(p" + (j + 1) + paramTail + ");", 3);
                    p = p + "p" + (j + 1) + "ByteArray";
                } else if (CorbaMethodParameter.equals("com.sas.iom.SASIOMDefs.OctetSeqHolder")) {
                    out.println("com.sas.iom.SASIOMDefs.OctetSeqHolder p" + (j + 1) + "OctetSeqHolder = new com.sas.iom.SASIOMDefs.OctetSeqHolder();", 3);
                    p = p + "p" + (j + 1) + "OctetSeqHolder";
                }
            } else if (paramType2.equals("com.sas.collection.hlist.HListInterface[]")) {
                paramTail = "";
                if (stringArrayToHlist2) {
                    paramTail = "Hlist";
                    out.println("com.sas.collection.hlist.HListInterface p" + (j + 1) + paramTail + " = stringArrayToHList(p" + (j + 1) + ");", 3);
                }
                if ((parameterDirections[j] & 1) != 0) {
                    if (CorbaMethodParameter.equals("double[]")) {
                        out.println("double[] listids" + (j + 1) + "= marshalList1DArrayOutStart(p" + (j + 1) + ");", 3);
                        out.println("com.sas.iom.SASIOMDefs.DoubleSeqHolder listidsHolder" + (j + 1) + "= new com.sas.iom.SASIOMDefs.DoubleSeqHolder( listids" + (j + 1) + ");", 3);
                        p = parameterDirections[j] == 1 ? p + "listids" + (j + 1) : p + "listidsHolder" + (j + 1);
                    } else if (CorbaMethodParameter.equals("byte[][]")) {
                        out.println("byte[][] p" + (j + 1) + "ByteArray2d = HListArrayToByteArray2d(p" + (j + 1) + paramTail + ");", 3);
                        p = p + "p" + (j + 1) + "ByteArray2d";
                    }
                } else if (CorbaMethodParameter.equals("double[]")) {
                    out.println("com.sas.iom.SASIOMDefs.DoubleSeqHolder listidsHolder" + (j + 1) + "= new com.sas.iom.SASIOMDefs.DoubleSeqHolder();", 3);
                    p = p + "listidsHolder" + (j + 1);
                } else if (CorbaMethodParameter.equals("byte[][]")) {
                    out.println("byte[][] p" + (j + 1) + "ByteArray2d = HListArrayToByteArray2d(p" + (j + 1) + paramTail + ");", 3);
                    p = p + "p" + (j + 1) + "ByteArray2d";
                }
            } else if (paramType2.equals("com.sas.collection.hlist.HListInterface[][]")) {
                if ((parameterDirections[j] & 1) != 0) {
                    out.println("double[][] listids" + (j + 1) + "= marshalList2DArrayOutStart(p" + (j + 1) + ");", 3);
                    out.println("com.sas.iom.SASIOMDefs.VariableArray2dOfDoubleHolder listidsHolder" + (j + 1) + "= new com.sas.iom.SASIOMDefs.VariableArray2dOfDoubleHolder( listids" + (j + 1) + ");", 3);
                    p = parameterDirections[j] == 1 ? p + "listids" + (j + 1) : p + "listidsHolder" + (j + 1);
                } else {
                    out.println("com.sas.iom.SASIOMDefs.VariableArray2dOfDoubleHolder listidsHolder" + (j + 1) + "= new com.sas.iom.SASIOMDefs.VariableArray2dOfDoubleHolder();", 3);
                    p = p + "listidsHolder" + (j + 1);
                }
            } else if (paramType2.equals("int") && CorbaMethodParameter.equals("org.omg.CORBA.DoubleHolder")) {
                out.println("org.omg.CORBA.DoubleHolder p" + (j + 1) + "DoubleHolder = new org.omg.CORBA.DoubleHolder(p" + (j + 1) + ");", 3);
                p = p + "p" + (j + 1) + "DoubleHolder";
            } else if (paramType2.equals("java.lang.String") && CorbaMethodParameter.equals("org.omg.CORBA.StringHolder")) {
                out.println("org.omg.CORBA.StringHolder p" + (j + 1) + "StringHolder = new org.omg.CORBA.StringHolder(p" + (j + 1) + ");", 3);
                p = p + "p" + (j + 1) + "StringHolder";
            } else if (paramType2.equals("java.lang.Object")) {
                out.println("java.lang.Object p" + (j + 1) + "Object = p" + (j + 1) + ";", 3);
                out.println("if (p" + (j + 1) + " instanceof com.sas.rmi.RemoteBaseClient)", 3);
                out.println("p" + (j + 1) + "Object = ((com.sas.rmi.RemoteBaseClient)p" + (j + 1) + ")._RemoteObject_getObject();", 4);
                p = p + "(org.omg.CORBA.Object)p" + (j + 1) + "Object";
            } else if (paramType2.equals("boolean") && !CorbaMethodParameter.equals("boolean")) {
                p = p + "p" + (j + 1) + " ? 1 : 0";
            } else {
                if (typeCastingEnabled) {
                    try {
                        p = p + CodeGenerator.GetTypeCast(CorbaMethodParameter, paramType2);
                    }
                    catch (RuntimeException paramTail2) {
                        // empty catch block
                    }
                }
                p = p + "p" + (j + 1);
            }
            if (j + 1 >= params.length) continue;
            p = p + ",";
        }
        String CorbaReturnType = CodeGenerator.convertType(CorbaMethod.getReturnType().getName());
        boolean corbaReturnTypeIsList = CorbaReturnType.equals("double") || CorbaReturnType.equals("byte[]");
        boolean hlistToStringArray = ret.equals("java.lang.String[]") && corbaReturnTypeIsList;
        boolean hlistToDoubleArray = ret.equals("double[]") && corbaReturnTypeIsList;
        String returnType = "";
        if (ret.equals("com.sas.collection.hlist.HListInterface") || hlistToStringArray || hlistToDoubleArray) {
            if (CorbaReturnType.equals("double")) {
                s = "double returnListId = ";
                returnType = "double";
            } else if (CorbaReturnType.equals("byte[]")) {
                s = "byte[] returnByteArray = ";
                returnType = "byte[]";
            }
        } else if (ret.equals("com.sas.collection.hlist.HListInterface[]")) {
            if (CorbaReturnType.equals("double[]")) {
                s = "double[] returnListIds = ";
                returnType = "double[]";
            } else if (CorbaReturnType.equals("byte[][]")) {
                s = "byte[][] returnByteArray2d = ";
                returnType = "byte[][]";
            }
        } else if (ret.equals("com.sas.collection.hlist.HListInterface[][]")) {
            s = "double[][] returnListIds = ";
            returnType = "double[][]";
        } else if (!ret.equals("void")) {
            s = "value = ";
            returnType = ret;
        } else {
            s = "";
        }
        if (typeCastingEnabled) {
            try {
                s = s + CodeGenerator.GetTypeCast(returnType, CorbaReturnType);
            }
            catch (RuntimeException re) {
                System.out.println("WARNING: In call to " + remoteMethodName + ": " + re.toString());
            }
        }
        s = isAttribute ? (CorbaClassName.length() > 0 ? s + "((" + CorbaClassName + ")mObject)." + corbaAttributeName + "(" + p + ")" : s + "mObject." + corbaAttributeName + "(" + p + ")") : (CorbaClassName.length() > 0 ? s + "((" + CorbaClassName + ")mObject)." + remoteMethodName + "(" + p + ")" : s + "mObject." + remoteMethodName + "(" + p + ")");
        if (typeCastingEnabled && returnType.equalsIgnoreCase("boolean") && !CorbaReturnType.equalsIgnoreCase("boolean")) {
            s = s + " == 0 ? false : true";
        }
        s = s + ";";
        out.println(s, 3);
        for (j = 0; j < params.length; ++j) {
            boolean HlistToOctetSeq;
            paramType = CodeGenerator.convertType(params[j].getName());
            CorbaMethodParameter = "";
            if (CorbaMethodParameters != null && j < CorbaMethodParameters.length) {
                CorbaMethodParameter = CodeGenerator.convertType(CorbaMethodParameters[j].getName());
            }
            stringArrayToHlist = paramType.equals("java.lang.String[]") && CorbaMethodParameter.equals("double");
            HlistToDouble = paramType.equals("com.sas.collection.hlist.HListInterface") && CorbaMethodParameter.equals("double");
            Hlist1DArrayToDouble = paramType.equals("com.sas.collection.hlist.HListInterface[]") && CorbaMethodParameter.equals("double");
            Hlist2DArrayToDouble = paramType.equals("com.sas.collection.hlist.HListInterface[][]") && CorbaMethodParameter.equals("double");
            boolean bl = HlistToOctetSeq = paramType.equals("com.sas.collection.hlist.HListInterface") && CorbaMethodParameter.equals("com.sas.iom.SASIOMDefs.OctetSeqHolder");
            if ((HlistToDouble || stringArrayToHlist) && (parameterDirections[j] & 2) != 0) {
                out.println("marshalListParamIn(listidHolder" + (j + 1) + ".value, p" + (j + 1) + ");", 3);
                continue;
            }
            if (Hlist1DArrayToDouble && (parameterDirections[j] & 2) != 0) {
                out.println("marshalList1DArrayParamIn(listidsHolder" + (j + 1) + ".value, p" + (j + 1) + ");", 3);
                continue;
            }
            if (Hlist2DArrayToDouble && (parameterDirections[j] & 2) != 0) {
                out.println("marshalList2DArrayParamIn(listidsHolder" + (j + 1) + ".value, p" + (j + 1) + ");", 3);
                continue;
            }
            if (stringArrayToHlist && (parameterDirections[j] & 2) != 0) {
                out.println("marshalListParamIn(listidHolder" + (j + 1) + ".value, p" + (j + 1) + "Hlist);", 3);
                out.println("p" + (j + 1) + " = hListToStringArray(p" + (j + 1) + "Hlist);", 3);
                continue;
            }
            if (HlistToOctetSeq && (parameterDirections[j] & 2) != 0) {
                out.println("p" + (j + 1) + " = ByteArrayToHList(p" + (j + 1) + "OctetSeqHolder.value);", 3);
                continue;
            }
            if (paramType.equals("int") && CorbaMethodParameter.equals("org.omg.CORBA.DoubleHolder")) {
                out.println("p" + (j + 1) + " = (int)p" + (j + 1) + "DoubleHolder.value;", 3);
                continue;
            }
            if (!paramType.equals("java.lang.String") || !CorbaMethodParameter.equals("org.omg.CORBA.StringHolder")) continue;
            out.println("p" + (j + 1) + " = p" + (j + 1) + "StringHolder.value;", 3);
        }
        if (ret.equals("com.sas.collection.hlist.HListInterface")) {
            if (CorbaReturnType.equals("double")) {
                out.println("value = marshalListInStart( returnListId );", 3);
                out.println("marshalListInStop( returnListId );", 3);
            } else if (CorbaReturnType.equals("byte[]")) {
                out.println("com.sas.collection.hlist.HListInterface hlistRetValue = ByteArrayToHList(returnByteArray);", 3);
                out.println("value = hlistRetValue;", 3);
            }
        } else if (ret.equals("com.sas.collection.hlist.HListInterface[]")) {
            if (CorbaReturnType.equals("double[]")) {
                out.println("value = marshalList1DArrayInStart( returnListIds );", 3);
                out.println("marshalList1DArrayInStop( returnListIds );", 3);
            } else if (CorbaReturnType.equals("byte[][]")) {
                out.println("com.sas.collection.hlist.HListInterface[] hlistRetValue = ByteArray2dToHListArray(returnByteArray2d);", 3);
                out.println("value = hlistRetValue;", 3);
            }
        } else if (ret.equals("com.sas.collection.hlist.HListInterface[][]")) {
            out.println("value = marshalList2DArrayInStart( returnListIds );", 3);
            out.println("marshalList2DArrayInStop( returnListIds );", 3);
        } else if (hlistToStringArray) {
            if (CorbaReturnType.equals("double")) {
                out.println("com.sas.collection.hlist.HListInterface hlistRetValue = marshalListInStart( returnListId );", 3);
                out.println("marshalListInStop( returnListId );", 3);
            } else if (CorbaReturnType.equals("byte[]")) {
                out.println("com.sas.collection.hlist.HListInterface hlistRetValue = ByteArrayToHList(returnByteArray);", 3);
            }
            out.println("value = hListToStringArray(hlistRetValue);", 3);
        } else if (hlistToDoubleArray) {
            if (CorbaReturnType.equals("double")) {
                out.println("com.sas.collection.hlist.HListInterface hlistRetValue = marshalListInStart( returnListId );", 3);
                out.println("marshalListInStop( returnListId );", 3);
            } else if (CorbaReturnType.equals("byte[]")) {
                out.println("com.sas.collection.hlist.HListInterface hlistRetValue = ByteArrayToHList(returnByteArray);", 3);
            }
            out.println("value = hListToDoubleArray(hlistRetValue);", 3);
        }
        for (j = 0; j < params.length; ++j) {
            paramType = CodeGenerator.convertType(params[j].getName());
            CorbaMethodParameter = "";
            if (CorbaMethodParameters != null && j < CorbaMethodParameters.length) {
                CorbaMethodParameter = CodeGenerator.convertType(CorbaMethodParameters[j].getName());
            }
            stringArrayToHlist = paramType.equals("java.lang.String[]") && CorbaMethodParameter.equals("double");
            HlistToDouble = paramType.equals("com.sas.collection.hlist.HListInterface") && CorbaMethodParameter.equals("double");
            Hlist1DArrayToDouble = paramType.equals("com.sas.collection.hlist.HListInterface[]") && CorbaMethodParameter.equals("double");
            boolean bl = Hlist2DArrayToDouble = paramType.equals("com.sas.collection.hlist.HListInterface[][]") && CorbaMethodParameter.equals("double");
            if (HlistToDouble || stringArrayToHlist) {
                out.println("marshalListOutStop(listidHolder" + (j + 1) + ".value);", 3);
                continue;
            }
            if (Hlist1DArrayToDouble) {
                out.println("marshalList1DArrayOutStop(listidsHolder" + (j + 1) + ".value );", 3);
                continue;
            }
            if (!Hlist2DArrayToDouble) continue;
            out.println("marshalList2DArrayOutStop(listidsHolder" + (j + 1) + ".value );", 3);
        }
        this.m_tm.generateMethodCodeTrailer(source, method, methodName, out);
    }
}

