/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorBaseTarget;
import com.sas.rmi.CodeGeneratorOutputStream;
import com.sas.rmi.IDLTemplate;
import com.sas.rmi.Template;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class IDLGeneratorTarget
extends CodeGeneratorBaseTarget {
    int m_modules = 0;
    Hashtable m_types = new Hashtable();

    @Override
    public String getGeneratorName() {
        return "IDL";
    }

    public IDLGeneratorTarget() {
        this.m_types.put("void", "void");
        this.m_types.put("java.lang.String", "string");
        this.m_types.put("boolean", "boolean");
        this.m_types.put("char", "char");
        this.m_types.put("byte", "octet");
        this.m_types.put("short", "short");
        this.m_types.put("int", "long");
        this.m_types.put("float", "float");
        this.m_types.put("double", "double");
        this.m_types.put("java.lang.String[]", "string_array");
        this.m_types.put("boolean[]", "boolean_array");
        this.m_types.put("char[]", "char_array");
        this.m_types.put("byte[]", "byte_array");
        this.m_types.put("short[]", "short_array");
        this.m_types.put("int[]", "int_array");
        this.m_types.put("float[]", "float_array");
        this.m_types.put("double[]", "double_array");
    }

    @Override
    public Template getTemplate() {
        return new IDLTemplate();
    }

    @Override
    public String getTargetName(String sourceName) {
        return sourceName + "CORBA";
    }

    @Override
    public String getFileExtension() {
        return ".idl";
    }

    @Override
    public void generateMethodCode(Class source, Method method, CodeGeneratorOutputStream out) throws Exception {
        Class<?>[] params = method.getParameterTypes();
        Class<?> rt = method.getReturnType();
        String ret = CodeGenerator.convertType(rt.getName());
        String IDLType = this.getIDLType(ret);
        if (IDLType == null) {
            throw new Exception("Invalid return type: " + ret);
        }
        String closing = "";
        if (params.length == 0) {
            closing = ");";
        }
        String methodName = method.getName();
        methodName = this.convertName(methodName);
        out.println(IDLType + " " + methodName + "(" + closing, 1);
        for (int j = 0; j < params.length; ++j) {
            String s = CodeGenerator.convertType(params[j].getName());
            IDLType = this.getIDLType(s);
            if (IDLType == null) {
                throw new Exception("Invalid parameter type for " + method.getName() + ": " + params[j].getName());
            }
            s = "in " + IDLType + " p" + (j + 1);
            s = j == params.length - 1 ? s + ");" : s + ",";
            out.println(s, 3);
        }
    }

    private String getIDLType(String javaType) {
        String s = (String)this.m_types.get(javaType);
        if (s == null) {
            s = "byte_array";
        }
        return s;
    }

    @Override
    public boolean generateTagCode(Class source, String tag, CodeGeneratorOutputStream out) throws Exception {
        boolean rc = false;
        if (tag.equalsIgnoreCase("MODULE")) {
            String name = source.getName();
            String packageName = null;
            int pos = name.lastIndexOf(".");
            if (pos >= 0) {
                packageName = name.substring(0, pos);
            }
            while (packageName != null) {
                String module;
                pos = packageName.indexOf(".");
                if (pos < 0) {
                    module = packageName;
                    packageName = null;
                } else {
                    module = packageName.substring(0, pos);
                    packageName = packageName.substring(pos + 1);
                }
                out.println("module " + module + " {", 0);
                ++this.m_modules;
            }
            this.generatePreamble(source, out);
            rc = true;
        } else if (tag.equalsIgnoreCase("ENDMODULE")) {
            while (this.m_modules > 0) {
                out.println("};");
                --this.m_modules;
            }
            rc = true;
        }
        return rc;
    }

    private void generatePreamble(Class source, CodeGeneratorOutputStream out) throws Exception {
        Method[] methods = source.getMethods();
        Hashtable<String, Method> typedefs = new Hashtable<String, Method>();
        boolean hadOne = false;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params = methods[i].getParameterTypes();
            Class<?> rt = methods[i].getReturnType();
            String ret = CodeGenerator.convertType(rt.getName());
            if (typedefs.get(ret) == null) {
                hadOne |= this.generateSequenceTypedef(ret, out);
                typedefs.put(ret, methods[i]);
            }
            for (int j = 0; j < params.length; ++j) {
                String p = CodeGenerator.convertType(params[j].getName());
                if (typedefs.get(p) != null) continue;
                hadOne |= this.generateSequenceTypedef(p, out);
                typedefs.put(p, methods[i]);
            }
        }
        if (hadOne) {
            out.println("");
        }
    }

    private boolean generateSequenceTypedef(String type, CodeGeneratorOutputStream out) throws Exception {
        boolean rc = false;
        if (type.endsWith("[]")) {
            String s = type.substring(0, type.length() - 2);
            if (s.endsWith("[]")) {
                return false;
            }
            String idlType = this.getIDLType(s);
            if (idlType == null) {
                return false;
            }
            String typedefName = this.getIDLType(type);
            if (typedefName == null) {
                return false;
            }
            out.println("typedef sequence <" + idlType + "> " + typedefName + ";");
            rc = true;
        }
        return rc;
    }

    @Override
    public boolean generatesInterfaceCode() {
        return true;
    }
}

