/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.HttpSendInputStream;
import com.sas.rmi.HttpSendOutputStream;
import com.sas.rmi.Logger;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;

class HttpSendSocket
extends Socket {
    protected String host;
    protected int port;
    protected URL url;
    protected URLConnection conn = null;
    protected InputStream in = null;
    protected OutputStream out = null;
    protected HttpSendInputStream inNotifier;
    protected HttpSendOutputStream outNotifier;

    public HttpSendSocket(String host, int port, URL url) throws IOException {
        super((SocketImpl)null);
        Logger.p(this, "<init>: host = " + host + ", port = " + port + ", url = " + url);
        this.host = host;
        this.port = port;
        this.url = url;
        this.inNotifier = new HttpSendInputStream(null, this);
        this.outNotifier = new HttpSendOutputStream(this.writeNotify(), this);
    }

    public HttpSendSocket(String host, int port) throws IOException {
        this(host, port, new URL("http", host, port, "/"));
    }

    public HttpSendSocket(InetAddress address, int port) throws IOException {
        this(address.getHostName(), port);
    }

    public boolean isReusable() {
        Logger.p(this, "isReusable");
        return false;
    }

    public synchronized OutputStream writeNotify() throws IOException {
        if (this.conn != null) {
            throw new IOException("attempt to write on HttpSendSocket after request has been sent");
        }
        this.conn = this.url.openConnection();
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        this.conn.setRequestProperty("Content-type", "application/octet-stream");
        this.inNotifier.deactivate();
        this.in = null;
        this.out = this.conn.getOutputStream();
        return this.out;
    }

    public synchronized InputStream readNotify() throws IOException {
        Logger.p(this, "readNotify: sending request and activating input stream");
        this.outNotifier.deactivate();
        this.out.close();
        this.out = null;
        try {
            this.in = this.conn.getInputStream();
        }
        catch (IOException e) {
            Logger.p(this, "readNotify: failed to get input stream, exception: ");
            e.printStackTrace();
            throw new IOException("HTTP request failed");
        }
        String contentType = this.conn.getContentType();
        if (contentType == null || !this.conn.getContentType().equals("application/octet-stream")) {
            if (contentType == null) {
                Logger.p(this, "readNotify: missing content type in response");
            } else {
                Logger.p(this, "readNotify: invalid content type in response: " + contentType);
            }
            Logger.p(this, "readNotify: response body: ");
            try {
                String line;
                DataInputStream din = new DataInputStream(this.in);
                while ((line = din.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw new IOException("HTTP request failed");
        }
        return this.in;
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getLocalPort() {
        return -1;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inNotifier;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outNotifier;
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    @Override
    public void setSoLinger(boolean on, int val) throws SocketException {
    }

    @Override
    public int getSoLinger() throws SocketException {
        return -1;
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return 0;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    @Override
    public String toString() {
        return "HttpSendSocket[host=" + this.host + ",port=" + this.port + ",url=" + this.url + "]";
    }
}

