/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.HttpTunnel;
import com.sas.rmi.PacketOutputStream;
import com.sas.rmi.RemoteException;
import com.sas.security.BaseSecuritySupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class HttpEventListener
implements Runnable {
    HttpTunnel m_http;
    boolean m_debug;
    String m_url;
    String m_cgihost;
    int m_cgiport;
    String m_serverhost;
    int m_serverport;
    Thread m_thread;
    Socket m_socket = null;
    DataInputStream m_in;
    DataOutputStream m_out;
    DataOutputStream m_socketOut;
    int m_listenerHandle = 0;
    int m_queueHandle = 0;

    public HttpEventListener(String tunnelURL, String host, int port, boolean debug) throws IOException {
        this.m_url = tunnelURL;
        this.m_debug = debug;
        this.m_serverhost = host;
        this.m_serverport = port;
        if (this.m_debug) {
            System.out.println("Creating new HttpEventListener");
        }
        this.m_http = new HttpTunnel();
        this.m_http.setDebug(this.m_debug);
        this.m_http.setInfo("(LISTEN) ");
        this.m_http.setup(this.m_url, this.m_serverhost, this.m_serverport);
        this.m_in = this.m_http.getInputStream();
        this.m_out = this.m_http.getOutputStream();
        this.m_out = new DataOutputStream(new PacketOutputStream(this.m_out, this.m_debug));
        this.m_http.start();
        if (this.m_debug) {
            System.out.println("Getting http server info");
        }
        this.m_out.writeByte(56);
        this.m_out.flush();
        this.m_in.readInt();
        this.m_in.readByte();
        byte ack = this.m_in.readByte();
        switch (ack) {
            case 40: {
                break;
            }
            case 53: {
                this.getException();
                break;
            }
            default: {
                throw new RemoteException("Expecting ACK, got " + ack);
            }
        }
        this.m_cgihost = this.m_in.readUTF();
        if (this.m_debug) {
            System.out.println("http server: " + this.m_cgihost);
        }
    }

    public void setup(String host, int port) throws IOException {
        if (this.m_debug) {
            System.out.println("Sending events to " + host + ":" + port);
        }
        this.m_socket = new Socket(host, port);
        this.m_socketOut = new DataOutputStream(this.m_socket.getOutputStream());
    }

    protected void registerListener() throws IOException {
        boolean goodPort = false;
        this.m_cgiport = (int)(System.currentTimeMillis() % 3976L) + 1024;
        block10: while (!goodPort) {
            if (this.m_debug) {
                System.out.println("Trying port " + this.m_cgiport);
            }
            this.m_out.writeByte(57);
            this.m_out.writeInt(this.m_cgiport);
            this.m_out.flush();
            this.m_in.readInt();
            this.m_in.readByte();
            byte ack = this.m_in.readByte();
            switch (ack) {
                case 40: {
                    if (this.m_debug) {
                        System.out.println("Port " + this.m_cgiport + " was good");
                    }
                    goodPort = true;
                    continue block10;
                }
                case 41: {
                    this.m_cgiport = this.m_in.readInt();
                    if (!this.m_debug) continue block10;
                    System.out.println("Port " + this.m_cgiport + " was no good");
                    continue block10;
                }
                case 53: {
                    this.getException();
                    continue block10;
                }
            }
            throw new RemoteException("Unknown ack: " + ack);
        }
        HttpTunnel t = new HttpTunnel();
        t.setDebug(this.m_debug);
        t.setInfo("(HTTP EVENT) ");
        t.setup(this.m_url, this.m_serverhost, this.m_serverport);
        DataOutputStream t_out = t.getOutputStream();
        t_out = new DataOutputStream(new PacketOutputStream(t_out, this.m_debug));
        DataInputStream t_in = t.getInputStream();
        t.start();
        if (this.m_debug) {
            System.out.println("Registering listener for " + this.m_cgihost + ":" + this.m_cgiport);
        }
        t_out.writeByte(54);
        t_out.writeUTF(this.m_cgihost);
        t_out.writeInt(this.m_cgiport);
        t_out.writeByte(1);
        t_out.writeInt(600);
        t_out.flush();
        t_in.readInt();
        t_in.readByte();
        byte ack = t_in.readByte();
        switch (ack) {
            case 40: {
                break;
            }
            case 53: {
                this.getException();
                break;
            }
            case 41: {
                throw new RemoteException("Server denied listener registration");
            }
            default: {
                throw new RemoteException("Unknown opcode " + ack);
            }
        }
        this.m_listenerHandle = t_in.readInt();
        if (this.m_debug) {
            System.out.println("Listener handle = " + this.m_listenerHandle);
        }
        this.m_queueHandle = t_in.readInt();
        if (this.m_debug) {
            System.out.println("Queue handle = " + this.m_queueHandle);
        }
        t.stop();
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
        }
    }

    public void stop() {
        try {
            if (this.m_thread != null) {
                this.m_thread.stop();
                this.m_thread = null;
            }
            if (this.m_socket != null) {
                this.m_socket.close();
                this.m_socket = null;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        byte[] buf = new byte[4096];
        while (true) {
            try {
                block3: while (true) {
                    this.registerListener();
                    if (this.m_debug) {
                        System.out.println("Waiting for HTTP event");
                    }
                    int packetLen = this.m_in.readInt();
                    if (this.m_debug) {
                        System.out.println("Got HTTP event (len=" + packetLen + ")");
                    }
                    this.m_socketOut.writeInt(packetLen);
                    while (true) {
                        if (packetLen <= 0) continue block3;
                        int len = packetLen;
                        if (len > buf.length) {
                            len = buf.length;
                        }
                        int lenRead = this.m_in.read(buf);
                        this.m_socketOut.write(buf, 0, lenRead);
                        packetLen -= lenRead;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                if (this.m_debug) {
                    ex.printStackTrace();
                }
                this.stop();
                continue;
            }
            break;
        }
    }

    protected void finalize() throws Exception {
    }

    protected void getException() throws IOException {
        String msg;
        int code;
        boolean failed = true;
        try {
            if (this.m_debug) {
                System.out.println("EXCEPTION");
                long l = System.currentTimeMillis();
            }
            code = this.m_in.readInt();
            msg = this.m_in.readUTF();
            if (this.m_debug) {
                System.out.println(" Got code " + code);
                System.out.println(" Got message " + msg);
            }
            failed = false;
        }
        catch (Exception ex) {
            if (this.m_debug) {
                ex.printStackTrace();
            }
            throw new IOException(ex.getMessage());
        }
        if (!failed) {
            throw new RemoteException(msg, code);
        }
    }
}

