/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.HttpReceiveSocket;
import com.sas.rmi.Logger;
import com.sas.rmi.WrappedSocket;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class HttpAwareServerSocket
extends ServerSocket {
    public HttpAwareServerSocket(int port) throws IOException {
        super(port);
    }

    public HttpAwareServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    @Override
    public Socket accept() throws IOException {
        Socket socket = super.accept();
        BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
        Logger.p(this, "accept: socket accepted (checking for POST)");
        in.mark(4);
        boolean isHttp = in.read() == 80 && in.read() == 79 && in.read() == 83 && in.read() == 84;
        in.reset();
        Logger.p(this, "accept: " + (isHttp ? "POST found, HTTP socket returned" : "POST not found, direct socket returned"));
        if (isHttp) {
            return new HttpReceiveSocket(socket, in, null);
        }
        return new WrappedSocket(socket, in, null);
    }

    @Override
    public String toString() {
        return "HttpAware" + super.toString();
    }
}

