/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.CodeGenerator;
import com.sas.rmi.CodeGeneratorOptions;
import com.sas.rmi.CodeGeneratorTarget;
import com.sas.rmi.RocfClass;
import java.io.PrintStream;
import java.util.Vector;

public class GeneratorBase {
    public void doit(String[] args, CodeGeneratorTarget target) {
        boolean failed = false;
        int n = args.length;
        int namePos = 0;
        boolean overwrite = false;
        boolean verbose = false;
        String model = null;
        String dir = null;
        Vector<String> myArgs = new Vector<String>();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (args[i].equals("-o")) {
                    ++namePos;
                    overwrite = true;
                    continue;
                }
                if (args[i].equals("-v")) {
                    ++namePos;
                    verbose = true;
                    continue;
                }
                if (args[i].equals("-m")) {
                    if (i + 1 < n) {
                        model = args[i + 1];
                        namePos += 2;
                        continue;
                    }
                    failed = true;
                    break;
                }
                if (args[i].equals("-d")) {
                    if (i + 1 < n) {
                        dir = args[i + 1];
                        namePos += 2;
                        continue;
                    }
                    failed = true;
                    break;
                }
                if (!args[i].startsWith("-")) continue;
                myArgs.addElement(args[i]);
                ++namePos;
            }
        } else {
            n = namePos + 2;
        }
        if (failed || namePos != n - 1) {
            System.out.println("\nUsage: Generator [-options] <class name>");
            System.out.println("\nwhere options include:");
            System.out.println("    -d        Directory");
            System.out.println("    -m        Specifies model name");
            System.out.println("    -o        Overwrite existing files");
            System.out.println("    -v        Verbose output");
            failed = true;
        }
        Class c = null;
        if (!failed) {
            c = this.getClass(args[namePos], target.generateFromInterface());
            if (c == null) {
                failed = true;
            }
            if (!failed && target.implementationMustExist() && this.getClass(args[namePos], false) == null) {
                return;
            }
        }
        if (!failed) {
            PrintStream out = null;
            if (verbose) {
                out = System.out;
            }
            CodeGeneratorOptions options = new CodeGeneratorOptions();
            options.setOverwriteSource(overwrite);
            options.setVerboseStream(out);
            options.setDirectory(dir);
            if (myArgs.size() > 0) {
                String[] s1 = new String[myArgs.size()];
                for (int i = 0; i < myArgs.size(); ++i) {
                    s1[i] = (String)myArgs.elementAt(i);
                    if (!verbose) continue;
                    System.out.println("Passing " + s1[i]);
                }
                options.setArgs(s1);
            }
            CodeGenerator generator = new CodeGenerator(c, target, options);
            try {
                failed = generator.generate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                failed = true;
            }
        }
        if (failed) {
            System.out.println("\nCode generator failed.");
            if (!verbose) {
                System.out.println("\nUse -v switch for more details");
            }
        }
    }

    private Class getClass(String name, boolean fromInterface) {
        Class c = null;
        String iName = "Interface";
        boolean isInterface = name.endsWith(iName);
        if (!isInterface && fromInterface) {
            name = name + iName;
            isInterface = true;
        }
        if (isInterface && !fromInterface) {
            name = name.substring(0, name.length() - iName.length());
        }
        if ((c = this.load(name)) == null) {
            System.out.println("Unable to load " + name);
        }
        return c;
    }

    private Class load(String name) {
        Class c = null;
        try {
            c = RocfClass.forName(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }
}

