/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.Component;
import com.sas.awt.util.Util;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.Permuter;
import com.sas.collection.StaticDictionaryInterface;
import com.sas.idesupport.IDEData;
import com.sas.models.DefaultTreeDnDDelegate;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeDnDDelegateInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.ConnectionEditDialog;
import com.sas.rmi.ConnectionSaveAsDialog;
import com.sas.rmi.ConnectionTree;
import com.sas.rmi.PersistedConnectionList;
import com.sas.rmi.RB;
import com.sas.swing.visuals.NodeView;
import com.sas.swing.visuals.TreeView;
import com.sas.text.Message;
import com.sas.util.IndexedSetInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.LabelView;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConnectionListPanel
extends JPanel
implements Customizer,
ActionListener,
ContentsChangedListener,
TreeDnDDelegateInterface,
PropertyChangeListener {
    public static final String RB_KEY = "ConnectionListPanel.";
    protected transient JPanel connectionsPanel;
    protected transient boolean externalPropertyList;
    protected transient PersistedConnectionList propertyList;
    protected transient ConnectionEditDialog editDialog;
    protected transient ConnectionSaveAsDialog copyDialog;
    protected transient JTextField selectedConn;
    protected transient Frame editDialogFrame;
    protected transient JPanel selectedConnPanel;
    protected transient JPanel btnPanel;
    protected transient JButton newBtn;
    protected transient JButton editBtn;
    protected transient JButton deleteBtn;
    protected transient JButton copyBtn;
    protected transient JButton closeBtn;
    protected transient AutoSizingGridLayout btnGridLayout;
    public transient OrderedCollectionInterface readOnlyList = new OrderedCollection();
    public transient OrderedCollectionInterface reservedNamesList;
    protected transient LabelView connectionListLabel;
    protected transient TreeView conTreeView;
    protected transient ConnectionTree connectionTree;

    public ConnectionListPanel() {
        this.setDefaultValues();
    }

    public ConnectionListPanel(Frame frm) {
        this();
        this.editDialogFrame = frm;
        this.readOnlyList = new OrderedCollection();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object eSource = event.getSource();
        if (eSource != this.closeBtn) {
            if (eSource == this.copyBtn) {
                this.copyConnection();
            } else if (eSource == this.newBtn) {
                this.newConnection();
            } else if (eSource == this.editBtn) {
                this.editConnection();
            } else if (eSource == this.deleteBtn) {
                this.deleteConnection();
            }
        }
    }

    public void contentsChanged(ContentsChangedEvent event) {
        NodeView selNode = this.conTreeView.getSelectedNode();
        if (event.getSource() == this.readOnlyList) {
            if (this.deleteBtn == null || this.editBtn == null) {
                return;
            }
            if (selNode != null && (com.sas.util.Util.equal((Object)selNode.getNodeType(), (Object)"persisted") || com.sas.util.Util.equal((Object)selNode.getNodeType(), (Object)"custom"))) {
                this.deleteBtn.setEnabled(!this.readOnlyList.contains((Object)selNode.getNodeText()));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.propertyList == null) {
            return;
        }
        Object source = event.getSource();
        String propertyName = event.getPropertyName();
        if (source == this.conTreeView && com.sas.util.Util.equal((Object)propertyName, (Object)"selectedNode")) {
            Object obj = event.getNewValue();
            if (obj instanceof NodeView) {
                this.selectedNodeChanged((NodeView)obj);
            } else if (obj instanceof NodeView) {
                this.selectedNodeChangedSwing((NodeView)obj);
            }
        }
    }

    protected void selectedNodeChanged(NodeView selNode) {
        if (selNode != null && selNode.isSelected() && (com.sas.util.Util.equal((Object)selNode.getNodeType(), (Object)"persisted") || com.sas.util.Util.equal((Object)selNode.getNodeType(), (Object)"custom"))) {
            String nodeText = selNode.getNodeText();
            this.selectedConn.setText(nodeText);
            if (this.readOnlyList != null && this.readOnlyList.contains((Object)nodeText) && !this.isDeleteable(selNode)) {
                this.deleteBtn.setEnabled(false);
            } else {
                this.deleteBtn.setEnabled(true);
            }
            this.editBtn.setEnabled(true);
            this.copyBtn.setEnabled(true);
        } else {
            this.selectedConn.setText("");
            this.deleteBtn.setEnabled(false);
            this.editBtn.setEnabled(false);
            this.copyBtn.setEnabled(false);
        }
    }

    protected void selectedNodeChangedSwing(NodeView selNode) {
        if (selNode != null && selNode.isSelected() && (com.sas.util.Util.equal((Object)selNode.getNodeType(), (Object)"persisted") || com.sas.util.Util.equal((Object)selNode.getNodeType(), (Object)"custom"))) {
            String nodeText = selNode.getNodeText();
            this.selectedConn.setText(nodeText);
            if (this.readOnlyList != null && this.readOnlyList.contains((Object)nodeText) && !this.isDeleteable(selNode)) {
                this.deleteBtn.setEnabled(false);
            } else {
                this.deleteBtn.setEnabled(true);
            }
            this.editBtn.setEnabled(true);
            this.copyBtn.setEnabled(true);
        } else {
            this.selectedConn.setText("");
            this.deleteBtn.setEnabled(false);
            this.editBtn.setEnabled(false);
            this.copyBtn.setEnabled(false);
        }
    }

    protected void newConnection() {
        NodeView parent;
        NodeView node;
        int beforeCount = this.propertyList.count();
        Connection connection = this.getConnection();
        boolean designState = Component.beansIsDesignTime();
        if (connection != null) {
            Component.beansSetDesignTime((boolean)connection.isDesignTime());
        }
        Connection conn = new Connection();
        conn.setServerArchitecture("IOM");
        Component.beansSetDesignTime((boolean)designState);
        conn.setPersistedName(null);
        if (this.editDialog == null) {
            this.createEditDialog();
        }
        this.editDialog.setTitle(RB.getStringResource(RB_KEY, "editDialog.newConnection.txt"));
        this.editDialog.setObject(conn);
        Util.centerOverWindow(this.editDialog, this);
        this.editDialog.setPropertyList(this.propertyList);
        this.editDialog.setVisible(true);
        int afterCount = this.propertyList.count();
        if (beforeCount < afterCount && (node = (NodeView)(parent = this.getConnectionListParentNode()).getNodeChild(parent.getNodeChildCount() - 1)) != null) {
            this.conTreeView.scrollToNode(node, true);
        }
    }

    protected void editConnection() {
        int beforeCount = this.propertyList.count();
        Connection connection = this.getConnection();
        boolean designState = Component.beansIsDesignTime();
        if (connection != null) {
            Component.beansSetDesignTime((boolean)connection.isDesignTime());
        }
        Connection conn = new Connection();
        Component.beansSetDesignTime((boolean)designState);
        String persistedName = connection.getPersistedName();
        this.propertyList.updateConnectionProperties(conn, persistedName);
        if (this.editDialog == null) {
            this.createEditDialog();
        }
        this.editDialog.setTitle(RB.getStringResource(RB_KEY, "editDialog.editConnection.txt"));
        this.editDialog.setObject(conn);
        Util.centerOverWindow(this.editDialog, this);
        this.editDialog.setPropertyList(this.propertyList);
        this.editDialog.setVisible(true);
        int afterCount = this.propertyList.count();
        if (beforeCount < afterCount) {
            NodeView parent = this.getConnectionListParentNode();
            NodeView node = (NodeView)parent.getNodeChild(parent.getNodeChildCount() - 1);
            if (node != null) {
                this.conTreeView.scrollToNode(node, true);
            }
        } else if (!this.editDialog.wasCancelled()) {
            persistedName = this.editDialog.getPersistedName();
            connection = this.getConnection();
            this.propertyList.updateConnectionProperties(connection, persistedName);
        }
    }

    protected void copyConnection() {
        NodeView parent;
        NodeView node;
        int afterCount;
        Connection connection = this.getConnection();
        int beforeCount = this.propertyList.count();
        if (this.copyDialog == null) {
            this.createCopyDialog();
        }
        Message copyMsg = new Message(RB.getResources(), "ConnectionListPanel.copyDialog.label.txt", (Object)connection.getPersistedName());
        this.copyDialog.setMessageLabel(copyMsg.toString());
        this.copyDialog.setPersistedName(null);
        this.copyDialog.setTitle(RB.getStringResource(RB_KEY, "copyDialog.title.txt"));
        this.copyDialog.setPropertyList(this.propertyList);
        this.copyDialog.pack();
        Util.centerOverWindow(this.copyDialog, this);
        this.copyDialog.setVisible(true);
        String name = this.copyDialog.getPersistedName();
        if (name != null) {
            name = name.trim();
            Connection newConn = new Connection();
            this.propertyList.copyProperties(connection.getProperties(), newConn.getProperties());
            newConn.setPersistedName(name);
            this.propertyList.add(beforeCount, name, newConn.getProperties());
        }
        if (beforeCount < (afterCount = this.propertyList.count()) && (node = (NodeView)(parent = this.getConnectionListParentNode()).getNodeChild(parent.getNodeChildCount() - 1)) != null) {
            this.conTreeView.scrollToNode(node, true);
        }
    }

    protected void deleteConnection() {
        int idx;
        NodeView selNode = this.conTreeView.getSelectedNode();
        if (selNode == null) {
            this.deleteBtn.setEnabled(false);
            return;
        }
        Message msg = new Message(RB.getResources(), "ConnectionListPanel.deleteDialog.message.txt", (Object)selNode.getNodeText());
        int button = JOptionPane.showConfirmDialog(null, msg.toString(), RB.getStringResource(RB_KEY, "deleteDialog.title.txt"), 0);
        if (button != 0) {
            return;
        }
        NodeView parent = this.getConnectionListParentNode();
        int index = parent.getIndex(selNode, 0);
        this.propertyList.removeAt(index);
        int count = this.propertyList.count() - 1;
        int n = idx = count >= index ? index : count;
        if (idx >= 0 && idx < parent.getNodeChildCount()) {
            NodeView node = (NodeView)parent.getNodeChild(idx);
            this.conTreeView.scrollToNode(node, true);
        } else {
            this.conTreeView.scrollToNode(parent, true);
        }
    }

    public Container getSelectedConnectionContainer() {
        return this.selectedConnPanel;
    }

    public Container getButtonContainer() {
        return this.btnPanel;
    }

    public JButton getEditButton() {
        return this.editBtn;
    }

    public JButton getCloseButton() {
        return this.closeBtn;
    }

    public JButton getDeleteButton() {
        return this.deleteBtn;
    }

    public JButton getNewButton() {
        return this.newBtn;
    }

    public JButton getCopyButton() {
        return this.copyBtn;
    }

    protected NodeView getConnectionListParentNode() {
        NodeView root = this.conTreeView.getRoot();
        StaticDictionaryInterface customList = this.connectionTree.getCustomConnectionList();
        PersistedConnectionList persistedList = this.connectionTree.getPersistedConnectionList();
        if (!this.connectionTree.isLoneLevelOneParentDisplayed() && (customList == null && persistedList != null || customList != null && persistedList == null)) {
            return root;
        }
        return (NodeView)root.getNodeChild(0);
    }

    protected boolean isDeleteable(NodeView node) {
        return true;
    }

    private void printContents() {
        System.out.println(" propertyList contents:  ");
        for (int i = 0; i < this.propertyList.count(); ++i) {
            System.out.println(i + " key   = " + this.propertyList.getKey(i));
            System.out.println(i + " value = " + System.identityHashCode(this.propertyList.get(i)));
            System.out.println(i + "    persistedName = " + ((Properties)this.propertyList.get(i)).get(Connection.PERSISTEDNAME));
        }
        System.out.println(" ");
    }

    public void setDefaultValues() {
        this.externalPropertyList = false;
        this.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 0, 10, true, true, true));
        ((AutoSizingGridLayout)this.getLayout()).setRemainderRow(1);
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new AutoSizingGridLayout(1, 2, 10, 0, true, true, true));
        ((AutoSizingGridLayout)panel1.getLayout()).setRemainderColumn(1);
        this.add(panel1);
        this.connectionsPanel = new JPanel();
        AutoSizingGridLayout layout1 = new AutoSizingGridLayout(0, 1, 0, 5, true, true, true);
        this.connectionsPanel.setLayout((LayoutManager)layout1);
        layout1.setRemainderRow(2);
        panel1.add(this.connectionsPanel);
        this.connectionListLabel = new LabelView();
        this.connectionListLabel.initialize();
        this.connectionListLabel.setWordWrap(true);
        this.connectionListLabel.setVerticalAlignment(4);
        this.connectionsPanel.add(this.connectionListLabel);
        this.connectionTree = this.newConnectionTree();
        this.conTreeView = ConnectionTree.getConnectionSwingTreeView(this.connectionTree);
        this.conTreeView.setDnDDelegate(this);
        this.conTreeView.setPreferredSize(new Dimension(200, 150));
        this.connectionsPanel.add(this.conTreeView);
        this.btnPanel = new JPanel();
        this.btnGridLayout = new AutoSizingGridLayout(0, 1, 5, 5, true, false, true);
        this.btnPanel.setLayout((LayoutManager)this.btnGridLayout);
        panel1.add(this.btnPanel);
        this.closeBtn = new JButton(RB.getStringResource(RB_KEY, "closeBtn.txt"));
        this.newBtn = new JButton(RB.getStringResource(RB_KEY, "newBtn.txt"));
        this.editBtn = new JButton(RB.getStringResource(RB_KEY, "editBtn.txt"));
        this.deleteBtn = new JButton(RB.getStringResource(RB_KEY, "deleteBtn.txt"));
        this.copyBtn = new JButton(RB.getStringResource(RB_KEY, "copyBtn.txt"));
        this.btnPanel.add(this.newBtn);
        this.btnPanel.add(this.editBtn);
        this.btnPanel.add(this.copyBtn);
        this.btnPanel.add(this.deleteBtn);
        this.selectedConnPanel = new JPanel();
        AutoSizingGridLayout layout2 = new AutoSizingGridLayout(2, 1, 0, 5, true, false, true);
        layout2.setInterlockedColumnContainers(new Container[]{this.connectionsPanel});
        layout1.setInterlockedColumnContainers(new Container[]{this.selectedConnPanel});
        this.selectedConnPanel.setLayout((LayoutManager)layout2);
        JLabel selectedConnLabel = new JLabel(RB.getStringResource(RB_KEY, "selectedConnLabel.txt"));
        this.selectedConn = new JTextField();
        this.selectedConn.setEnabled(false);
        this.selectedConnPanel.add(selectedConnLabel);
        this.selectedConnPanel.add(this.selectedConn);
        this.add(this.selectedConnPanel);
        this.addListeners();
    }

    protected void addListeners() {
        this.closeBtn.addActionListener(this);
        this.newBtn.addActionListener(this);
        this.editBtn.addActionListener(this);
        this.copyBtn.addActionListener(this);
        this.deleteBtn.addActionListener(this);
        this.conTreeView.addPropertyChangeListener(this);
    }

    protected ConnectionTree newConnectionTree() {
        return new ConnectionTree();
    }

    public void setConnection(Connection connection) {
        if (connection != null) {
            String name = connection.getPersistedName();
            if (this.propertyList == null) {
                this.createPropertyList();
            }
            NodeView parent = this.getConnectionListParentNode();
            if (this.propertyList.containsKey(name)) {
                Object props = this.propertyList.get(name);
                int index = this.propertyList.getIndex(props, 0);
                NodeView node = (NodeView)parent.getNodeChild(index);
                this.conTreeView.scrollToNode(node, true);
            } else {
                Properties customProps = new Properties();
                this.propertyList.copyProperties(connection.getProperties(), customProps);
                int count = this.propertyList.count();
                this.propertyList.add(count, name, customProps);
                ++count;
                if (parent.getNodeChildCount() != 0) {
                    NodeView node = (NodeView)parent.getNodeChild(count - 1);
                    this.conTreeView.scrollToNode(node, true);
                }
            }
            NodeView selNode = this.conTreeView.getSelectedNode();
            if (com.sas.util.Util.equal((Object)selNode.getNodeType(), (Object)"persisted")) {
                if (this.readOnlyList != null && this.readOnlyList.contains((Object)selNode.getNodeText())) {
                    this.deleteBtn.setEnabled(false);
                } else {
                    this.deleteBtn.setEnabled(true);
                }
            }
        } else {
            NodeView selNode;
            if (this.propertyList == null) {
                this.createPropertyList();
            }
            if (this.propertyList.count() > 0 && (selNode = this.conTreeView.getSelectedNode()) != null) {
                selNode.setSelected(false);
            }
        }
        this.connectionTree.setConnection(connection);
    }

    public Connection getConnection() {
        return this.connectionTree.getConnection();
    }

    @Override
    public void setObject(Object bean) {
        if (bean != null && bean instanceof Connection) {
            this.setConnection((Connection)bean);
        } else {
            NodeView selNode;
            if (this.propertyList == null) {
                this.createPropertyList();
            }
            if (this.propertyList.count() > 0 && (selNode = this.conTreeView.getSelectedNode()) != null) {
                selNode.setSelected(false);
            }
        }
    }

    protected void createCopyDialog() {
        if (this.copyDialog == null) {
            Frame parentFrame = Util.getParentFrame(this);
            this.copyDialog = parentFrame != null ? new ConnectionSaveAsDialog(parentFrame) : new ConnectionSaveAsDialog(new Frame());
            this.copyDialog.setTitle(RB.getStringResource(RB_KEY, "copyDialog.title.txt"));
            this.copyDialog.setModal(true);
            this.copyDialog.pack();
        }
        this.copyDialog.setReservedNamesList(this.reservedNamesList);
        this.copyDialog.setPropertyList(this.propertyList);
        this.copyDialog.setPersistedName("");
    }

    protected void createEditDialog() {
        Frame parentFrame = Util.getParentFrame(this);
        this.editDialog = parentFrame != null ? new ConnectionEditDialog(parentFrame) : (this.editDialogFrame != null ? new ConnectionEditDialog(this.editDialogFrame) : new ConnectionEditDialog(new Frame()));
        this.editDialog.pack();
        this.editDialog.setVisible(false);
        this.editDialog.setModal(true);
        this.editDialog.setReservedNamesList(this.reservedNamesList);
        this.editDialog.setPropertyList(this.propertyList);
    }

    protected void createPropertyList() {
        this.propertyList = new PersistedConnectionList();
        this.propertyList.initialize();
        this.loadProperties();
        this.setPropertyList(this.propertyList);
        this.externalPropertyList = false;
    }

    protected void loadProperties() {
        try {
            String localFilePath = IDEData.getConnectionsFile();
            if (localFilePath == null) {
                localFilePath = "./LocalConnections.txt";
            }
            this.propertyList.setFilePathName(localFilePath);
            this.propertyList.loadProperties();
        }
        catch (IOException e) {
            Message exceptionMessage = new Message(RB.getResources(), "ConnectionCustomizer.loadConnection.ex.txt", (Object)e.toString());
            System.out.println(exceptionMessage.toString());
        }
    }

    protected void saveProperties() {
        try {
            boolean isSaved = this.propertyList.saveProperties();
            if (!isSaved) {
                String filePath = this.propertyList.getFilePathName();
                Message errorMessage = new Message(RB.getResources(), "ConnectionListPanel.writeConflictDialog.errorMessage.txt", (Object)filePath);
                JOptionPane.showMessageDialog(null, errorMessage.toString(), RB.getStringResource(RB_KEY, "writeConflictDialog.title.txt"), 0);
            }
        }
        catch (IOException e) {
            Message exceptionMessage = new Message(RB.getResources(), "ConnectionCustomizer.saveConnection.ex.txt", (Object)e.toString());
            System.out.println(exceptionMessage.toString());
        }
    }

    public PersistedConnectionList getPropertyList() {
        return this.propertyList;
    }

    public void setPropertyList(PersistedConnectionList propList) {
        this.propertyList = propList;
        if (this.propertyList != null) {
            NodeView selNode;
            if (this.editDialog != null) {
                this.editDialog.setPropertyList(this.propertyList);
            }
            this.connectionTree.setPersistedConnectionList(this.propertyList);
            NodeView parent = this.getConnectionListParentNode();
            if (parent != null) {
                NodeView nodeChild;
                parent.setExpanded(true);
                if (parent.isVisible()) {
                    parent.setSelected(true);
                } else if (parent.getNodeChildCount() > 0 && (nodeChild = (NodeView)parent.getNodeChild(0)) != null) {
                    nodeChild.setSelected(true);
                }
            }
            if ((selNode = this.conTreeView.getSelectedNode()) == null) {
                this.editBtn.setEnabled(false);
                this.copyBtn.setEnabled(false);
                this.deleteBtn.setEnabled(false);
            }
            this.externalPropertyList = true;
        }
    }

    public java.awt.Component getConnectionsListView() {
        return this.conTreeView;
    }

    public String getConnectionListLabel() {
        return this.connectionListLabel.getText();
    }

    public void setConnectionListLabel(String txt) {
        this.connectionListLabel.setText(txt);
        this.invalidate();
        this.validate();
    }

    public OrderedCollectionInterface getReadOnlyList() {
        return this.readOnlyList;
    }

    public void setReadOnlyList(OrderedCollectionInterface rdOnly) {
        if (this.readOnlyList != null) {
            this.readOnlyList.removeContentsChangedListener((ContentsChangedListener)this);
        }
        this.readOnlyList = rdOnly;
        this.readOnlyList.addContentsChangedListener((ContentsChangedListener)this);
    }

    public OrderedCollectionInterface getReservedNamesList() {
        return this.reservedNamesList;
    }

    public void setReservedNamesList(OrderedCollectionInterface reservedNames) {
        if (this.editDialog == null) {
            this.createEditDialog();
        }
        this.editDialog.setReservedNamesList(reservedNames);
        this.reservedNamesList = reservedNames;
    }

    @Override
    public void setVisible(boolean newValue) {
        if (!newValue) {
            this.customizerClosing();
        }
        super.setVisible(newValue);
    }

    public void customizerClosing() {
        this.conTreeView.removePropertyChangeListener(this);
        this.readOnlyList.removeContentsChangedListener((ContentsChangedListener)this);
        if (!this.externalPropertyList) {
            this.saveProperties();
        }
    }

    @Override
    public boolean isDraggable(SimpleNodeInterface[] nodePath) {
        boolean draggable = DefaultTreeDnDDelegate.defaultDelegate.isDraggable(nodePath);
        if (draggable) {
            NodeInterface node = (NodeInterface)nodePath[nodePath.length - 1];
            draggable = com.sas.util.Util.equal((Object)node.getNodeType(), (Object)"persisted");
        }
        return draggable;
    }

    @Override
    public boolean isDropSite(SimpleNodeInterface[] dragNodePath, SimpleNodeInterface[] dropNodeParentPath, int index) {
        boolean dropSite;
        boolean bl = dropSite = DefaultTreeDnDDelegate.defaultDelegate.isDropSite(dragNodePath, dropNodeParentPath, index) && dragNodePath.length > 1;
        if (dropSite) {
            dropSite = dragNodePath[dragNodePath.length - 2] == dropNodeParentPath[dropNodeParentPath.length - 1];
        }
        return dropSite;
    }

    @Override
    public boolean performDrop(SimpleNodeInterface[] dragNodePath, SimpleNodeInterface[] dropNodeParentPath, int position) {
        if (this.isPreviousSibling(dragNodePath, dropNodeParentPath, position)) {
            --position;
        }
        int index = this.getIndex(dragNodePath);
        int offset = position == -1 ? this.propertyList.count() - 1 - index : position - index;
        this.propertyList.disableEvents();
        Permuter.move((IndexedSetInterface)this.propertyList, (int)index, (int)offset);
        this.propertyList.enableEvents();
        return true;
    }

    protected boolean isPreviousSibling(SimpleNodeInterface[] dragNodePath, SimpleNodeInterface[] dropNodeParentPath, int position) {
        if (dragNodePath.length - 1 != dropNodeParentPath.length && com.sas.util.Util.unequal((Object)dragNodePath[dragNodePath.length - 2], (Object)dropNodeParentPath[dropNodeParentPath.length - 1])) {
            return false;
        }
        if (position == 0) {
            return false;
        }
        SimpleNodeInterface parent = dropNodeParentPath[dropNodeParentPath.length - 1];
        SimpleNodeInterface node = dragNodePath[dragNodePath.length - 1];
        for (int i = 0; i < position; ++i) {
            if (!com.sas.util.Util.equal((Object)node, (Object)parent.getNodeChild(i))) continue;
            return true;
        }
        return false;
    }

    protected int getIndex(SimpleNodeInterface[] dragNodePath) {
        SimpleNodeInterface parent = dragNodePath[dragNodePath.length - 2];
        SimpleNodeInterface node = dragNodePath[dragNodePath.length - 1];
        int cnt = parent.getNodeChildCount();
        for (int i = 0; i < cnt; ++i) {
            if (parent.getNodeChild(i) != node) continue;
            return i;
        }
        return -1;
    }
}

