/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.awt.util.Util;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.ConnectionEditView;
import com.sas.rmi.ConnectionSaveAsDialog;
import com.sas.rmi.PersistedConnectionList;
import com.sas.rmi.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.Customizer;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConnectionEditDialog
extends JDialog
implements Customizer,
ActionListener,
DocumentListener {
    public static final String RB_KEY = "ConnectionEditDialog.";
    private transient Connection connection;
    private transient JButton saveAsBtn;
    private transient JButton okBtn;
    private transient JButton cancelBtn;
    private transient ConnectionEditView editPanel;
    private transient JTextField connName;
    private transient ConnectionSaveAsDialog saveAsDialog;
    private transient PersistedConnectionList propertyList;
    private transient OrderedCollectionInterface reservedNamesList;
    private transient String origPersistedName;
    private transient boolean wasCancelled;

    public ConnectionEditDialog(Frame parent) {
        super(parent);
        this.setDefaultValues();
    }

    public void windowClosing(WindowEvent event) {
        this.onCancel();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object eSource = event.getSource();
        if (eSource == this.cancelBtn) {
            this.onCancel();
        } else if (eSource == this.okBtn) {
            this.onOK();
        } else if (eSource == this.saveAsBtn) {
            this.onSaveAs();
        }
    }

    protected void onCancel() {
        this.editPanel.customizerClosing();
        this.setVisible(false);
        this.dispose();
        this.connection = null;
        this.wasCancelled = true;
    }

    protected void onOK() {
        String name = this.connName.getText();
        if (name != null) {
            name = name.trim();
        }
        if (this.isValidConnectionName(name, false)) {
            this.editPanel.customizerClosing();
            if (this.propertyList.containsKey(name)) {
                Properties props = (Properties)this.propertyList.get(name);
                props.clear();
                this.connection.setPersistedName(name);
                this.propertyList.copyProperties(this.connection.getProperties(), props);
            } else {
                Connection defaultConn = new Connection();
                this.propertyList.copyProperties(this.connection.getProperties(), defaultConn.getProperties());
                defaultConn.setPersistedName(name);
                this.propertyList.add(this.propertyList.count(), name, defaultConn.getProperties());
            }
            this.connection = null;
            this.setVisible(false);
            this.dispose();
        } else {
            this.connName.requestFocus();
        }
        this.wasCancelled = false;
    }

    protected void onSaveAs() {
        this.initSaveAsDialog();
        Util.centerOverWindow(this.saveAsDialog, this);
        this.saveAsDialog.setVisible(true);
        String name = this.saveAsDialog.getPersistedName();
        if (name != null) {
            if (this.isValidConnectionName(name = name.trim(), true)) {
                if (this.propertyList.containsKey(name)) {
                    Properties props = (Properties)this.propertyList.get(name);
                    this.connection.setPersistedName(name);
                    this.propertyList.copyProperties(this.connection.getProperties(), props);
                } else {
                    Connection propListConn = new Connection();
                    Connection editConn = new Connection();
                    this.connection.setPersistedName(name);
                    this.propertyList.copyProperties(this.connection.getProperties(), propListConn.getProperties());
                    this.propertyList.copyProperties(this.connection.getProperties(), editConn.getProperties());
                    this.propertyList.add(this.propertyList.count(), name, propListConn.getProperties());
                    this.setObject(editConn);
                }
                this.connName.setText(name);
                this.connName.setEnabled(false);
                this.okBtn.setEnabled(true);
            } else {
                this.connName.requestFocus();
            }
        }
    }

    public boolean isValidConnectionName(String name, boolean newNameNeeded) {
        if (!newNameNeeded && com.sas.util.Util.equal((Object)name, (Object)this.origPersistedName)) {
            return true;
        }
        String errorMessage = null;
        if (name == null) {
            errorMessage = RB.getStringResource(RB_KEY, "nameNotSet.errorMessage.txt");
        } else if (name.trim().length() == 0 || this.propertyList.containsKey(name) || this.reservedNamesList != null && this.reservedNamesList.contains((Object)name)) {
            Message errorMsg = new Message(RB.getResources(), "ConnectionSaveAsDialog.nameErrorDialog.errorMessage.txt", (Object)name);
            errorMessage = errorMsg.toString();
        } else {
            return true;
        }
        JOptionPane.showMessageDialog(null, errorMessage, RB.getStringResource("ConnectionSaveAsDialog.", "nameErrorDialog.title.txt"), 0);
        return false;
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        if (this.connName.getDocument() == event.getDocument()) {
            String connText = this.connName.getText();
            if (connText == null || Strings.trimmedLength((String)connText) == 0) {
                this.okBtn.setEnabled(false);
            } else {
                this.okBtn.setEnabled(true);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    public void setDefaultValues() {
        this.wasCancelled = false;
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        AutoSizingGridLayout asgl = new AutoSizingGridLayout(3, 1, 0, 10, true, true, true);
        asgl.setRemainderRow(2);
        mainPanel.setLayout((LayoutManager)asgl);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(mainPanel);
        JPanel connectionNamePanel = new JPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 2, 5, 0, true, true, true);
        connectionNamePanel.setLayout((LayoutManager)layout);
        mainPanel.add(connectionNamePanel);
        JLabel namedConnLabel = new JLabel();
        namedConnLabel.setText(RB.getStringResource(RB_KEY, "namedConnLabel.txt"));
        connectionNamePanel.add(namedConnLabel);
        this.connName = new JTextField();
        connectionNamePanel.add(this.connName);
        this.editPanel = new ConnectionEditView();
        this.editPanel.initialize();
        mainPanel.add(this.editPanel);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout());
        mainPanel.add(panel1);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new GridLayout(1, 3, 5, 0));
        panel1.add((Component)btnPanel, "East");
        this.saveAsBtn = new JButton();
        this.saveAsBtn.setText(RB.getStringResource(RB_KEY, "saveAsBtn.txt"));
        this.okBtn = new JButton();
        this.okBtn.setText(RB.getStringResource(RB_KEY, "okBtn.txt"));
        this.cancelBtn = new JButton();
        this.cancelBtn.setText(RB.getStringResource(RB_KEY, "cancelBtn.txt"));
        btnPanel.add(this.saveAsBtn);
        btnPanel.add(this.okBtn);
        btnPanel.add(this.cancelBtn);
        this.addListeners();
    }

    protected void addListeners() {
        this.okBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        this.saveAsBtn.addActionListener(this);
        this.connName.getDocument().addDocumentListener(this);
    }

    protected void initSaveAsDialog() {
        if (this.saveAsDialog == null) {
            Frame parentFrame = Util.getParentFrame(this);
            this.saveAsDialog = parentFrame != null ? new ConnectionSaveAsDialog(parentFrame) : new ConnectionSaveAsDialog(new Frame());
            this.saveAsDialog.setModal(true);
            this.saveAsDialog.pack();
        }
        this.saveAsDialog.setReservedNamesList(this.reservedNamesList);
        this.saveAsDialog.setPropertyList(this.propertyList);
        this.saveAsDialog.setPersistedName("");
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public String getPersistedName() {
        return this.connName.getText();
    }

    public void setPersistedName(String name) {
        if (this.connection != null) {
            this.connection.setPersistedName(name);
        }
        this.connName.setText(name);
        if (name == null || name.trim().length() == 0) {
            this.okBtn.setEnabled(false);
        } else {
            this.okBtn.setEnabled(true);
        }
    }

    public void setReservedNamesList(OrderedCollectionInterface reservedNames) {
        this.reservedNamesList = reservedNames;
        if (this.saveAsDialog != null) {
            this.saveAsDialog.setReservedNamesList(reservedNames);
        }
    }

    public void setPropertyList(PersistedConnectionList propList) {
        this.propertyList = propList;
    }

    @Override
    public void setObject(Object bean) {
        if (bean instanceof Connection) {
            this.connection = (Connection)bean;
            this.editPanel.setObject(bean);
            this.origPersistedName = this.connection.getPersistedName();
            this.connName.setText(this.origPersistedName);
            if (this.origPersistedName == null || this.origPersistedName.length() == 0) {
                this.connName.setEnabled(true);
                this.saveAsBtn.setEnabled(false);
                this.okBtn.setEnabled(false);
            } else {
                this.connName.setEnabled(false);
                this.saveAsBtn.setEnabled(true);
                this.okBtn.setEnabled(true);
            }
        }
    }
}

