/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.ComponentException;
import com.sas.GlobalInfoTable;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.measures.Length;
import com.sas.models.SimpleTable;
import com.sas.rmi.Connection;
import com.sas.rmi.RB;
import com.sas.swing.visuals.SwingCustomizerPanel;
import com.sas.swing.visuals.table.CellStyle;
import com.sas.swing.visuals.table.Column;
import com.sas.swing.visuals.table.ColumnStyle;
import com.sas.swing.visuals.table.DataCell;
import com.sas.swing.visuals.table.Row;
import com.sas.swing.visuals.table.TableView;
import com.sas.table.DataCellChangedEvent;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;
import com.sas.text.Message;
import com.sas.util.Util;
import com.sas.util.transforms.EchoCharacterTransform;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBox;
import javax.swing.border.EmptyBorder;

public class ConnectionCustomizerPromptPanel
extends SwingCustomizerPanel
implements ContentsChangedListener,
ItemListener,
FocusListener,
PropertyChangeListener {
    public static String RB_KEY = "ConnectionCustomizerPromptPanel.";
    Connection connection;
    JCheckBox promptUserInfo;
    JCheckBox promptAppUserInfo;
    TableView promptTableView;
    SimpleTable promptTable;
    boolean updatingConnection;
    boolean updatingFields;
    boolean codeEvent;
    String previousUsername;
    String previousPassword;
    static final int PROMPT_COL = 1;
    static final int TIMEOUT_COL = 2;
    static final int RESPONSE_COL = 3;
    static final int USERNAME_ROW = 1;
    static final int PASSWORD_ROW = 2;
    static final int COMMAND_ROW = 3;
    static final int PORT_ROW = 4;

    public ConnectionCustomizerPromptPanel() {
        this("Prompts");
    }

    public ConnectionCustomizerPromptPanel(String tabName) {
        super(tabName);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.createComponents();
        this.layoutComponents();
        this.addListeners();
    }

    protected void createComponents() {
        this.promptUserInfo = new JCheckBox();
        this.promptAppUserInfo = new JCheckBox();
        this.promptTableView = new TableView();
        this.promptTable = new SimpleTable();
        this.promptTable.initialize();
        this.promptTableView.initialize();
        this.promptUserInfo.setText(RB.getStringResource(RB_KEY, "promptUserInfo.txt"));
        this.promptAppUserInfo.setText(RB.getStringResource(RB_KEY, "promptAppUserInfo.txt"));
        CellStyle defaultCellStyle = this.promptTableView.getDefaultCellStyle();
        defaultCellStyle.setActivationLevel(3);
        defaultCellStyle.setActivatedOnCurrent(true);
        this.promptTableView.setModel((StaticTableInterface)this.promptTable);
        this.promptTable.setSize(4, 3);
        this.promptTable.setColumnLabel(1, RB.getStringResource(RB_KEY, "promptColumnLabel.txt"));
        this.promptTable.setColumnLabel(2, RB.getStringResource(RB_KEY, "timeoutColumnLabel.txt"));
        this.promptTable.setColumnLabel(3, RB.getStringResource(RB_KEY, "responseColumnLabel.txt"));
        this.promptTable.setRowLabel(1, RB.getStringResource(RB_KEY, "userNameRowLabel.txt"));
        this.promptTable.setRowLabel(2, RB.getStringResource(RB_KEY, "passwordRowLabel.txt"));
        this.promptTable.setRowLabel(3, RB.getStringResource(RB_KEY, "commandRowLabel.txt"));
        this.promptTable.setRowLabel(4, RB.getStringResource(RB_KEY, "portRowLabel.txt"));
        for (int i = 1; i <= 3; ++i) {
            Column col = this.promptTableView.getColumn(i);
            ColumnStyle style = new ColumnStyle();
            Length s = null;
            switch (i) {
                case 1: {
                    s = new Length(2.0, "px");
                    break;
                }
                case 2: {
                    s = new Length(1.0, "px");
                    break;
                }
                case 3: {
                    s = new Length(4.0, "px");
                }
            }
            style.setSize(s);
            col.setStyle((StaticPropertyBagInterface)style);
        }
        this.promptTableView.setColumnsConformed(true);
        Row passwordRow = this.promptTableView.getRow(2);
        Column passwordCol = this.promptTableView.getColumn(3);
        DataCell passwordCell = this.promptTableView.getCell(passwordRow, passwordCol);
        CellStyle cellProps = new CellStyle();
        cellProps.setViewClass(GlobalInfoTable._loadClass((String)"com.sas.swing.visuals.table.TransformTextCell"));
        cellProps.set("displayTransform", EchoCharacterTransform.defaultInstance);
        passwordCell.setStyle((StaticPropertyBagInterface)cellProps);
        try {
            Row usernameRow = this.promptTableView.getRow(1);
            Column promptCol = this.promptTableView.getColumn(1);
            DataCell firstCell = this.promptTableView.getCell(usernameRow, promptCol);
            this.promptTableView.select(firstCell, firstCell, false);
            this.promptTableView.setCurrentElement(firstCell);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void layoutComponents() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout((LayoutManager)new AutoSizingGridLayout(3, 1, 0, 5, true, true, true));
        this.add(this.promptUserInfo);
        this.add(this.promptAppUserInfo);
        this.add(this.promptTableView);
    }

    protected void addListeners() {
        this.promptUserInfo.addItemListener(this);
        this.promptAppUserInfo.addItemListener(this);
        this.promptTable.addContentsChangedListener(this);
        this.promptTableView.addFocusListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (this.codeEvent) {
            return;
        }
        Object eSource = evt.getSource();
        if (eSource == this.promptUserInfo) {
            String username = this.connection.getUsername();
            String password = this.connection.getPassword();
            this.connection.setDeferUserInfoUntilRuntime(this.promptUserInfo.isSelected());
            if (this.promptUserInfo.isSelected()) {
                this.previousUsername = username;
                this.previousPassword = password;
                this.promptTable.setCell(1, 3, null);
                this.promptTable.setCell(2, 3, null);
            } else if (!(username != null && username.length() != 0 || password != null && password.length() != 0)) {
                this.promptTable.setCell(1, 3, this.previousUsername);
                this.promptTable.setCell(2, 3, this.previousPassword);
            }
        } else if (eSource == this.promptAppUserInfo) {
            this.connection.setDeferApplicationUserInfoUntilRuntime(this.promptAppUserInfo.isSelected());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void contentsChanged(ContentsChangedEvent evt) {
        Object eSource = evt.getSource();
        if (eSource != this.promptTable) return;
        if (!(evt instanceof DataCellChangedEvent)) return;
        if (this.updatingFields) return;
        try {
            this.updatingConnection = true;
            DataCellChangedEvent event = (DataCellChangedEvent)evt;
            Row tableRow = this.promptTableView.getRow(event.rowIndex);
            Column tableCol = this.promptTableView.getColumn(event.colIndex);
            DataCell tableCell = this.promptTableView.getCell(tableRow, tableCol);
            Object cellData = tableCell.getObjectData();
            if (!(cellData instanceof String)) {
                return;
            }
            String stringData = (String)cellData;
            switch (event.colIndex) {
                case 1: {
                    switch (event.rowIndex) {
                        case 1: {
                            this.connection.setUsernamePrompt(stringData);
                            return;
                        }
                        case 2: {
                            this.connection.setPasswordPrompt(stringData);
                            return;
                        }
                        case 3: {
                            this.connection.setCommandPrompt(stringData);
                            return;
                        }
                        case 4: {
                            this.connection.setPortPrompt(stringData);
                            return;
                        }
                    }
                    return;
                }
                case 2: {
                    switch (event.rowIndex) {
                        case 1: {
                            this.connection.setUsernamePromptTimeout(stringData);
                            return;
                        }
                        case 2: {
                            this.connection.setPasswordPromptTimeout(stringData);
                            return;
                        }
                        case 3: {
                            this.connection.setCommandPromptTimeout(stringData);
                            return;
                        }
                        case 4: {
                            this.connection.setPortPromptTimeout(stringData);
                            return;
                        }
                    }
                    return;
                }
                case 3: {
                    switch (event.rowIndex) {
                        case 1: {
                            this.connection.setUsername(stringData);
                            return;
                        }
                        case 2: {
                            this.connection.setPassword(stringData);
                            return;
                        }
                        case 3: {
                            this.connection.setCommand(stringData);
                            return;
                        }
                    }
                    return;
                }
            }
            return;
        }
        catch (TableException tableException) {
            return;
        }
        finally {
            this.updatingConnection = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object eSource = evt.getSource();
        String propName = evt.getPropertyName();
        if (propName != null && eSource == this.connection && !this.updatingConnection) {
            try {
                this.updatingFields = true;
                if (propName.equals("command")) {
                    this.promptTable.setCell(3, 3, this.connection.getCommand());
                } else if (propName.equals("commandPrompt")) {
                    this.promptTable.setCell(3, 1, this.connection.getCommandPrompt());
                } else if (propName.equals("commandPromptTimeout")) {
                    this.promptTable.setCell(3, 2, this.connection.getCommandPromptTimeout());
                } else if (propName.equals("username")) {
                    this.promptTable.setCell(1, 3, this.connection.getUsername());
                } else if (propName.equals("usernamePrompt")) {
                    this.promptTable.setCell(1, 1, this.connection.getUsernamePrompt());
                } else if (propName.equals("usernamePromptTimeout")) {
                    this.promptTable.setCell(1, 2, this.connection.getUsernamePromptTimeout());
                } else if (propName.equals("password")) {
                    this.promptTable.setCell(2, 3, this.connection.getPassword());
                } else if (propName.equals("passwordPrompt")) {
                    this.promptTable.setCell(2, 1, this.connection.getPasswordPrompt());
                } else if (propName.equals("passwordPromptTimeout")) {
                    this.promptTable.setCell(2, 2, this.connection.getPasswordPromptTimeout());
                } else if (propName.equals("passwordPrompt")) {
                    this.promptTable.setCell(4, 1, this.connection.getPortPrompt());
                } else if (propName.equals("passwordPromptTimeout")) {
                    this.promptTable.setCell(4, 2, this.connection.getPortPromptTimeout());
                }
            }
            finally {
                this.updatingFields = false;
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.promptTableView.commitModifiedCells();
    }

    @Override
    public void setObject(Object bean) {
        super.setObject(bean);
        if (bean instanceof Connection) {
            this.connection = (Connection)bean;
            try {
                this.updatingFields = true;
                this.codeEvent = true;
                this.promptTable.setCell(1, 1, this.connection.getUsernamePrompt());
                this.promptTable.setCell(1, 2, this.connection.getUsernamePromptTimeout());
                this.promptTable.setCell(1, 3, this.connection.getUsername());
                this.promptTable.setCell(2, 1, this.connection.getPasswordPrompt());
                this.promptTable.setCell(2, 2, this.connection.getPasswordPromptTimeout());
                this.promptTable.setCell(2, 3, this.connection.getPassword());
                this.promptTable.setCell(3, 1, this.connection.getCommandPrompt());
                this.promptTable.setCell(3, 2, this.connection.getCommandPromptTimeout());
                this.promptTable.setCell(3, 3, this.connection.getCommand());
                this.promptTable.setCell(4, 1, this.connection.getPortPrompt());
                this.promptTable.setCell(4, 2, this.connection.getPortPromptTimeout());
                this.promptTable.setCell(4, 3, RB.getStringResource(RB_KEY, "connectedResponse.txt"));
                this.promptUserInfo.setSelected(this.connection.isDeferUserInfoUntilRuntime());
                this.promptAppUserInfo.setSelected(this.connection.isDeferApplicationUserInfoUntilRuntime());
            }
            finally {
                this.updatingFields = false;
                this.codeEvent = false;
            }
        } else {
            Message exceptionMessage = new Message(Util.getCommonResources(), "Customizer.setObject.ex.txt", (Object)"ConnectionCustomizerPromptPanel", (Object)"com.sas.rmi.Connection");
            throw new ComponentException(exceptionMessage.toString());
        }
        this.connection.addPropertyChangeListener(this);
    }

    @Override
    public void customizerClosing() {
        this.promptTableView.commitModifiedCells();
        this.connection.removePropertyChangeListener(this);
        this.updatingFields = true;
    }
}

