/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.ComponentException;
import com.sas.rmi.Connection;
import com.sas.rmi.RB;
import com.sas.swing.visuals.SwingCustomizerPanel;
import com.sas.text.Message;
import com.sas.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ConnectionCustomizerMiddlewarePanel
extends SwingCustomizerPanel
implements ItemListener,
DocumentListener {
    public static String RB_KEY = "ConnectionCustomizerMiddlewarePanel.";
    Connection connection;
    JCheckBox useMiddleware;
    JPanel hostContainer;
    JLabel hostNameLabel;
    JTextField hostNameField;
    JCheckBox useProfile;
    JPanel profileContainer;
    JLabel profileNameLabel;
    JTextField profileNameField;
    boolean codeEvent;

    public ConnectionCustomizerMiddlewarePanel() {
        this("Middleware");
    }

    public ConnectionCustomizerMiddlewarePanel(String tabName) {
        super(tabName);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.createComponents();
        this.layoutComponents();
        this.addListeners();
    }

    protected void createComponents() {
        this.useMiddleware = new JCheckBox();
        this.hostContainer = new JPanel();
        this.hostNameLabel = new JLabel();
        this.hostNameField = new JTextField();
        this.useProfile = new JCheckBox();
        this.profileContainer = new JPanel();
        this.profileNameLabel = new JLabel();
        this.profileNameField = new JTextField();
        this.useMiddleware.setText(RB.getStringResource(RB_KEY, "useMiddleware.txt"));
        this.hostNameLabel.setText(RB.getStringResource(RB_KEY, "hostNameLabel.txt"));
        this.hostNameLabel.setBorder(new EmptyBorder(0, 15, 0, 0));
        this.useProfile.setText(RB.getStringResource(RB_KEY, "useProfile.txt"));
        this.profileNameLabel.setText(RB.getStringResource(RB_KEY, "profileNameLabel.txt"));
        this.profileNameLabel.setBorder(new EmptyBorder(0, 15, 0, 0));
    }

    protected void layoutComponents() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout((LayoutManager)new AutoSizingGridLayout(0, 1, 0, 5, true, false, true));
        AutoSizingGridLayout hostLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, true, true);
        AutoSizingGridLayout profileLayout = new AutoSizingGridLayout(1, 2, 5, 0, true, true, true);
        hostLayout.setInterlockedColumnContainers(new Container[]{this.hostContainer, this.profileContainer});
        profileLayout.setInterlockedColumnContainers(new Container[]{this.hostContainer, this.profileContainer});
        this.hostContainer.setLayout((LayoutManager)hostLayout);
        this.hostContainer.add(this.hostNameLabel);
        this.hostContainer.add(this.hostNameField);
        this.profileContainer.setLayout((LayoutManager)profileLayout);
        this.profileContainer.add(this.profileNameLabel);
        this.profileContainer.add(this.profileNameField);
        this.add(this.useMiddleware);
        this.add(this.hostContainer);
        this.add(this.useProfile);
        this.add(this.profileContainer);
    }

    public void addListeners() {
        this.useMiddleware.addItemListener(this);
        this.useProfile.addItemListener(this);
        this.hostNameField.getDocument().addDocumentListener(this);
        this.profileNameField.getDocument().addDocumentListener(this);
    }

    protected void enableMiddlewareFields(boolean enabled) {
        this.hostNameField.setEnabled(enabled);
        this.hostNameLabel.setEnabled(enabled);
        this.useProfile.setEnabled(enabled);
        if (this.useProfile.isSelected() || !this.useProfile.isEnabled()) {
            this.profileNameLabel.setEnabled(enabled);
            this.profileNameField.setEnabled(enabled);
        } else {
            this.profileNameLabel.setEnabled(false);
            this.profileNameField.setEnabled(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (this.codeEvent) {
            return;
        }
        Object eSource = evt.getSource();
        if (eSource == this.useMiddleware) {
            boolean selected = this.useMiddleware.isSelected();
            this.enableMiddlewareFields(selected);
            this.connection.setFunnel(selected);
        } else if (eSource == this.useProfile) {
            boolean selected = this.useProfile.isSelected();
            com.sas.awt.util.Util.setEnabledOnContainer(this.profileContainer, selected);
            this.connection.setUseProfile(selected);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        if (this.codeEvent) {
            return;
        }
        Document eSource = event.getDocument();
        if (eSource == this.hostNameField.getDocument()) {
            String hostName = this.hostNameField.getText();
            this.connection.setFunnelHost(hostName);
        } else if (eSource == this.profileNameField.getDocument()) {
            String profileName = this.profileNameField.getText();
            this.connection.setProfileName(profileName);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    @Override
    public void setObject(Object bean) {
        super.setObject(bean);
        if (bean instanceof Connection) {
            try {
                this.codeEvent = true;
                this.connection = (Connection)bean;
                this.useMiddleware.setSelected(this.connection.isFunnel());
                this.hostNameField.setText(this.connection.getFunnelHost());
                this.useProfile.setSelected(this.connection.getUseProfile());
                this.profileNameField.setText(this.connection.getProfileName());
                this.enableMiddlewareFields(this.useMiddleware.isSelected());
            }
            finally {
                this.codeEvent = false;
            }
        } else {
            Message exceptionMessage = new Message(Util.getCommonResources(), "Customizer.setObject.ex.txt", (Object)"ConnectionCustomizerMiddlewarePanel", (Object)"com.sas.rmi.Connection");
            throw new ComponentException(exceptionMessage.toString());
        }
    }
}

