/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.ComponentException;
import com.sas.awt.util.Util;
import com.sas.collection.AssociationList;
import com.sas.rmi.Connection;
import com.sas.rmi.RB;
import com.sas.swing.visuals.DualSelector;
import com.sas.swing.visuals.SpinButton;
import com.sas.swing.visuals.SwingCustomizerPanel;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConnectionCustomizerEncryptionPanel
extends SwingCustomizerPanel
implements ItemListener,
AdjustmentListener,
ListSelectionListener,
ListDataListener {
    public static String RB_KEY = "ConnectionCustomizerEncryptionPanel.";
    Connection connection;
    JCheckBox useEncryption;
    JPanel settingsContainer;
    JPanel spinBtnContainer;
    JPanel selectorContainer;
    JLabel algorithmLabel;
    ConnectionDS algorithmSelector;
    JLabel policyLabel;
    JComboBox policyChoice;
    JLabel targetLabel;
    JComboBox targetChoice;
    JLabel contentLabel;
    JComboBox contentChoice;
    SpinButton reorderListSpinBtn;
    JList algorithmsListBox;
    DefaultListModel encryptionAlgorithms;
    DefaultListModel selectedAlgorithms;
    AssociationList algorithmList;
    AssociationList policyList;
    AssociationList targetList;
    AssociationList contentList;
    boolean codeEvent;
    protected static String ALGORITHM_SAS = "sasproprietary";
    protected static String ALGORITHM_RC2 = "rc2";
    protected static String ALGORITHM_RC4 = "rc4";
    protected static String ALGORITHM_DES = "des";
    protected static String ALGORITHM_TRIPLEDES = "tripledes";
    protected static String POLICY_NONE = "none";
    protected static String POLICY_OPTIONAL = "optional";
    protected static String POLICY_REQUIRED = "required";
    protected static String TARGET_TELNET = "telnet";
    protected static String TARGET_SAS = "sas";
    protected static String TARGET_ALL = "both";
    protected static String CONTENT_ALL = "all";
    protected static String CONTENT_AUTHENTICATED = "authenticated";

    public ConnectionCustomizerEncryptionPanel() {
        this("Encryption");
    }

    public ConnectionCustomizerEncryptionPanel(String tabName) {
        super(tabName);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.createComponents();
        this.layoutComponents();
        this.addListeners();
    }

    protected void createComponents() {
        this.useEncryption = new JCheckBox();
        this.settingsContainer = new JPanel();
        this.selectorContainer = new JPanel();
        this.spinBtnContainer = new JPanel();
        this.policyLabel = new JLabel();
        this.policyChoice = new JComboBox();
        this.targetLabel = new JLabel();
        this.targetChoice = new JComboBox();
        this.contentLabel = new JLabel();
        this.contentChoice = new JComboBox();
        this.algorithmLabel = new JLabel();
        this.algorithmSelector = new ConnectionDS();
        this.reorderListSpinBtn = new SpinButton();
        this.policyList = new AssociationList();
        this.policyList.add(0, (Object)POLICY_OPTIONAL, (Object)RB.getStringResource(RB_KEY, "policyList.optional.txt"));
        this.policyList.add(1, (Object)POLICY_REQUIRED, (Object)RB.getStringResource(RB_KEY, "policyList.required.txt"));
        DefaultComboBoxModel policyModel = new DefaultComboBoxModel();
        Enumeration policyEnum = this.policyList.getItems();
        while (policyEnum != null && policyEnum.hasMoreElements()) {
            policyModel.addElement(policyEnum.nextElement());
        }
        this.policyChoice.setModel(policyModel);
        this.targetList = new AssociationList();
        this.targetList.add(0, (Object)TARGET_TELNET, (Object)RB.getStringResource(RB_KEY, "targetList.telnet.txt"));
        this.targetList.add(1, (Object)TARGET_SAS, (Object)RB.getStringResource(RB_KEY, "targetList.sas.txt"));
        this.targetList.add(2, (Object)TARGET_ALL, (Object)RB.getStringResource(RB_KEY, "targetList.all.txt"));
        DefaultComboBoxModel targetModel = new DefaultComboBoxModel();
        Enumeration targetEnum = this.targetList.getItems();
        while (targetEnum != null && targetEnum.hasMoreElements()) {
            targetModel.addElement(targetEnum.nextElement());
        }
        this.targetChoice.setModel(targetModel);
        this.contentList = new AssociationList();
        this.contentList.add(0, (Object)CONTENT_ALL, (Object)RB.getStringResource(RB_KEY, "contentList.all.txt"));
        this.contentList.add(1, (Object)CONTENT_AUTHENTICATED, (Object)RB.getStringResource(RB_KEY, "contentList.authenticated.txt"));
        DefaultComboBoxModel contentModel = new DefaultComboBoxModel();
        Enumeration contentEnum = this.contentList.getItems();
        while (contentEnum != null && contentEnum.hasMoreElements()) {
            contentModel.addElement(contentEnum.nextElement());
        }
        this.contentChoice.setModel(contentModel);
        this.reorderListSpinBtn.setMaximum(0);
        this.reorderListSpinBtn.setMinimum(0);
        this.reorderListSpinBtn.setValue(0);
        this.useEncryption.setText(RB.getStringResource(RB_KEY, "useEncryption.txt"));
        this.policyLabel.setText(RB.getStringResource(RB_KEY, "policyLabel.txt"));
        this.targetLabel.setText(RB.getStringResource(RB_KEY, "targetLabel.txt"));
        this.contentLabel.setText(RB.getStringResource(RB_KEY, "contentLabel.txt"));
        this.algorithmLabel.setText(RB.getStringResource(RB_KEY, "algorithmLabel.txt"));
        this.algorithmLabel.setVerticalAlignment(1);
        this.settingsContainer.setBorder(com.sas.swing.visuals.util.Util.getGroupBoxBorder((String)RB.getStringResource(RB_KEY, "settingsBorder.txt"), (int)15, (int)10, (int)10, (int)10));
        this.selectedAlgorithms = new DefaultListModel();
        this.algorithmList = new AssociationList();
        this.algorithmList.add(0, (Object)ALGORITHM_SAS, (Object)RB.getStringResource(RB_KEY, "algorithmList.sasproprietary.txt"));
        this.algorithmList.add(1, (Object)ALGORITHM_RC2, (Object)RB.getStringResource(RB_KEY, "algorithmList.rc2.txt"));
        this.algorithmList.add(2, (Object)ALGORITHM_RC4, (Object)RB.getStringResource(RB_KEY, "algorithmList.rc4.txt"));
        this.algorithmList.add(3, (Object)ALGORITHM_DES, (Object)RB.getStringResource(RB_KEY, "algorithmList.des.txt"));
        this.algorithmList.add(4, (Object)ALGORITHM_TRIPLEDES, (Object)RB.getStringResource(RB_KEY, "algorithmList.tripledes.txt"));
        this.encryptionAlgorithms = new DefaultListModel();
        this.encryptionAlgorithms.addElement(this.algorithmList.get((Object)ALGORITHM_SAS));
        this.encryptionAlgorithms.addElement(this.algorithmList.get((Object)ALGORITHM_RC2));
        this.encryptionAlgorithms.addElement(this.algorithmList.get((Object)ALGORITHM_RC4));
        this.encryptionAlgorithms.addElement(this.algorithmList.get((Object)ALGORITHM_DES));
        this.encryptionAlgorithms.addElement(this.algorithmList.get((Object)ALGORITHM_TRIPLEDES));
        this.algorithmSelector.setDynamic(true);
        this.algorithmSelector.setModel(this.encryptionAlgorithms);
        this.algorithmSelector.setList2Model(this.selectedAlgorithms);
        this.algorithmsListBox = this.algorithmSelector.getList2();
        if (this.algorithmsListBox != null) {
            this.algorithmsListBox.addListSelectionListener(this);
        }
    }

    protected void layoutComponents() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout((LayoutManager)new AutoSizingGridLayout(0, 1, 0, 5, true, false, true));
        AutoSizingGridLayout selectorLayout = new AutoSizingGridLayout(1, 2, 0, 0, true, true, true);
        selectorLayout.setRemainderColumn(1);
        this.selectorContainer.setLayout((LayoutManager)selectorLayout);
        this.spinBtnContainer.setLayout(new BorderLayout());
        this.spinBtnContainer.add((Component)this.reorderListSpinBtn, "South");
        this.selectorContainer.add(this.algorithmSelector);
        this.selectorContainer.add(this.spinBtnContainer);
        this.settingsContainer.setLayout((LayoutManager)new AutoSizingGridLayout(0, 2, 5, 10, true, true, true));
        this.settingsContainer.add(this.policyLabel);
        JPanel policyContainer = new JPanel();
        policyContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 0, 0, true, false, false));
        policyContainer.add(this.policyChoice);
        this.settingsContainer.add(policyContainer);
        this.settingsContainer.add(this.algorithmLabel);
        this.settingsContainer.add(this.selectorContainer);
        this.settingsContainer.add(this.targetLabel);
        JPanel targetContainer = new JPanel();
        targetContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 0, 0, true, false, false));
        targetContainer.add(this.targetChoice);
        this.settingsContainer.add(targetContainer);
        this.settingsContainer.add(this.contentLabel);
        JPanel contentContainer = new JPanel();
        contentContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 0, 0, true, false, false));
        contentContainer.add(this.contentChoice);
        this.settingsContainer.add(contentContainer);
        this.add(this.useEncryption);
        this.add(this.settingsContainer);
    }

    public void addListeners() {
        this.useEncryption.addItemListener(this);
        this.policyChoice.addItemListener(this);
        this.targetChoice.addItemListener(this);
        this.contentChoice.addItemListener(this);
        this.reorderListSpinBtn.addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        Object eSource = evt.getSource();
        if (eSource == this.reorderListSpinBtn) {
            if (evt.getAdjustmentType() == 1) {
                this.algorithmSelector.moveList2ItemUp();
            } else if (evt.getAdjustmentType() == 2) {
                this.algorithmSelector.moveList2ItemDown();
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent event) {
        this.contentsChanged(event);
    }

    @Override
    public void intervalRemoved(ListDataEvent event) {
        this.contentsChanged(event);
    }

    @Override
    public void contentsChanged(ListDataEvent event) {
        Object eSource = event.getSource();
        if (eSource == this.selectedAlgorithms) {
            this.updateAlgorithms();
            this.updateReorderEnabled();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        this.updateReorderEnabled();
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (this.codeEvent) {
            return;
        }
        Object eSource = evt.getSource();
        if (eSource == this.useEncryption) {
            boolean selected = this.useEncryption.isSelected();
            Util.setEnabledOnContainer(this.settingsContainer, selected);
            if (selected) {
                String selectedItem = this.policyChoice.getSelectedItem().toString();
                String policy = (String)this.policyList.getKey((Object)selectedItem);
                this.connection.setEncryptionPolicy(policy);
                selectedItem = this.targetChoice.getSelectedItem().toString();
                String target = (String)this.targetList.getKey((Object)selectedItem);
                this.connection.setEncryptionTarget(target);
                selectedItem = this.contentChoice.getSelectedItem().toString();
                String content = (String)this.contentList.getKey((Object)selectedItem);
                this.connection.setEncryptionContent(content);
                this.updateAlgorithms();
                this.updateReorderEnabled();
            } else {
                this.connection.setEncryptionAlgorithms(null);
                this.connection.setEncryptionPolicy(null);
                this.connection.setEncryptionTarget(null);
                this.connection.setEncryptionContent(null);
            }
        } else if (eSource == this.policyChoice) {
            String selectedItem = this.policyChoice.getSelectedItem().toString();
            String policy = (String)this.policyList.getKey((Object)selectedItem);
            if (policy != null) {
                this.connection.setEncryptionPolicy(policy);
            }
        } else if (eSource == this.targetChoice) {
            String selectedItem = this.targetChoice.getSelectedItem().toString();
            String target = (String)this.targetList.getKey((Object)selectedItem);
            this.connection.setEncryptionTarget(target);
        } else if (eSource == this.contentChoice) {
            String selectedItem = this.contentChoice.getSelectedItem().toString();
            String content = (String)this.contentList.getKey((Object)selectedItem);
            this.connection.setEncryptionContent(content);
        }
    }

    protected void updateAlgorithms() {
        String algorithms = null;
        int count = this.selectedAlgorithms.getSize();
        for (int i = 0; i < count; ++i) {
            String algorithm = (String)this.selectedAlgorithms.getElementAt(i);
            String algorithmKey = (String)this.algorithmList.getKey((Object)algorithm);
            if (algorithmKey == null) continue;
            algorithms = i == 0 ? algorithmKey : algorithms + ", " + algorithmKey;
        }
        this.connection.setEncryptionAlgorithms(algorithms);
    }

    protected void updateReorderEnabled() {
        if (this.algorithmsListBox == null) {
            return;
        }
        int count = this.selectedAlgorithms.getSize() - 1;
        if (count < 0) {
            count = 0;
        }
        this.reorderListSpinBtn.setMaximum(count);
        int selectedIndex = this.algorithmsListBox.getSelectedIndex();
        if (selectedIndex >= 0) {
            selectedIndex = count - selectedIndex;
            this.reorderListSpinBtn.setValue(selectedIndex);
        }
        this.reorderListSpinBtn.setEnabled(count > 0 && selectedIndex >= 0 && this.useEncryption.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(Object bean) {
        super.setObject(bean);
        if (bean instanceof Connection) {
            this.connection = (Connection)bean;
            boolean enableEncryption = false;
            String encryptionPolicy = this.connection.getEncryptionPolicy();
            if (encryptionPolicy != null) {
                if (encryptionPolicy.equalsIgnoreCase(POLICY_NONE)) {
                    encryptionPolicy = null;
                } else {
                    enableEncryption = true;
                }
            }
            try {
                this.codeEvent = true;
                if (enableEncryption) {
                    String encryptionTarget;
                    String s = (String)this.policyList.get((Object)encryptionPolicy);
                    if (s != null) {
                        this.policyChoice.setSelectedItem(s);
                    }
                    if ((encryptionTarget = this.connection.getEncryptionTarget()) == null) {
                        encryptionTarget = TARGET_SAS;
                    } else {
                        enableEncryption = true;
                    }
                    this.targetChoice.setSelectedItem((String)this.targetList.get((Object)encryptionTarget));
                    String encryptionContent = this.connection.getEncryptionContent();
                    if (encryptionContent == null) {
                        encryptionContent = CONTENT_ALL;
                    } else {
                        enableEncryption = true;
                    }
                    this.contentChoice.setSelectedItem((String)this.contentList.get((Object)encryptionContent));
                    String algorithms = this.connection.getEncryptionAlgorithms();
                    if (algorithms != null) {
                        enableEncryption = true;
                        this.selectedAlgorithms.removeAllElements();
                        this.encryptionAlgorithms.removeAllElements();
                        this.encryptionAlgorithms.addElement(this.algorithmList.get((Object)ALGORITHM_SAS));
                        this.encryptionAlgorithms.addElement(this.algorithmList.get((Object)ALGORITHM_RC2));
                        this.encryptionAlgorithms.addElement(this.algorithmList.get((Object)ALGORITHM_RC4));
                        this.encryptionAlgorithms.addElement(this.algorithmList.get((Object)ALGORITHM_DES));
                        this.encryptionAlgorithms.addElement(this.algorithmList.get((Object)ALGORITHM_TRIPLEDES));
                        StringTokenizer algorithmTokens = new StringTokenizer(algorithms, ",");
                        while (algorithmTokens.hasMoreElements()) {
                            String token = algorithmTokens.nextToken();
                            String algorithm = (String)this.algorithmList.get((Object)(token = token.trim()));
                            if (algorithm == null) continue;
                            this.encryptionAlgorithms.removeElement(algorithm);
                            this.selectedAlgorithms.addElement(algorithm);
                        }
                    } else {
                        this.selectedAlgorithms.removeAllElements();
                        this.encryptionAlgorithms.removeAllElements();
                        Enumeration enumer = this.algorithmList.getItems();
                        while (enumer != null && enumer.hasMoreElements()) {
                            this.encryptionAlgorithms.addElement(enumer.nextElement());
                        }
                    }
                    this.reorderListSpinBtn.setEnabled(false);
                }
                this.selectedAlgorithms.addListDataListener(this);
                this.useEncryption.setSelected(enableEncryption);
                Util.setEnabledOnContainer(this.settingsContainer, enableEncryption);
            }
            finally {
                this.codeEvent = false;
            }
        }
        Message exceptionMessage = new Message(com.sas.util.Util.getCommonResources(), "Customizer.setObject.ex.txt", (Object)"ConnectionCustomizerEncryptionPanel", (Object)"com.sas.rmi.Connection");
        throw new ComponentException(exceptionMessage.toString());
    }

    @Override
    public void customizerClosing() {
        this.selectedAlgorithms.removeListDataListener(this);
    }

    private class ConnectionDS
    extends DualSelector {
        private ConnectionDS() {
        }

        public JList getList2() {
            return this.jList2;
        }
    }
}

