/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.net.server.AfAccessInterface;
import com.sas.net.server.AfRequestInterface;
import com.sas.net.server.RemoteSasException;
import com.sas.rmi.Connection;
import com.sas.rmi.J2Factory;
import com.sas.rmi.RemoteClientPerformanceSample;
import com.sas.rmi.Rocf;
import com.sas.rmi.RocfORB;
import com.sas.sasserver.factory.FactoryInterface;
import com.sas.sasserver.prodauth.ProdauthInterface;

public class ClientTaskManager {
    private Connection m_ctxt;
    private RocfORB m_rocforb;
    private AfAccessInterface m_client;
    private ProdauthInterface m_prodauth;
    private FactoryInterface m_factory;
    private int phase = 0;
    boolean verbose = false;
    J2Factory m_j2f;
    long m_lastUsed;
    long m_lastSample;
    long m_creationTime;
    long m_pingTime;
    long m_methodCount;
    String clientHost;
    Object guid;

    public ClientTaskManager() {
        this.touch(false);
        this.m_creationTime = this.m_lastSample = System.currentTimeMillis();
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public void startClient(Rocf rocf, Connection c, RocfORB orb) throws RemoteSasException {
        this.m_ctxt = c;
        this.m_rocforb = orb;
        if (!c.isInChain()) {
            this.m_j2f = new J2Factory(rocf, this.m_ctxt, true);
            this.m_ctxt.setJ2Factory(this.m_j2f);
            try {
                if (this.m_ctxt.isJ2()) {
                    this.m_j2f.logon();
                }
            }
            catch (Exception e) {
                throw new RemoteSasException(e.toString());
            }
        }
        this.touch(false);
    }

    public void touch() {
        this.touch(true);
    }

    protected void touch(boolean updateCount) {
        this.m_lastUsed = System.currentTimeMillis();
        if (updateCount) {
            ++this.m_methodCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteClientPerformanceSample getSample() {
        RemoteClientPerformanceSample sample = new RemoteClientPerformanceSample();
        ClientTaskManager clientTaskManager = this;
        synchronized (clientTaskManager) {
            long current = System.currentTimeMillis();
            sample.setDuration(current - this.m_lastSample);
            sample.setMethodCount(this.m_methodCount);
            this.m_lastSample = current;
            this.m_methodCount = 0L;
        }
        return sample;
    }

    public long getPingTime() {
        return this.m_pingTime;
    }

    public void setPingTime(long pt) {
        this.m_pingTime = pt;
    }

    public long getLastUsed() {
        return this.m_lastUsed;
    }

    public long getCreationTime() {
        return this.m_creationTime;
    }

    public Object getGUID() {
        return this.guid;
    }

    public J2Factory getJ2Factory() {
        return this.m_j2f;
    }

    public Connection getConnection() {
        return this.m_ctxt;
    }

    public void stopClient() throws RemoteSasException {
        if (this.m_ctxt != null && this.m_j2f != null) {
            try {
                this.m_j2f.logoff();
            }
            catch (Exception e) {
                throw new RemoteSasException(e.toString());
            }
        }
        this.m_rocforb = null;
    }

    public void setClientHost(String h) {
        this.clientHost = h;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    private AfAccessInterface afaccess() {
        Connection c = this.m_ctxt;
        AfAccessInterface a = (AfAccessInterface)c._getAfAccess();
        return a;
    }

    private void _p(String s) {
        if (this.verbose) {
            System.out.println(this.getClass().getName() + "::" + s);
        }
    }

    public AfRequestInterface createRemoteInstance(String remoteObjName) throws RemoteSasException {
        AfRequestInterface ret = null;
        this.setup();
        if (this.phase < 3) {
            this._p("createRemoteInstance:" + remoteObjName);
            ret = this.afaccess().createRemoteInstance(remoteObjName);
        } else {
            int sclhandle = this.m_factory.createObject(remoteObjName);
            this._p("bindRemoteInstance:name=" + remoteObjName + " handle=" + sclhandle);
            ret = this.bindRemoteInstance(sclhandle);
        }
        this._p("ret=" + ret);
        return ret;
    }

    public AfRequestInterface bindRemoteInstance(double sclhandle) throws RemoteSasException {
        AfRequestInterface ret = null;
        this.setup();
        ret = this.afaccess().bindRemoteInstance(sclhandle);
        return ret;
    }

    void setup() throws RemoteSasException {
    }

    public String toString() {
        J2Factory j2f = this.getJ2Factory();
        int factory = j2f == null ? -1 : j2f.factoryId();
        return "{factory=" + factory + "," + super.toString() + "}";
    }
}

