/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.BrokerEvent;
import com.sas.rmi.BrokerEventListener;
import com.sas.security.BaseSecuritySupport;
import java.io.DataOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class BrokerEventServer
implements Runnable,
BrokerEventListener {
    private Thread m_thread = null;
    private ServerSocket m_server;
    private Vector m_clients;
    private int m_queueSize = 50;
    private BrokerEvent[] m_eventQueue;
    private int m_head;
    private int m_tail;
    private Vector m_poolInfo;

    public BrokerEventServer() {
        try {
            this.m_server = new ServerSocket(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = BaseSecuritySupport.securitySupport.createThread((Runnable)this);
            this.m_thread.start();
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
        }
        if (this.m_server != null) {
            try {
                this.m_server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_clients != null) {
            for (int i = 0; i < this.m_clients.size(); ++i) {
                Socket socket = (Socket)this.m_clients.elementAt(i);
                try {
                    socket.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_clients = null;
        }
    }

    @Override
    public void run() {
        if (this.m_server == null) {
            return;
        }
        this.m_clients = new Vector();
        this.m_poolInfo = new Vector();
        this.m_eventQueue = new BrokerEvent[this.getQueueSize()];
        this.m_head = 0;
        this.m_tail = 0;
        while (true) {
            try {
                while (true) {
                    Socket client = this.m_server.accept();
                    this.sendPools(client);
                    this.sendQueue(client);
                    this.m_clients.addElement(client);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void brokerEvent(BrokerEvent event) {
        int type = event.getType();
        if (type == 0 || type == 1) {
            BrokerEventServer brokerEventServer = this;
            synchronized (brokerEventServer) {
                this.m_eventQueue[this.m_tail++] = event;
                if (this.m_tail >= this.getQueueSize()) {
                    this.m_tail = 0;
                }
                if (this.m_tail <= this.m_head) {
                    this.m_head = this.m_tail + 1;
                    if (this.m_head >= this.getQueueSize()) {
                        this.m_head = 0;
                    }
                }
            }
        } else if (type == 2) {
            String m = event.getMessage().trim();
            if (m.length() == 0) {
                this.m_poolInfo.removeAllElements();
            } else {
                this.m_poolInfo.addElement(event);
            }
        }
        if (this.m_clients != null) {
            int i;
            for (i = 0; i < this.m_clients.size(); ++i) {
                Socket socket = (Socket)this.m_clients.elementAt(i);
                try {
                    this.sendEvent(socket, event);
                    continue;
                }
                catch (Exception ex) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_clients.setElementAt(null, i);
                }
            }
            for (i = 0; i < this.m_clients.size(); ++i) {
                if (this.m_clients.elementAt(i) != null) continue;
                this.m_clients.removeElementAt(i);
                --i;
            }
        }
    }

    public void sendEvent(Socket socket, BrokerEvent event) throws Exception {
        if (socket != null) {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.writeInt(event.getType());
            out.writeUTF(event.getMessage());
            out.flush();
        }
    }

    public void sendQueue(Socket socket) {
        try {
            int i = this.m_head;
            while (i != this.m_tail) {
                this.sendEvent(socket, this.m_eventQueue[i]);
                if (++i < this.getQueueSize()) continue;
                i = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendPools(Socket socket) {
        try {
            for (int i = 0; i < this.m_poolInfo.size(); ++i) {
                this.sendEvent(socket, (BrokerEvent)this.m_poolInfo.elementAt(i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPort() {
        int port = 0;
        if (this.m_server != null) {
            port = this.m_server.getLocalPort();
        }
        return port;
    }

    public void setQueueSize(int value) {
        if (this.m_eventQueue != null) {
            this.m_queueSize = value;
        }
    }

    public int getQueueSize() {
        return this.m_queueSize;
    }
}

