/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rmi;

import com.sas.rmi.BrokerConfiguration;
import com.sas.rmi.BrokerInterface;
import com.sas.rmi.Connection;
import com.sas.rmi.Rocf;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class BrokerAdmin {
    public static void main(String[] args) {
        BrokerAdmin admin = new BrokerAdmin();
        admin.config(args);
    }

    public void config(String[] args) {
        if (this.argExists(args, "-?")) {
            this.displayHelp();
            return;
        }
        BrokerConfiguration bc = new BrokerConfiguration();
        Connection con = bc.getConnection();
        boolean quietMode = this.argExists(args, "-q");
        String s = this.getArg(args, "-r");
        if (s != null) {
            this.processResource(s);
        } else {
            boolean valid;
            s = this.getArg(args, "-a");
            if (s != null) {
                valid = Connection.setServerArchitecture(con, s);
                if (!valid) {
                    System.out.println("Invalid architecture: " + s);
                    return;
                }
            }
            bc.setBrokerHost(this.getArg(args, "-b"));
            con.setHost(this.getArg(args, "-h"));
            con.setUsername(this.getArg(args, "-u"));
            con.setPassword(this.getArg(args, "-p"));
            s = this.getArg(args, "-c");
            if (s != null) {
                con.setCommand(s);
            }
            bc.setSessions(this.getIntArg(args, "-s"));
            bc.setSessionTimeout(this.getIntArg(args, "-t"));
            bc.setKillAll(this.argExists(args, "-k"));
            valid = this.validate(bc);
            if (valid) {
                boolean failed;
                if (!quietMode) {
                    this.displayStats(bc);
                }
                if (!(failed = this.update(bc)) && !quietMode) {
                    System.out.println("\nSuccess!");
                }
            }
        }
    }

    private boolean validate(BrokerConfiguration bc) {
        if (bc.getKillAll()) {
            return true;
        }
        if (bc.getConnection().getHost() == null) {
            System.out.println("ServerHost must be set (-h switch)");
            return false;
        }
        return true;
    }

    private void displayStats(BrokerConfiguration bc) {
        int n;
        System.out.println("\nBrokerAdmin - Updating ROCF Broker settings with:\n");
        if (bc.getKillAll()) {
            System.out.println("** TERMINATING ALL SESSIONS **");
            return;
        }
        String s = bc.getBrokerHost();
        if (s == null) {
            s = "null (localhost assumed)";
        }
        System.out.println("Broker Host: " + s);
        s = bc.getConnection().getHost();
        if (s != null) {
            System.out.println("Server Host: " + s);
        }
        if ((s = bc.getConnection().getUsername()) != null) {
            System.out.println("User       : " + s);
        }
        if ((s = bc.getConnection().getPassword()) != null) {
            System.out.println("Password   : " + s);
        }
        s = (n = bc.getSessions()) == 0 ? "0 (all sessions will be purged)" : "" + n;
        System.out.println("Sessions   : " + s);
    }

    private void displayHelp() {
        System.out.println("\nBrokerAdmin - ROCF Broker Administration tool\n");
        System.out.println("Usage: BrokerAdmin [args]\n");
        System.out.println("Args:  -b<broker host>");
        System.out.println("       -a<server architecture {PC,UNIX,MVS}>");
        System.out.println("       -h<server host>");
        System.out.println("       -u<user name>");
        System.out.println("       -p<password>");
        System.out.println("       -c<command>");
        System.out.println("       -s<sessions to create>");
        System.out.println("       -t<session timeout in seconds>");
        System.out.println("       -k   (kill all)");
        System.out.println("       -q   (quiet mode)");
        System.out.println("       -r<resource file>");
    }

    private String getArg(String[] args, String s) {
        String arg = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith(s)) continue;
            arg = args[i].substring(s.length());
            if (arg.length() != 0) break;
            arg = null;
            break;
        }
        return arg;
    }

    private boolean argExists(String[] args, String s) {
        boolean rc = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith(s)) continue;
            rc = true;
            break;
        }
        return rc;
    }

    private int getIntArg(String[] args, String s) {
        int n = 0;
        String arg = this.getArg(args, s);
        if (arg != null) {
            try {
                n = Integer.parseInt(arg);
            }
            catch (Exception e) {
                System.out.println(s + " has an invalid integer value; using 0");
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(BrokerConfiguration bc) {
        boolean failed = true;
        Rocf rocf = new Rocf();
        Connection c = new Connection();
        c.setAccessMethod("RMI");
        if (bc.getBrokerHost() != null) {
            c.setHost(bc.getBrokerHost());
        }
        try {
            BrokerInterface b = (BrokerInterface)rocf.newInstance("com.sas.rmi.Broker", c);
            failed = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            rocf.stop();
        }
        return failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResource(String name) {
        File f = new File(name);
        if (!f.isFile()) {
            System.out.println("Resource file '" + name + "' does not exist");
            return;
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "r");
            int lineNo = 0;
            String line = "";
            while (line != null) {
                line = raf.readLine();
                ++lineNo;
                if (line == null || (line = line.trim()).length() == 0 || line.startsWith("//")) continue;
                this.processResourceLine(line, lineNo);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void processResourceLine(String line, int lineNo) {
        int index = line.indexOf("=");
        String command = "";
        if (index > 0) {
            command = line.substring(0, index).toUpperCase();
            command = command.trim();
            line = line.substring(index + 1);
        }
        if (command.equals("POOL")) {
            int i;
            Vector<String> v = new Vector<String>();
            line = line.trim();
            while (line.length() > 0) {
                char c;
                boolean inQuotes = false;
                for (i = 0; i < line.length() && ((c = line.charAt(i)) != ' ' || inQuotes); ++i) {
                    if (c != '\"') continue;
                    inQuotes = !inQuotes;
                }
                String token = line.substring(0, i);
                line = i >= line.length() ? "" : line.substring(i + 1).trim();
                v.addElement(token);
            }
            String[] args = new String[v.size()];
            for (i = 0; i < v.size(); ++i) {
                args[i] = (String)v.elementAt(i);
            }
            this.config(args);
        } else {
            System.out.println("Error at line " + lineNo + ": Unknown command '" + line + "'");
        }
    }
}

