/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.server.wq;

import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.RemoteObject;
import com.sas.net.connect.RemoteObjectExtension;
import com.sas.net.connect.RemoteObjectRB;
import com.sas.net.server.AfAccessInterface;
import com.sas.net.server.AfRequestInterface;
import com.sas.net.server.RemoteSasException;
import com.sas.net.server.wq.WQAfRequest;
import com.sas.net.server.wq.WQWorkspace;
import com.sas.text.Message;
import java.lang.ref.WeakReference;
import java.util.Vector;

public class WQAfAccess
implements AfAccessInterface {
    protected ConnectClient client = null;
    protected RemoteObjectExtension ext = null;
    protected WQWorkspace parent = null;
    protected Vector requestList = new Vector();

    @Override
    public synchronized AfRequestInterface createRemoteInstance(String name) throws RemoteSasException {
        try {
            WQAfRequest wqAfRequest = new WQAfRequest(this, this.ext.createRemoteInstance(name));
            WeakReference<WQAfRequest> ref = new WeakReference<WQAfRequest>(wqAfRequest);
            wqAfRequest.setReference(ref);
            this.requestList.addElement(ref);
            return wqAfRequest;
        }
        catch (ConnectException j) {
            throw new RemoteSasException(j);
        }
    }

    @Override
    public synchronized AfRequestInterface bindRemoteInstance(double handle) throws RemoteSasException {
        if (this.client == null) {
            String messageIndex = "RemObj.R25.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            throw new RemoteSasException(message);
        }
        try {
            Double Handle = new Double(handle);
            RemoteObject remoteObject = new RemoteObject(this.client, Handle);
            WQAfRequest wqAfRequest = new WQAfRequest(this, remoteObject);
            return wqAfRequest;
        }
        catch (ConnectException j) {
            throw new RemoteSasException(j);
        }
    }

    @Override
    public void setProperty(String name, Object value) throws RemoteSasException {
        try {
            this.ext.setProperty(name, value);
        }
        catch (ConnectException j) {
            throw new RemoteSasException(j);
        }
    }

    @Override
    public Object getProperty(String name) throws RemoteSasException {
        try {
            return this.ext.getProperty(name);
        }
        catch (ConnectException j) {
            throw new RemoteSasException(j);
        }
    }

    @Override
    public synchronized void release() throws RemoteSasException {
        if (this.client == null) {
            return;
        }
        this.client.removeExtension(this.ext.getClass().getName());
        this.ext = null;
        this.client = null;
        while (!this.requestList.isEmpty()) {
            WeakReference ref = (WeakReference)this.requestList.elementAt(0);
            WQAfRequest wqAfRequest = (WQAfRequest)ref.get();
            if (wqAfRequest == null) continue;
            wqAfRequest.release();
        }
    }

    protected WQAfAccess(WQWorkspace parent, ConnectClient client) throws RemoteSasException {
        this.client = client;
        this.parent = parent;
        try {
            String extName = RemoteObjectExtension.class.getName();
            client.addExtension(extName);
            this.ext = (RemoteObjectExtension)client.getExtension(extName);
        }
        catch (ConnectException j) {
            throw new RemoteSasException(j);
        }
    }

    protected void removeAfRequest(WeakReference wqAfRequest) {
        this.requestList.removeElement(wqAfRequest);
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }
}

