/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.server.jdbc;

import com.sas.net.server.AfAccessInterface;
import com.sas.net.server.FileSystemBrowserInterface;
import com.sas.net.server.OutputDeliveryInterface;
import com.sas.net.server.RemoteSasException;
import com.sas.net.server.SubmitInterface;
import com.sas.net.server.WorkspaceInterface;
import com.sas.net.server.jdbc.JDBCSession;
import com.sas.spedo.SpedoManagerInterface;
import com.sas.spedo.jdbc.JDBCSpedoManager;
import java.sql.Connection;
import java.sql.SQLException;

public class JDBCWorkspace
implements WorkspaceInterface {
    private JDBCSession parent = null;
    private Connection connection = null;
    private SpedoManagerInterface spedo = null;

    protected JDBCWorkspace(JDBCSession parent) {
        this.parent = parent;
    }

    @Override
    public synchronized Connection getSqlObject() throws RemoteSasException {
        if (this.parent == null) {
            throw new RemoteSasException("Cannot use a server object that has been released");
        }
        if (this.connection == null) {
            this.connection = this.parent.getConnection();
        }
        return this.connection;
    }

    @Override
    public synchronized SpedoManagerInterface getSpedoManagerObject() throws RemoteSasException {
        if (this.parent == null) {
            throw new RemoteSasException("Cannot use a server object that has been released");
        }
        if (this.spedo == null) {
            try {
                Connection connection = this.getSqlObject();
                this.spedo = new JDBCSpedoManager(connection);
            }
            catch (Exception e) {
                throw new RemoteSasException(e);
            }
        }
        return this.spedo;
    }

    @Override
    public AfAccessInterface getAfAccessObject() throws RemoteSasException {
        throw new RemoteSasException("not implemented");
    }

    @Override
    public SubmitInterface getLanguageObject() throws RemoteSasException {
        throw new RemoteSasException("not implemented");
    }

    @Override
    public FileSystemBrowserInterface getFileSystemBrowserObject() throws RemoteSasException {
        throw new RemoteSasException("not implemented");
    }

    @Override
    public OutputDeliveryInterface getOutputDeliveryObject() throws RemoteSasException {
        throw new RemoteSasException("not implemented");
    }

    @Override
    public synchronized void release() throws RemoteSasException {
        if (this.parent == null) {
            return;
        }
        this.parent.removeWorkspace(this);
        this.parent = null;
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (SQLException e) {
                this.connection = null;
                throw new RemoteSasException(e);
            }
        }
        if (this.spedo != null) {
            this.spedo = null;
        }
    }
}

