/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.server.jdbc;

import com.sas.net.server.RemoteSasException;
import com.sas.net.server.SessionInterface;
import com.sas.net.server.WorkspaceInterface;
import com.sas.net.server.jdbc.JDBCWorkspace;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;

public class JDBCSession
implements SessionInterface {
    protected Driver driver = null;
    protected Connection firstConnection = null;
    protected Vector workspaceList = new Vector();
    protected String jdbcDriverUrl = null;
    protected Properties properties = null;
    protected int majorVersion = -1;
    protected int minorVersion = -1;

    public JDBCSession(Properties properties) throws RemoteSasException {
        this.properties = (Properties)properties.clone();
        try {
            this.jdbcDriverUrl = this.properties.getProperty("jdbcDriverUrl");
            this.driver = DriverManager.getDriver(this.jdbcDriverUrl);
            this.firstConnection = this.connect();
            DatabaseMetaData metaData = this.firstConnection.getMetaData();
            String versionString = metaData.getDatabaseProductVersion();
            this.getVersionNumbers(versionString);
        }
        catch (SQLException e) {
            throw new RemoteSasException(e);
        }
    }

    @Override
    public synchronized WorkspaceInterface getNewWorkspace() throws RemoteSasException {
        if (this.driver == null) {
            throw new RemoteSasException("Cannot use a server object that has been released");
        }
        JDBCWorkspace workspace = new JDBCWorkspace(this);
        this.workspaceList.addElement(workspace);
        return workspace;
    }

    @Override
    public synchronized int getMajorSasVersion() throws RemoteSasException {
        if (this.driver == null) {
            throw new RemoteSasException("Cannot use a server object that has been released");
        }
        if (this.majorVersion == -1) {
            throw new RemoteSasException("not implemented");
        }
        return this.majorVersion;
    }

    @Override
    public synchronized int getMinorSasVersion() throws RemoteSasException {
        if (this.driver == null) {
            throw new RemoteSasException("Cannot use a server object that has been released");
        }
        if (this.minorVersion == -1) {
            throw new RemoteSasException("not implemented");
        }
        return this.minorVersion;
    }

    @Override
    public synchronized void release() throws RemoteSasException {
        if (this.driver == null) {
            return;
        }
        if (this.firstConnection != null) {
            try {
                this.firstConnection.close();
                this.firstConnection = null;
            }
            catch (SQLException e) {
                throw new RemoteSasException(e);
            }
        }
        while (!this.workspaceList.isEmpty()) {
            WorkspaceInterface workspace = null;
            workspace = (WorkspaceInterface)this.workspaceList.firstElement();
            workspace.release();
        }
        this.driver = null;
    }

    private Connection connect() throws RemoteSasException {
        Connection connection = null;
        try {
            connection = this.driver.connect(this.jdbcDriverUrl, this.properties);
        }
        catch (SQLException e) {
            throw new RemoteSasException(e);
        }
        return connection;
    }

    protected void removeWorkspace(WorkspaceInterface workspace) {
        this.workspaceList.removeElement(workspace);
    }

    protected synchronized Connection getConnection() throws RemoteSasException {
        Connection connection = null;
        if (this.firstConnection != null) {
            connection = this.firstConnection;
            this.firstConnection = null;
        } else {
            connection = this.connect();
        }
        return connection;
    }

    protected void getVersionNumbers(String versionString) {
        if (versionString == null) {
            return;
        }
        int length = versionString.length();
        if (length == 0) {
            return;
        }
        int firstDot = versionString.indexOf(".");
        try {
            if (firstDot == -1) {
                this.majorVersion = Integer.parseInt(versionString);
                this.minorVersion = 0;
                return;
            }
            this.majorVersion = Integer.parseInt(versionString.substring(0, firstDot));
        }
        catch (Exception e) {
            return;
        }
        if (firstDot + 1 == length) {
            this.minorVersion = 0;
            return;
        }
        int secondDot = versionString.indexOf(".", firstDot + 1);
        try {
            this.minorVersion = secondDot == -1 ? Integer.parseInt(versionString.substring(firstDot + 1)) : Integer.parseInt(versionString.substring(firstDot + 1, secondDot));
        }
        catch (Exception e) {
            this.minorVersion = 0;
            return;
        }
    }

    static {
        try {
            Class.forName("com.sas.net.sharenet.ShareNetDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

