/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.server;

import com.sas.net.server.RemoteSasException;
import com.sas.net.server.SessionFactoryNotificationInterface;
import com.sas.net.server.SessionInterface;
import com.sas.net.server.jdbc.JDBCSession;
import com.sas.net.server.wq.WQSession;
import com.sas.security.BaseSecuritySupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public class SessionFactory
implements Runnable {
    private Properties properties = null;
    private Class implClass = null;
    private SessionFactoryNotificationInterface callback = null;

    private SessionFactory(Properties properties, Class implClass, SessionFactoryNotificationInterface callback) {
        this.properties = properties;
        this.implClass = implClass;
        this.callback = callback;
    }

    @Override
    public void run() {
        try {
            SessionInterface session = SessionFactory.newInstance(this.properties, this.implClass);
            this.callback.sessionReady(session);
        }
        catch (RemoteSasException e) {
            this.callback.sessionCreationFailed(e);
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }

    public static SessionInterface getNewSession(Properties properties) throws RemoteSasException {
        Class implClass = SessionFactory.determineImplClass(properties);
        return SessionFactory.newInstance(properties, implClass);
    }

    public static Thread requestNewSession(Properties properties, SessionFactoryNotificationInterface callback) {
        Class implClass = SessionFactory.determineImplClass(properties);
        SessionFactory factory = new SessionFactory(properties, implClass, callback);
        BaseSecuritySupport securitySupport = BaseSecuritySupport.securitySupport;
        Thread factoryThread = securitySupport.createThread((Runnable)factory);
        factoryThread.start();
        return factoryThread;
    }

    private static SessionInterface newInstance(Properties properties, Class implClass) throws RemoteSasException {
        SessionInterface iSession = null;
        Constructor iSessionConstructor = null;
        try {
            Class[] argt = new Class[]{Properties.class};
            iSessionConstructor = implClass.getConstructor(argt);
        }
        catch (NoSuchMethodException e1) {
            throw new RemoteSasException(e1);
        }
        try {
            Object[] argv = new Object[]{properties};
            iSession = (SessionInterface)iSessionConstructor.newInstance(argv);
        }
        catch (IllegalAccessException e2) {
            throw new RemoteSasException(e2);
        }
        catch (InstantiationException e3) {
            throw new RemoteSasException(e3);
        }
        catch (InvocationTargetException e4) {
            Throwable e = e4.getTargetException();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RemoteSasException) {
                throw (RemoteSasException)((Object)e);
            }
            throw new RemoteSasException(e);
        }
        return iSession;
    }

    private static Class determineImplClass(Properties properties) {
        String implClassName = properties.getProperty("implClassName");
        if (implClassName != null && implClassName.length() > 0) {
            try {
                return Class.forName(implClassName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        Class implClass = null;
        String jdbcDriverUrl = properties.getProperty("jdbcDriverUrl");
        implClass = jdbcDriverUrl != null && jdbcDriverUrl.length() > 0 ? JDBCSession.class : WQSession.class;
        return implClass;
    }
}

