/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.jdbc;

import com.sas.collection.ContentsChangedListener;
import com.sas.collection.OrderedListCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.net.jdbc._rprxIOMSchemaList;
import com.sas.rio.MVAConnection;
import com.sas.util.ApplyInterface;
import com.sas.util.Util;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public class FinalIOMSchemaList
extends _rprxIOMSchemaList {
    private OrderedListCollection list = new OrderedListCollection();
    private String filter = null;
    private transient IWorkspace workspace = null;
    private transient Connection sqlConnection = null;

    @Override
    public void _RemoteObject_setup(com.sas.rmi.Connection ctxt) {
        try {
            this.workspace = (IWorkspace)ctxt._getWorkspace();
            IDataService dataService = this.workspace.DataService();
            Properties props = new Properties();
            this.sqlConnection = new MVAConnection(dataService, props);
        }
        catch (SQLException sqle) {
            this.workspace = null;
            this.sqlConnection = null;
            sqle.printStackTrace();
        }
    }

    public void initialize() {
        super.initialize();
        this.resubmitQuery();
    }

    @Override
    public void resubmitQuery() {
        if (this.list.count() > 0) {
            this.list.removeAll();
        }
        try {
            DatabaseMetaData metaData = this.sqlConnection.getMetaData();
            ResultSet schemas = metaData.getSchemas();
            while (schemas.next()) {
                String schemaName = schemas.getString(1).trim();
                if (this.filter != null && !schemaName.equalsIgnoreCase(this.filter)) continue;
                this.list.add((Object)schemaName);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void setFilter(String filter) {
        if (filter != null && (filter = filter.trim()).length() == 0) {
            filter = null;
        }
        if (Util.equal((Object)this.filter, (Object)filter)) {
            return;
        }
        String temp = this.filter;
        this.filter = filter;
        this.resubmitQuery();
        this.firePropertyChange("filter", temp, filter);
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public String getSchemaTerm() {
        try {
            DatabaseMetaData metaData = this.sqlConnection.getMetaData();
            return metaData.getSchemaTerm();
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public boolean equals(StaticOrderedCollectionInterface orderedCollection) {
        return this.list.equals(orderedCollection);
    }

    @Override
    public Object get(int index) {
        return this.list.get(index);
    }

    @Override
    public int getIndex(Object element, int startIndex) {
        return this.list.getIndex(element, startIndex);
    }

    @Override
    public Enumeration getItems(int start, int end) {
        return this.list.getItems(start, end);
    }

    @Override
    public int getLastIndex(Object element, int startIndex) {
        return this.list.getLastIndex(element, startIndex);
    }

    public Object clone() throws CloneNotSupportedException {
        FinalIOMSchemaList clone = (FinalIOMSchemaList)super.clone();
        clone.list = (OrderedListCollection)this.list.clone();
        return clone;
    }

    @Override
    public boolean contains(Object element) {
        return this.list.contains(element);
    }

    @Override
    public void apply(ApplyInterface action) {
        this.list.apply(action);
    }

    @Override
    public int count() {
        return this.list.count();
    }

    @Override
    public Enumeration getItems() {
        return this.list.getItems();
    }

    @Override
    public void addContentsChangedListener(ContentsChangedListener listener) {
        this.list.addContentsChangedListener(listener);
    }

    @Override
    public void removeContentsChangedListener(ContentsChangedListener listener) {
        this.list.removeContentsChangedListener(listener);
    }
}

