/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.connect;

import com.sas.collection.hlist.HList;
import com.sas.collection.hlist.HListInterface;
import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.ConnectRecord;
import com.sas.net.connect.RemoteObject;
import com.sas.net.connect.RemoteObjectExtension;
import com.sas.net.connect.RemoteObjectRB;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class RemoteObjectResponseRecord
extends ConnectRecord {
    public RemoteObjectResponseRecord(ConnectClient client) throws ConnectException {
        super(client, true);
        this.maxlen = 1024;
    }

    public synchronized void action() throws ConnectException {
        super.action();
        RemoteObjectExtension ext = (RemoteObjectExtension)this.client.getExtension(RemoteObjectExtension.class.getName());
        ByteArrayInputStream temp = new ByteArrayInputStream(this.buf);
        DataInputStream stream = new DataInputStream(temp);
        int tsub_code = 0;
        Double handle = null;
        RemoteObject remoteObject = null;
        int returnValue = 0;
        try {
            tsub_code = stream.readInt();
            returnValue = stream.readInt();
            handle = new Double(stream.readDouble());
            switch (tsub_code) {
                case 2: {
                    if (handle == 0.0) {
                        String messageIndex = "RemObj.R20.ex.txt";
                        String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
                        String message = Message.format((String)messagePattern, (Object)messageIndex);
                        throw new ConnectException(message);
                    }
                    String name = "name";
                    remoteObject = new RemoteObject(this.client, name, handle);
                    ext.addRemoteInstance(handle, remoteObject);
                    break;
                }
                case 4: {
                    String listEncoding = "UTF8";
                    try {
                        String tempEncoding = (String)ext.getProperty(RemoteObjectExtension.SERVERENCODING);
                        if (tempEncoding != null) {
                            listEncoding = tempEncoding;
                        }
                    }
                    catch (ConnectException tempEncoding) {
                        // empty catch block
                    }
                    if (returnValue == 9) {
                        HList errorHList = new HList();
                        errorHList.read(stream, listEncoding);
                        String messageIndex = "RemObj.R21.ex.txt";
                        String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
                        String message = Message.format((String)messagePattern, (Object)messageIndex, (Object)errorHList.getString(0));
                        throw new ConnectException(message);
                    }
                    if (returnValue != 0) {
                        String messageIndex = "RemObj.R22.ex.txt";
                        String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
                        String message = Message.format((String)messagePattern, (Object)messageIndex);
                        throw new ConnectException(message);
                    }
                    remoteObject = ext.getRemoteObject(handle);
                    HList hList = new HList();
                    hList.read(stream, listEncoding);
                    remoteObject.setArguments((HListInterface)hList);
                    break;
                }
                case 6: {
                    if (returnValue != 0) {
                        String messageIndex = "RemObj.R23.ex.txt";
                        String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
                        String message = Message.format((String)messagePattern, (Object)messageIndex);
                        throw new ConnectException(message);
                    }
                    break;
                }
                default: {
                    String messageIndex = "RemObj.R24.ex.txt";
                    String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
                    String message = Message.format((String)messagePattern, (Object)messageIndex);
                    throw new ConnectException(message);
                }
            }
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }
}

