/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.connect;

import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectClientExtensionInterface;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.ConnectRecord;
import com.sas.net.connect.CreateRemoteInstanceRecord;
import com.sas.net.connect.DestroyRemoteInstanceRecord;
import com.sas.net.connect.EnableRemoteInterface;
import com.sas.net.connect.InvokeRemoteMethodRecord;
import com.sas.net.connect.RemoteInterfaceOkRecord;
import com.sas.net.connect.RemoteObject;
import com.sas.net.connect.RemoteObjectRB;
import com.sas.net.connect.RemoteObjectResponseRecord;
import com.sas.text.Message;
import java.util.Hashtable;
import java.util.Properties;

public class RemoteObjectExtension
implements ConnectClientExtensionInterface {
    public static String SERVERENCODING = "serverEncoding";
    public static String SERVERLISTVERSION = "listVersion";
    public static final Integer SERVERLISTVERSION_DEFAULT = new Integer(1);
    public static final String SERVERENCODING_DEFAULT = "UTF8";
    public static final String resourceBundleName = "com.sas.net.connect.RemoteObjectResources";
    protected ConnectClient client = null;
    protected Hashtable recordTable = new Hashtable();
    protected boolean remoteInited = false;
    protected RemoteObject remoteInstance = null;
    protected Hashtable remoteObjectTable = new Hashtable();
    protected Properties properties = null;

    public synchronized RemoteObject createRemoteInstance(String name) throws ConnectException {
        ConnectRecord record;
        if (this.client == null) {
            String messageIndex = "RemObj.R13.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            throw new ConnectException(message);
        }
        if (!this.remoteInited) {
            record = new EnableRemoteInterface(this.client);
            this.client.addRecords(record, true);
            this.client.drain();
        }
        if (!this.remoteInited) {
            String messageIndex = "RemObj.R14.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            throw new ConnectException(message);
        }
        record = new CreateRemoteInstanceRecord(this.client, name);
        this.client.addRecords(record, true);
        this.client.drain();
        RemoteObject remoteObject = this.remoteInstance;
        this.remoteInstance = null;
        return remoteObject;
    }

    public synchronized void setProperty(String name, Object value) throws ConnectException {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(name, value);
    }

    public synchronized Object getProperty(String name) throws ConnectException {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public void setClient(ConnectClient client) {
        this.client = client;
    }

    public ConnectRecord getRecords(int recordCode) throws ConnectException {
        if (this.client == null) {
            String messageIndex = "RemObj.R16.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            throw new ConnectException(message);
        }
        ConnectRecord record = null;
        switch (recordCode) {
            case 84: {
                record = (ConnectRecord)this.recordTable.get("remoteInterface");
                if (record != null) break;
                record = new RemoteInterfaceOkRecord(this.client);
                this.recordTable.put("remoteInterface", record);
                break;
            }
            case 86: {
                record = (ConnectRecord)this.recordTable.get("remoteObjectResponse");
                if (record != null) break;
                record = new RemoteObjectResponseRecord(this.client);
                this.recordTable.put("remoteObjectResponse", record);
                break;
            }
        }
        return record;
    }

    protected synchronized void addRemoteInstance(Double handle, RemoteObject remoteObject) throws ConnectException {
        if (handle == 0.0) {
            this.remoteInstance = null;
            String messageIndex = "RemObj.R15.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            throw new ConnectException(message);
        }
        this.remoteInstance = remoteObject;
    }

    protected synchronized RemoteObject getRemoteObject(Double handle) throws ConnectException {
        return (RemoteObject)this.remoteObjectTable.remove(handle);
    }

    protected synchronized void invokeRemoteMethod(RemoteObject remoteObject, String name) throws ConnectException {
        if (!this.remoteInited) {
            String messageIndex = "RemObj.R17.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            throw new ConnectException(message);
        }
        this.remoteObjectTable.put(remoteObject.getHandle(), remoteObject);
        if (remoteObject == null) {
            String messageIndex = "RemObj.R18.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            throw new ConnectException(message);
        }
        InvokeRemoteMethodRecord record = new InvokeRemoteMethodRecord(this.client, remoteObject, name);
        this.client.addRecords((ConnectRecord)record, true);
        this.client.drain();
    }

    protected synchronized void destroyRemoteInstance(RemoteObject remoteObject) throws ConnectException {
        if (!this.remoteInited) {
            String messageIndex = "RemObj.R19.ex.txt";
            String messagePattern = RemoteObjectRB.getStringResource(messageIndex);
            String message = Message.format((String)messagePattern, (Object)messageIndex);
            throw new ConnectException(message);
        }
        Double handle = remoteObject.getHandle();
        DestroyRemoteInstanceRecord record = new DestroyRemoteInstanceRecord(this.client, remoteObject);
        this.client.addRecords((ConnectRecord)record, true);
        this.client.drain();
    }

    protected void setRemoteInited(boolean remoteInited) {
        this.remoteInited = remoteInited;
    }
}

