/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.collection.AssociationList;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.OrderedCollection;
import com.sas.collection.Set;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.hlist.HListInterface;
import com.sas.models.BufferHints;
import com.sas.models.IMDBColumn;
import com.sas.models.NodeInterface;
import com.sas.models.RB;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.SimpleTable;
import com.sas.sasserver.IMDB;
import com.sas.sasserver.dataset.DataSetInterface;
import com.sas.table.TableException;
import com.sas.util.ApplyInterface;
import com.sas.visuals.IconInterface;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class IMDBTable
extends SimpleTable
implements DataSetInterface {
    private transient IMDB imdb = null;
    protected transient OrderedCollection dataSetNames;
    protected transient OrderedCollection dataSetIDs;
    protected transient OrderedCollection updates;
    protected transient OrderedCollection columnInfos;
    protected transient boolean readOnly;
    protected transient boolean clearModel;
    protected transient String[][] updateTable;
    protected transient String currentQuery;
    protected transient String columnInfoUsed;
    protected transient boolean updateTableOnly;
    static final String RB_KEY = "IMDBTable.";

    public IMDBTable() {
        int rc = this.initIMDBTable(this.isDesignTime());
    }

    public IMDBTable(String host, String port, String userName, String password) {
        int rc = this.initIMDBTable(this.isDesignTime());
        this.serverConnect(host, port, userName, password);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        int rc = this.initIMDBTable(this.isDesignTime());
    }

    private int initIMDBTable(boolean isDesignTime) {
        if (isDesignTime) {
            return 0;
        }
        this.initializeAllData();
        return 0;
    }

    public IMDB getIMDB() {
        return this.imdb;
    }

    public void setIMDB(IMDB imdb) {
        this.imdb = imdb;
    }

    public void serverConnect(String host, String port, String userName, String password) {
        if (this.imdb == null) {
            this.imdb = new IMDB();
        }
        this.imdb.ServerConnect(host, port, userName, password);
    }

    public void serverDisconnect() {
        this.imdb.ServerDisconnect();
        this.imdb = null;
    }

    public int getNodeChildCount() {
        throw new RuntimeException("IMDBTable::getNodeChildCount()");
    }

    public String[][] getFormattedCells(int p1, int p2, int p3, int p4) throws TableException {
        Object[][] cellObjs = this.getCells(p1, p2, p3, p4);
        String[][] cellStrings = (String[][])cellObjs;
        return cellStrings;
    }

    @Override
    public void setRow(int rowIndex, Object[] cells) {
        if (!this.isCellsModifiable()) {
            String message = RB.getStringResource((String)RB_KEY, (String)"invalidAccess.ex.txt");
            throw new IllegalArgumentException(message);
        }
        if (!this.updateTableOnly) {
            AssociationList updateArray = new AssociationList();
            for (int i = 0; i < this.columnInfos.count(); ++i) {
                Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)i)).dataSetID;
                Object[] value = new Object[]{((IMDBColumn)this.columnInfos.get((int)i)).variableID, cells[i]};
                updateArray.add(0, (Object)dataSetID, (Object)value);
            }
            Enumeration e = updateArray.getKeys();
            String updateRequest = "";
            String verifyRequest = "";
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                String relativeRow = "";
                String whenIndex = "";
                String oldWhenValue = "";
                for (int i = 0; i < this.updateTable[0].length; ++i) {
                    if (this.updateTable[0][i].equalsIgnoreCase(key.toString())) {
                        relativeRow = this.updateTable[rowIndex][i];
                        whenIndex = this.updateTable[0][i + 1];
                        oldWhenValue = this.updateTable[rowIndex][i + 1];
                        i = this.updateTable[0].length;
                    }
                    ++i;
                }
                verifyRequest = verifyRequest + "^VERIFY^" + String.valueOf(key) + "^0^EQ^" + relativeRow + "^" + whenIndex + "^EQ^" + oldWhenValue;
                updateRequest = updateRequest + "^UPDATE^" + String.valueOf(key) + "^" + relativeRow;
                updateRequest = updateRequest + "^" + whenIndex + "^" + oldWhenValue;
                try {
                    while (true) {
                        Object[] item = (Object[])updateArray.get((Object)key);
                        updateRequest = updateRequest + "^" + String.valueOf(item[0]) + "^" + String.valueOf(item[1]);
                        updateArray.remove((Object)item);
                    }
                }
                catch (NoSuchElementException ex) {
                }
            }
            verifyRequest = verifyRequest.substring(1);
            String request = verifyRequest + updateRequest;
            try {
                String[][] item = this.imdb.DoRequestToArray(request, 1);
            }
            catch (Exception ex) {
                String message = RB.getStringResource((String)RB_KEY, (String)"updateFailed.ex.txt");
                throw new IllegalArgumentException(message);
            }
        }
        this.updateTableOnly = true;
        super.setRow(rowIndex, cells);
        this.updateTableOnly = false;
    }

    public String getNodeType() {
        throw new RuntimeException("IMDBTable::getNodeType()");
    }

    @Override
    public void setCell(int rowIndex, int columnIndex, Object cell) {
        if (!this.isCellsModifiable()) {
            String message = RB.getStringResource((String)RB_KEY, (String)"invalidAccess.ex.txt");
            throw new IllegalArgumentException(message);
        }
        if (!this.updateTableOnly) {
            Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)(columnIndex - 1))).dataSetID;
            Integer variableID = ((IMDBColumn)this.columnInfos.get((int)(columnIndex - 1))).variableID;
            String request = "";
            String relativeRow = "";
            String whenIndex = "";
            String oldWhenValue = "";
            for (int i = 0; i < this.updateTable[0].length; ++i) {
                if (this.updateTable[0][i].equalsIgnoreCase(dataSetID.toString())) {
                    relativeRow = this.updateTable[rowIndex][i];
                    whenIndex = this.updateTable[0][i + 1];
                    oldWhenValue = this.updateTable[rowIndex][i + 1];
                    i = this.updateTable[0].length;
                }
                ++i;
            }
            request = "VERIFY^" + String.valueOf(dataSetID) + "^0^EQ^" + relativeRow + "^" + whenIndex + "^EQ^" + oldWhenValue;
            request = request + "^UPDATE^" + String.valueOf(dataSetID) + "^" + relativeRow;
            request = request + "^" + whenIndex + "^" + oldWhenValue;
            request = request + "^" + String.valueOf(variableID) + "^" + cell;
            try {
                String[][] i = this.imdb.DoRequestToArray(request, 1);
            }
            catch (Exception ex) {
                String message = RB.getStringResource((String)RB_KEY, (String)"updateFailed.ex.txt");
                throw new IllegalArgumentException(message);
            }
        }
        super.setCell(rowIndex, columnIndex, cell);
    }

    public boolean equals(StaticOrderedCollectionInterface p1) {
        throw new RuntimeException("IMDBTable::equals()");
    }

    @Override
    public int _setEntry(String p1) {
        throw new RuntimeException("IMDBTable::_setEntry()");
    }

    @Override
    public HListInterface _formatValues(String p1, HListInterface p2) {
        throw new RuntimeException("IMDBTable::_formatValues()");
    }

    public void apply(ApplyInterface p1) {
        throw new RuntimeException("IMDBTable::apply()");
    }

    @Override
    public boolean isRowsInsertable() {
        return false;
    }

    @Override
    public int _countRows(int p1) {
        throw new RuntimeException("IMDBTable::_countRows()");
    }

    @Override
    public int _addRow(HListInterface p1, HListInterface p2) {
        return 0;
    }

    @Override
    public void enableEventsSilently(boolean p1) {
        throw new RuntimeException("IMDBTable::enableEventsSilently()");
    }

    public String getColumnInfoUsed() {
        return this.columnInfoUsed;
    }

    public SimpleNodeInterface[] getNodeChildren(int p1, int p2) {
        throw new RuntimeException("IMDBTable::getNodeChildren()");
    }

    public String getFormattedCell(int p1, int p2) throws TableException {
        Object cellObj = this.getCell(p1, p2);
        String cellString = cellObj.toString();
        return cellString;
    }

    public void setFormattedRow(int rowIndex, String[] cells) {
        this.setRow(rowIndex, cells);
    }

    @Override
    public void _setWhere(HListInterface p1) {
        throw new RuntimeException("IMDBTable::_setWhere()");
    }

    @Override
    public HListInterface _finfo() {
        throw new RuntimeException("IMDBTable::_finfo()");
    }

    @Override
    public void setPendingDataSet(String p1) {
        throw new RuntimeException("IMDBTable::setPendingDataSet()");
    }

    public int getColumnIndex(String columnName) throws TableException, IllegalArgumentException {
        String dataSetName = (String)this.dataSetNames.get(0);
        String request = "VARNAMES^" + dataSetName + "^VARID";
        String[][] ret2D = this.imdb.DoRequestToArray(request, 2);
        int position = -1;
        int i = 0;
        while (position == -1) {
            if (ret2D[i][0].equalsIgnoreCase(columnName)) {
                position = i;
            }
            ++i;
        }
        int index = Integer.parseInt(ret2D[position][1]);
        return index;
    }

    public Enumeration getItems() {
        throw new RuntimeException("IMDBTable::getItems()");
    }

    public String getNodeText() {
        throw new RuntimeException("IMDBTable::getNodeText()");
    }

    public String getNodeExpandedText() {
        throw new RuntimeException("IMDBTable::getNodeExpandedText()");
    }

    @Override
    public void setTextColumn(int p1) {
        throw new RuntimeException("IMDBTable::setTextColumn()");
    }

    public void setFormattedColumn(int columnIndex, String[] cells) {
        this.setColumn(columnIndex, cells);
    }

    @Override
    public boolean isColumnsRedefinable() {
        return false;
    }

    @Override
    public int _setSource(String p1) {
        throw new RuntimeException("IMDBTable::_setSource()");
    }

    @Override
    public HListInterface _fopen(String p1, String p2) {
        throw new RuntimeException("IMDBTable::_fopen()");
    }

    @Override
    public String getSource() {
        throw new RuntimeException("IMDBTable::getSource()");
    }

    public void setBufferBlocks(int p1) {
        throw new RuntimeException("IMDBTable::setBufferBlocks()");
    }

    public Object getColumnInfo(int index, String columnInfoName) throws TableException {
        int columnIndex;
        String[][] ret2D;
        String request;
        Integer fileID = ((IMDBColumn)this.columnInfos.get((int)(index - 1))).dataSetID;
        Integer variableID = ((IMDBColumn)this.columnInfos.get((int)(index - 1))).variableID;
        if (fileID == 0) {
            return null;
        }
        if (variableID == 0) {
            if (columnInfoName.equalsIgnoreCase("NAME")) {
                return "OBS";
            }
            return null;
        }
        int iData = this.dataSetIDs.getIndex((Object)fileID, 0);
        String dataSetName = (String)this.dataSetNames.get(iData);
        if (dataSetName.equalsIgnoreCase("UNKNOWN")) {
            request = "DSNAMES^DSID";
            ret2D = this.imdb.DoRequestToArray(request, 2);
            boolean found = false;
            for (int i = 0; !found && i < ret2D.length; ++i) {
                if (!ret2D[i][1].equalsIgnoreCase(fileID.toString())) continue;
                found = true;
                dataSetName = ret2D[i][0];
                this.dataSetNames.set(iData, (Object)dataSetName);
            }
        }
        if (columnInfoName.equalsIgnoreCase("NAME")) {
            columnIndex = 2;
            request = "VARNAMES^" + dataSetName + "^VARID";
        } else {
            request = "VARNAMES^" + dataSetName + "^VARID^" + columnInfoName;
            columnIndex = 3;
        }
        ret2D = this.imdb.DoRequestToArray(request, columnIndex);
        int position = -1;
        int i = 0;
        String Index2 = String.valueOf(variableID);
        while (position == -1) {
            if (ret2D[i][1].equalsIgnoreCase(Index2)) {
                position = i;
            }
            ++i;
        }
        String columnInfo = columnIndex == 2 ? ret2D[position][0] : ret2D[position][2];
        return columnInfo;
    }

    public String[] formatValues(int p1, Object[] p2) throws TableException {
        throw new RuntimeException("IMDBTable::formatValues()");
    }

    @Override
    public HListInterface _getColumnAttributes(int p1) {
        throw new RuntimeException("IMDBTable::_getColumnAttributes()");
    }

    public void commitRow() {
        throw new RuntimeException("IMDBTable::commitRow()");
    }

    @Override
    public void setDataSet(String dataSetName) {
        throw new RuntimeException("IMDBTable::setDataSet()");
    }

    @Override
    public String getDataSetOptions() {
        throw new RuntimeException("IMDBTable::getDataSetOptions()");
    }

    public boolean contains(Object p1) {
        throw new RuntimeException("IMDBTable::contains()");
    }

    @Override
    public boolean isMultipleRowUpdateSupported() {
        return this.isCellsModifiable();
    }

    public IconInterface getExpandedIcon() {
        throw new RuntimeException("IMDBTable::getExpandedIcon()");
    }

    @Override
    public void setLevelColumn(int p1) {
        throw new RuntimeException("IMDBTable::setLevelColumn()");
    }

    @Override
    public void addRow(int rowIndex, Object[] cells) {
        if (!this.isRowsExtendable()) {
            String message = RB.getStringResource((String)RB_KEY, (String)"rowsExtendable.ex.txt");
            throw new IllegalArgumentException(message);
        }
        if (!this.isRowsInsertable() && rowIndex != -1) {
            String message = RB.getStringResource((String)RB_KEY, (String)"rowsInsertable.ex.txt");
            throw new IllegalArgumentException(message);
        }
        AssociationList updateArray = new AssociationList();
        for (int i = 0; i < this.columnInfos.count(); ++i) {
            Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)i)).dataSetID;
            Object[] value = new Object[]{((IMDBColumn)this.columnInfos.get((int)i)).variableID, cells[i]};
            updateArray.add(0, (Object)dataSetID, (Object)value);
        }
        Enumeration e = updateArray.getKeys();
        String request = "";
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            String whenIndex = "";
            for (int i = 0; i < this.updateTable[0].length; ++i) {
                if (this.updateTable[0][i].equalsIgnoreCase(key.toString())) {
                    whenIndex = this.updateTable[0][i + 1];
                    i = this.updateTable[0].length;
                }
                ++i;
            }
            request = request + "^UPDATE^" + String.valueOf(key) + "^-1";
            request = request + "^" + whenIndex + "^0";
            try {
                while (true) {
                    Object[] item = (Object[])updateArray.get((Object)key);
                    request = request + "^" + String.valueOf(item[0]) + "^" + String.valueOf(item[1]);
                    updateArray.remove((Object)item);
                }
            }
            catch (NoSuchElementException ex) {
            }
        }
        request = request.substring(1);
        try {
            String[][] item = this.imdb.DoRequestToArray(request, 1);
        }
        catch (Exception ex) {
            String message = RB.getStringResource((String)RB_KEY, (String)"updateFailed.ex.txt");
            throw new IllegalArgumentException(message);
        }
        rowIndex = super.getRowCount() + 1;
        super.addRow(rowIndex, cells);
    }

    @Override
    public int _deleteRow(int p1) {
        throw new RuntimeException("IMDBTable::_deleteRow()");
    }

    @Override
    public int _getColumnCount() {
        throw new RuntimeException("IMDBTable::_getColumnCount()");
    }

    @Override
    public void setEntry(String p1) {
        throw new RuntimeException("IMDBTable::setEntry()");
    }

    @Override
    public String getEntry() {
        throw new RuntimeException("IMDBTable::getEntry()");
    }

    public void setColumnInfoUsed(String p1) throws TableException {
        throw new RuntimeException("IMDBTable::setColumnInfoUsed()");
    }

    @Override
    public void setCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount, Object[][] cells) {
        if (!this.isCellsModifiable()) {
            String message = RB.getStringResource((String)RB_KEY, (String)"invalidAccess.ex.txt");
            throw new IllegalArgumentException(message);
        }
        AssociationList updateArray = new AssociationList();
        for (int i = startColumnIndex; i < startColumnIndex + columnCount; ++i) {
            Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)i)).dataSetID;
            Object[] value = new Object[2];
            value[0] = ((IMDBColumn)this.columnInfos.get((int)i)).variableID;
            Object[] singleColumn = new Object[rowCount];
            for (int j = 0; j < rowCount; ++j) {
                singleColumn[j] = cells[j][i];
            }
            value[1] = singleColumn;
            updateArray.add(0, (Object)dataSetID, (Object)value);
        }
        Enumeration e = updateArray.getKeys();
        String updateRequest = "";
        String verifyRequest = "";
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            String[] relativeRows = new String[rowCount];
            String whenIndex = "";
            String[] oldWhenValues = new String[rowCount];
            for (int i = 0; i < this.updateTable[0].length; ++i) {
                if (this.updateTable[0][i].equalsIgnoreCase(key.toString())) {
                    whenIndex = this.updateTable[0][i + 1];
                    for (int j = 0; j < rowCount; ++j) {
                        relativeRows[j] = this.updateTable[j][i];
                        oldWhenValues[j] = this.updateTable[j][i + 1];
                        i = this.updateTable[0].length;
                    }
                }
                ++i;
            }
            for (int j = 0; j < rowCount; ++j) {
                verifyRequest = verifyRequest + "^VERIFY^" + String.valueOf(key) + "^0^EQ^" + relativeRows[j] + "^" + whenIndex + "^EQ^" + oldWhenValues[j];
                updateRequest = updateRequest + "^UPDATE^" + String.valueOf(key) + "^" + relativeRows[j];
                updateRequest = updateRequest + "^" + whenIndex + "^" + oldWhenValues[j];
                try {
                    while (true) {
                        Object[] item = (Object[])updateArray.get((Object)key);
                        updateRequest = updateRequest + "^" + String.valueOf(item[0]) + "^" + String.valueOf(((Object[])item[1])[j]);
                        updateArray.remove((Object)item);
                    }
                }
                catch (NoSuchElementException ex) {
                    continue;
                }
            }
        }
        verifyRequest = verifyRequest.substring(1);
        String request = verifyRequest + updateRequest;
        try {
            String[][] j = this.imdb.DoRequestToArray(request, 1);
        }
        catch (Exception ex) {
            String message = RB.getStringResource((String)RB_KEY, (String)"updateFailed.ex.txt");
            throw new IllegalArgumentException(message);
        }
        this.updateTableOnly = true;
        super.setCells(startRowIndex, startColumnIndex, rowCount, columnCount, cells);
        this.updateTableOnly = false;
    }

    @Override
    public boolean isCellsModifiable() {
        return !this.isReadOnly();
    }

    public IconInterface getExpandedSelectedIcon() {
        throw new RuntimeException("IMDBTable::getExpandedSelectedIcon()");
    }

    public void setFormattedCell(int rowIndex, int columnIndex, String cell) {
        this.setCell(rowIndex, columnIndex, cell);
    }

    @Override
    public boolean isRowsLabelSupported() {
        return false;
    }

    @Override
    public boolean isRowsDeletable() {
        if (this.clearModel) {
            return true;
        }
        return this.isCellsModifiable();
    }

    @Override
    public boolean isColumnsDeletable() {
        return this.clearModel;
    }

    @Override
    public HListInterface _getPartialFormattedRows(int p1, int p2) {
        throw new RuntimeException("IMDBTable::_getPartialFormattedRows()");
    }

    @Override
    public HListInterface _getPartialRows(int p1, int p2) {
        throw new RuntimeException("IMDBTable::_getPartialRows()");
    }

    @Override
    public void setLeafNode(boolean p1) {
        throw new RuntimeException("IMDBTable::setLeafNode()");
    }

    public String getWhere() {
        return this.getQuery();
    }

    public String getQuery() {
        return this.currentQuery;
    }

    public int countNodeChildren(int p1) {
        throw new RuntimeException("IMDBTable::countNodeChildren()");
    }

    @Override
    public void setColumn(int columnIndex, Object[] cells) {
        if (!this.isCellsModifiable()) {
            String message = RB.getStringResource((String)RB_KEY, (String)"invalidAccess.ex.txt");
            throw new IllegalArgumentException(message);
        }
        Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)columnIndex)).dataSetID;
        Integer variableID = ((IMDBColumn)this.columnInfos.get((int)columnIndex)).variableID;
        String updateRequest = "";
        String verifyRequest = "";
        String whenIndex = this.updateTable[0][columnIndex];
        for (int i = 0; i < this.getRowCount(); ++i) {
            String relativeRow = this.updateTable[i + 1][columnIndex];
            String oldWhenValue = this.updateTable[i + 1][columnIndex];
            verifyRequest = verifyRequest + "^VERIFY^" + String.valueOf(dataSetID) + "^0^EQ^" + relativeRow + "^" + whenIndex + "^EQ^" + oldWhenValue;
            updateRequest = updateRequest + "^UPDATE^" + String.valueOf(dataSetID) + "^" + relativeRow;
            updateRequest = updateRequest + "^" + whenIndex + "^" + oldWhenValue;
            updateRequest = updateRequest + "^" + String.valueOf(variableID) + "^" + cells[i];
        }
        verifyRequest = verifyRequest.substring(1);
        String request = verifyRequest + updateRequest;
        try {
            String[][] i = this.imdb.DoRequestToArray(request, 1);
        }
        catch (Exception ex) {
            String message = RB.getStringResource((String)RB_KEY, (String)"updateFailed.ex.txt");
            throw new IllegalArgumentException(message);
        }
        this.updateTableOnly = true;
        super.setColumn(columnIndex, cells);
        this.updateTableOnly = false;
    }

    @Override
    public int getIndexColumn() {
        throw new RuntimeException("IMDBTable::getIndexColumn()");
    }

    public Enumeration getItems(int p1, int p2) {
        throw new RuntimeException("IMDBTable::getItems()");
    }

    @Override
    public void deleteRow(int rowIndex) {
        if (this.clearModel) {
            super.deleteRow(rowIndex);
            return;
        }
        if (!this.isCellsModifiable()) {
            String message = RB.getStringResource((String)RB_KEY, (String)"invalidAccess.ex.txt");
            throw new IllegalArgumentException(message);
        }
        Set files = new Set();
        for (int i = 0; i < this.columnInfos.count(); ++i) {
            Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)i)).dataSetID;
            files.add((Object)dataSetID);
        }
        Enumeration e = files.getItems();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            String relativeRow = "";
            String whenIndex = "";
            String oldWhenValue = "";
            String request = "";
            for (int i = 0; i < this.updateTable[0].length; ++i) {
                if (this.updateTable[0][i].equalsIgnoreCase(key.toString())) {
                    relativeRow = this.updateTable[rowIndex][i];
                    whenIndex = this.updateTable[0][i + 1];
                    oldWhenValue = this.updateTable[rowIndex][i + 1];
                    i = this.updateTable[0].length;
                }
                ++i;
            }
            request = request + "VERIFY^" + String.valueOf(key) + "^0^EQ^" + relativeRow + "^" + whenIndex + "^EQ^" + oldWhenValue;
            request = request + "^DELETE^" + String.valueOf(key) + "^" + relativeRow;
            try {
                String[][] i = this.imdb.DoRequestToArray(request, 1);
            }
            catch (Exception ex) {
                String message = RB.getStringResource((String)RB_KEY, (String)"updateFailed.ex.txt");
                throw new IllegalArgumentException(message);
            }
        }
        super.deleteRow(rowIndex);
    }

    public void deleteRow(int rowIndex, OrderedCollection filesIncludedInDeletion) {
        if (!this.isCellsModifiable()) {
            String message = RB.getStringResource((String)RB_KEY, (String)"invalidAccess.ex.txt");
            throw new IllegalArgumentException(message);
        }
        Set files = new Set();
        for (int i = 0; i < this.columnInfos.count(); ++i) {
            Integer dataSetID = ((IMDBColumn)this.columnInfos.get((int)i)).dataSetID;
            if (!filesIncludedInDeletion.contains((Object)dataSetID)) continue;
            files.add((Object)dataSetID);
        }
        Enumeration e = files.getItems();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            String relativeRow = "";
            String whenIndex = "";
            String oldWhenValue = "";
            String request = "";
            for (int i = 0; i < this.updateTable[0].length; ++i) {
                if (this.updateTable[0][i].equalsIgnoreCase(key.toString())) {
                    relativeRow = this.updateTable[rowIndex][i];
                    whenIndex = this.updateTable[0][i + 1];
                    oldWhenValue = this.updateTable[rowIndex][i + 1];
                    i = this.updateTable[0].length;
                }
                ++i;
            }
            request = request + "VERIFY^" + String.valueOf(key) + "^0^EQ^" + relativeRow + "^" + whenIndex + "^EQ^" + oldWhenValue;
            request = request + "^DELETE^" + String.valueOf(key) + "^" + relativeRow;
            try {
                String[][] i = this.imdb.DoRequestToArray(request, 1);
            }
            catch (Exception ex) {
                String message = RB.getStringResource((String)RB_KEY, (String)"updateFailed.ex.txt");
                throw new IllegalArgumentException(message);
            }
        }
        super.deleteRow(rowIndex);
    }

    @Override
    public int _setRow(int p1, HListInterface p2, HListInterface p3) {
        throw new RuntimeException("IMDBTable::_setRow()");
    }

    @Override
    public int getLevelColumn() {
        throw new RuntimeException("IMDBTable::getLevelColumn()");
    }

    @Override
    public void _setDisplayedColumns(HListInterface p1) {
        throw new RuntimeException("IMDBTable::_setDisplayedColumns()");
    }

    @Override
    public HListInterface _getFormattedRows(int p1, int p2) {
        throw new RuntimeException("IMDBTable::_getFormattedRows()");
    }

    @Override
    public int _setDataSet(String p1, String p2) {
        throw new RuntimeException("IMDBTable::_setDataSet()");
    }

    @Override
    public void setSource(String p1) {
        throw new RuntimeException("IMDBTable::setSource()");
    }

    public boolean isLeafNode() {
        throw new RuntimeException("IMDBTable::isLeafNode()");
    }

    public String[] getFormattedRow(int rowIndex) {
        Object[] rowObj = this.getRow(rowIndex);
        String[] rowString = new String[rowObj.length];
        for (int i = 0; i < rowObj.length; ++i) {
            rowString[i] = rowObj[i].toString();
        }
        return rowString;
    }

    public int getIndex(Object p1, int p2) {
        throw new RuntimeException("IMDBTable::getIndex()");
    }

    @Override
    public boolean isColumnsExtendable() {
        return false;
    }

    @Override
    public void addColumn(int p1, Class p2, Object p3) {
        String message = RB.getStringResource((String)RB_KEY, (String)"columnsExtendableInsertable.ex.txt");
        throw new IllegalArgumentException(message);
    }

    public void useBufferHints(BufferHints p1) {
        throw new RuntimeException("IMDBTable::useBufferHints()");
    }

    public SimpleNodeInterface getNodeChild(int p1) {
        throw new RuntimeException("IMDBTable::getNodeChild()");
    }

    public String[] getFormattedColumn(int p1) throws TableException {
        throw new RuntimeException("IMDBTable::getFormattedColumn()");
    }

    public IconInterface getDefaultIcon() {
        throw new RuntimeException("IMDBTable::getDefaultIcon()");
    }

    @Override
    public void deleteColumn(int p1) {
        if (!this.isColumnsDeletable()) {
            String message = RB.getStringResource((String)RB_KEY, (String)"columnsDeletable.ex.txt");
            throw new IllegalArgumentException(message);
        }
        super.deleteColumn(p1);
    }

    @Override
    public int _setFormattedRow(int p1, HListInterface p2, HListInterface p3) {
        throw new RuntimeException("IMDBTable::_setFormattedRow()");
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (this.currentQuery != null) {
            this.refresh();
        }
    }

    public Object get(int p1) {
        throw new RuntimeException("IMDBTable::get()");
    }

    @Override
    public void setIndexColumn(int p1) {
        throw new RuntimeException("IMDBTable::setIndexColumn()");
    }

    public NodeInterface getRoot() {
        throw new RuntimeException("IMDBTable::getRoot()");
    }

    public void contentsChanged(ContentsChangedEvent p1) {
        throw new RuntimeException("IMDBTable::contentsChanged()");
    }

    public int getLastIndex(Object p1, int p2) {
        throw new RuntimeException("IMDBTable::getLastIndex()");
    }

    public void close() {
        throw new RuntimeException("IMDBTable::close()");
    }

    @Override
    public HListInterface _getMembers() {
        throw new RuntimeException("IMDBTable::_getMembers()");
    }

    public IconInterface getSelectedIcon() {
        throw new RuntimeException("IMDBTable::getSelectedIcon()");
    }

    @Override
    public int getTextColumn() {
        throw new RuntimeException("IMDBTable::getTextColumn()");
    }

    @Override
    public boolean isColumnsInsertable() {
        return false;
    }

    @Override
    public HListInterface _getRows(int p1, int p2) {
        throw new RuntimeException("IMDBTable::_getRows()");
    }

    @Override
    public int _getRowCount() {
        throw new RuntimeException("IMDBTable::_getRowCount()");
    }

    @Override
    public void setRootText(String p1) {
        throw new RuntimeException("IMDBTable::setRootText()");
    }

    public void setDisplayedColumns(String[] p1) {
        throw new RuntimeException("IMDBTable::setDisplayedColumns()");
    }

    @Override
    public String getDataSetName() {
        throw new RuntimeException("IMDBTable::getDataSetName()");
    }

    public int count() {
        throw new RuntimeException("IMDBTable::count()");
    }

    public int getBufferBlocks() {
        throw new RuntimeException("IMDBTable::getBufferBlocks()");
    }

    public int getBufferSize() {
        throw new RuntimeException("IMDBTable::getBufferSize()");
    }

    public void setBufferSize(int p1) {
        throw new RuntimeException("IMDBTable::setBufferSize()");
    }

    public String[] getDisplayedColumns() {
        throw new RuntimeException("IMDBTable::getDisplayedColumns()");
    }

    public void refresh() {
        this.setQuery(this.currentQuery);
    }

    public String[] getColumnInfoNames() throws TableException {
        throw new RuntimeException("IMDBTable::getColumnInfoNames()");
    }

    @Override
    public void _commitRow() {
        throw new RuntimeException("IMDBTable::_commitRow()");
    }

    @Override
    public int _close() {
        throw new RuntimeException("IMDBTable::_close()");
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public String getDataSet() {
        throw new RuntimeException("IMDBTable::getDataSet()");
    }

    public void setFormattedCells(int p1, int p2, int p3, int p4, String[][] p5) throws TableException {
        throw new RuntimeException("IMDBTable::setFormattedCells()");
    }

    @Override
    public boolean isRowsExtendable() {
        return this.isCellsModifiable();
    }

    @Override
    public String getRootText() {
        throw new RuntimeException("IMDBTable::getRootText()");
    }

    public void setWhere(String request) {
        this.setQuery(request);
    }

    public void setQuery(String request) {
        StringTokenizer t;
        String[] returnVars = IMDB.getReturnVars(request, true);
        this.clearAllData();
        this.currentQuery = request;
        boolean multiple = false;
        if (returnVars.length > 0) {
            t = new StringTokenizer(returnVars[0], ".");
            if (t.countTokens() > 1) {
                multiple = true;
            } else {
                multiple = false;
                StringTokenizer t2 = new StringTokenizer(request, "^");
                t2.nextToken();
                this.dataSetIDs.add((Object)Integer.valueOf(t2.nextToken()));
                this.dataSetNames.add((Object)"UNKNOWN");
            }
        }
        for (int i = 0; i < returnVars.length; ++i) {
            IMDBColumn columnInfo;
            if (multiple) {
                t = new StringTokenizer(returnVars[i], ".");
                columnInfo = new IMDBColumn();
                columnInfo.dataSetID = Integer.valueOf(t.nextToken());
                columnInfo.variableID = Integer.valueOf(t.nextToken());
                this.columnInfos.append(i, (Object)columnInfo);
                if (!this.dataSetIDs.contains((Object)columnInfo.dataSetID)) {
                    this.dataSetIDs.add((Object)columnInfo.dataSetID);
                    this.dataSetNames.add((Object)"UNKNOWN");
                }
            } else {
                columnInfo = new IMDBColumn();
                columnInfo.dataSetID = (Integer)this.dataSetIDs.get(0);
                columnInfo.variableID = Integer.valueOf(returnVars[i]);
                this.columnInfos.append(i, (Object)columnInfo);
            }
            super.addColumn(i + 1, String.class, null);
            this.setColumnLabel(i + 1, returnVars[i]);
        }
        int count = 0;
        String[] updateRow0 = new String[this.dataSetIDs.count() * 2];
        if (!this.readOnly) {
            String requestUpdateInfo = "select^0^2^IN^" + this.dataSetIDs.count();
            for (int i = 0; i < this.dataSetIDs.count(); ++i) {
                requestUpdateInfo = requestUpdateInfo + "^" + this.dataSetIDs.get(i).toString();
            }
            String[][] result = this.imdb.DoRequestToArray(requestUpdateInfo = requestUpdateInfo + "^3^UPEQ^WHEN^return^4", 1);
            if (result.length != this.dataSetIDs.count()) {
                System.out.println("The data you requested is browse only");
            } else {
                for (int j = 0; j < result.length; ++j) {
                    this.updates.add((Object)result[j][0]);
                }
            }
            for (int i = 0; i < this.dataSetIDs.count(); ++i) {
                String obs = this.dataSetIDs.get(i).toString();
                String when = this.updates.get(i).toString();
                request = request + "^" + obs + ".0";
                request = request + "^" + obs + "." + when;
                count += 2;
                updateRow0[i * 2] = obs;
                updateRow0[i * 2 + 1] = when;
            }
        }
        String[][] ret2D = this.imdb.DoRequestToArray(request, returnVars.length + count);
        if (!this.readOnly) {
            this.updateTable = new String[ret2D.length + 1][count];
            this.updateTable[0] = updateRow0;
        }
        for (int i = 0; i < ret2D.length; ++i) {
            if (!this.readOnly) {
                int j;
                String[] newRow = new String[returnVars.length];
                for (j = 0; j < returnVars.length; ++j) {
                    newRow[j] = ret2D[i][j];
                }
                super.addRow(i + 1, newRow);
                for (j = 0; j < count; ++j) {
                    this.updateTable[i + 1][j] = ret2D[i][j + returnVars.length];
                }
                continue;
            }
            super.addRow(i + 1, ret2D[i]);
        }
    }

    protected synchronized void initializeAllData() {
        this.columnInfos = new OrderedCollection();
        this.dataSetNames = new OrderedCollection();
        this.dataSetIDs = new OrderedCollection();
        this.updates = new OrderedCollection();
        this.readOnly = true;
        this.clearModel = false;
        this.currentQuery = null;
        this.updateTableOnly = false;
    }

    protected synchronized void clearAllData() {
        this.columnInfos.removeAll();
        this.dataSetNames.removeAll();
        this.dataSetIDs.removeAll();
        this.updates.removeAll();
        this.clearModel = true;
        super.deleteAllRows();
        super.deleteAllColumns();
        this.clearModel = false;
        this.currentQuery = null;
    }
}

