/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.PublicClonable;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.OrderedCollection;
import com.sas.models.ColorNameList;
import com.sas.models.NodeInterface;
import com.sas.models.RB;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import java.awt.Color;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ColorList
extends OrderedCollection
implements TreeInterface,
NodeInterface,
PublicClonable {
    static final long serialVersionUID = -7048799895022463377L;
    protected String NodeName;
    protected String NodeType;
    static final String RB_KEY = "ColorList.";
    protected static String COLORNOTFOUNDERROR = RB.getStringResource((String)"ColorList.", (String)"colorNotFound.ex.txt");

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public ColorList(ColorNameList cnl) {
        this.setList(cnl);
        this.NodeName = RB.getStringResource((String)RB_KEY, (String)"nodeName.txt");
        this.NodeType = "ColorList";
    }

    public ColorList() {
        this.setList(null);
        this.NodeName = RB.getStringResource((String)RB_KEY, (String)"nodeName.txt");
        this.NodeType = "ColorList";
    }

    public ColorList(Enumeration e) {
        while (e.hasMoreElements()) {
            Color c = (Color)e.nextElement();
            if (c instanceof com.sas.awt.Color) {
                this.add(c);
                continue;
            }
            com.sas.awt.Color cc = com.sas.awt.Color.newColor((Color)c);
            this.add(cc);
        }
    }

    protected synchronized void setList(ColorNameList cnl) {
        super.removeAll();
        if (cnl == null) {
            cnl = new ColorNameList(false);
        }
        for (int i = 0; i < cnl.count(); ++i) {
            this.add(cnl.getKey(i));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ColorList newData = (ColorList)((Object)super.clone());
        return newData;
    }

    public synchronized NodeInterface getRoot() {
        return this;
    }

    public Color getColor(String colorName) {
        com.sas.awt.Color c = new com.sas.awt.Color(colorName);
        if (this.contains(c)) {
            return c;
        }
        throw new NoSuchElementException(COLORNOTFOUNDERROR);
    }

    public Color getColor(int rgb) {
        com.sas.awt.Color c = new com.sas.awt.Color(rgb);
        if (this.contains(c)) {
            return c;
        }
        throw new NoSuchElementException(COLORNOTFOUNDERROR);
    }

    public Enumeration getColors() {
        return this.getItems();
    }

    protected Object convertObject(Object c) {
        if (c == null) {
            return null;
        }
        if (c instanceof com.sas.awt.Color) {
            return c;
        }
        if (c instanceof Color) {
            return com.sas.awt.Color.newColor((Color)((Color)c));
        }
        if (c instanceof String) {
            return com.sas.awt.Color.newColor((String)((String)c));
        }
        if (c instanceof Number) {
            return com.sas.awt.Color.newColor((int)((Number)c).intValue());
        }
        throw new ClassCastException(RB.getStringResource((String)"invalidobj.ex.txt"));
    }

    public synchronized void add(Object c, int index) {
        if (c != null) {
            super.add(this.convertObject(c), index);
        }
    }

    public synchronized void addItems(Enumeration items, int index) {
        Vector<Object> tmpList = new Vector<Object>();
        while (items.hasMoreElements()) {
            Object nextItem = items.nextElement();
            if (nextItem == null) continue;
            tmpList.add(this.convertObject(nextItem));
        }
        super.addItems(tmpList.elements(), index);
    }

    public synchronized void set(int index, Object item) {
        if (item != null) {
            super.set(index, this.convertObject(item));
        }
    }

    public synchronized void append(int index, Object item) {
        if (item != null) {
            super.append(index, this.convertObject(item));
        }
    }

    public String getNodeExpandedText() {
        return this.NodeName;
    }

    public String getNodeText() {
        return this.NodeName;
    }

    public String getNodeType() {
        return this.NodeType;
    }

    public int countNodeChildren(int maximumChildCount) {
        return this.getNodeChildCount();
    }

    public int getNodeChildCount() {
        return this.count();
    }

    public boolean isLeafNode() {
        return this.count() == 0;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        return (SimpleNodeInterface)this.get(index);
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        SimpleNodeInterface[] sni = new SimpleNodeInterface[count];
        int i = 0;
        int cnt = this.count();
        for (int index = startIndex; index < cnt && index < count; ++index) {
            sni[i] = this.getNodeChild(index);
            ++i;
        }
        return sni;
    }
}

