/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mdtable;

import com.sas.mdtable.DrillListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class DrillListenerList
implements Serializable {
    private int numberOfListeners;
    private DrillListener[] listenerList;
    private static DrillListener[] emptyListenerList;
    private DrillListener[] listeners;
    private int increment;
    private static final int DEFAULT_INCREMENT = 8;

    public DrillListenerList() {
        this.increment = 8;
    }

    public DrillListenerList(int initialIncrement) {
        this.increment = initialIncrement <= 0 ? 8 : initialIncrement;
    }

    public int count() {
        return this.numberOfListeners;
    }

    private int indexOf(DrillListener listener) {
        if (this.listenerList != null) {
            for (int i = 0; i < this.numberOfListeners; ++i) {
                if (this.listenerList[i] != listener) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void add(DrillListener listener) {
        if (listener == null) {
            return;
        }
        if (this.indexOf(listener) != -1) {
            return;
        }
        this.listeners = null;
        if (this.listenerList == null || this.numberOfListeners >= this.listenerList.length) {
            if (this.numberOfListeners > 4 * this.increment) {
                this.increment *= 2;
            }
            DrillListener[] newListenerList = new DrillListener[this.numberOfListeners + this.increment];
            if (this.listenerList != null) {
                System.arraycopy(this.listenerList, 0, newListenerList, 0, this.numberOfListeners);
            }
            this.listenerList = newListenerList;
        }
        this.listenerList[this.numberOfListeners++] = listener;
    }

    public synchronized DrillListener[] getListeners() {
        if (this.listeners == null) {
            if (this.numberOfListeners > 0) {
                this.listeners = new DrillListener[this.numberOfListeners];
                System.arraycopy(this.listenerList, 0, this.listeners, 0, this.numberOfListeners);
            } else {
                if (emptyListenerList == null) {
                    emptyListenerList = new DrillListener[0];
                }
                return emptyListenerList;
            }
        }
        return this.listeners;
    }

    public synchronized void remove(DrillListener listener) {
        int index = this.indexOf(listener);
        if (index == -1) {
            return;
        }
        this.listeners = null;
        --this.numberOfListeners;
        if (this.numberOfListeners == 0) {
            if (emptyListenerList == null) {
                emptyListenerList = new DrillListener[0];
            }
            this.listenerList = null;
            return;
        }
        this.listenerList[index] = null;
        while (index < this.numberOfListeners) {
            this.listenerList[index++] = this.listenerList[index];
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.numberOfListeners == 0) {
            this.listenerList = null;
        }
    }
}

