/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mdtable;

import com.sas.collection.StaticPropertyBagInterface;
import com.sas.mdtable.AbstractDimension;
import com.sas.mdtable.Axis;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.HierarchyInterface;
import com.sas.mdtable.Level;
import com.sas.mdtable.LevelInterface;
import com.sas.mdtable.MultidimensionalTableView;
import com.sas.mdtable.Node;
import com.sas.table.TableException;
import java.awt.Graphics;

final class Dimension
extends AbstractDimension {
    Node node;
    private Level[] levels;
    private int m_position;

    public Dimension(Axis axis, DimensionInterface dimension) {
        super(axis);
        LevelInterface[] levs;
        this.node = new Node(dimension);
        try {
            levs = dimension.getLevels(0, dimension.getLevelCount());
        }
        catch (TableException ex) {
            levs = null;
            ex.printStackTrace();
        }
        this.levels = new Level[levs != null ? levs.length : 0];
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = new Level(this, levs[i]);
        }
    }

    @Override
    public final DimensionInterface getMetaDimension() {
        return (DimensionInterface)this.node.getMetaNode();
    }

    @Override
    public String getLabel() {
        return this.node.getLabel();
    }

    @Override
    public String getName() {
        return this.node.getName();
    }

    @Override
    public int getHierarchyCount() {
        try {
            return this.getMetaDimension().getHierarchyCount();
        }
        catch (TableException ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public HierarchyInterface getHierarchy(int index) {
        try {
            return this.getMetaDimension().getHierarchy(index);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public HierarchyInterface[] getHierarchies(int index, int count) throws TableException {
        try {
            return super.getHierarchies(index, count);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            return new HierarchyInterface[0];
        }
    }

    @Override
    public int getLevelCount() {
        return this.levels.length;
    }

    @Override
    public LevelInterface getLevel(int index) {
        return this.levels[index];
    }

    Level getLevel(LevelInterface levI) {
        int maxi = this.getLevelCount();
        for (int i = 0; i < maxi; ++i) {
            if (!levI.equals(this.getLevel(i).getMetaLevel())) continue;
            return (Level)this.getLevel(i);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public LevelInterface[] getLevels(int index, int count) {
        try {
            return super.getLevels(index, count);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            return new Level[0];
        }
    }

    public int countNodeChildren(int maxChildCount) {
        return this.getHierarchyCount();
    }

    public StaticPropertyBagInterface getDefaultCellStyle() {
        return this.node.getDefaultCellStyle();
    }

    public void setDefaultCellStyle(StaticPropertyBagInterface newValue) {
        this.node.setDefaultCellStyle(newValue);
    }

    public StaticPropertyBagInterface getDefaultLabelStyle() {
        return this.node.getDefaultLabelStyle();
    }

    public void setDefaultLabelStyle(StaticPropertyBagInterface newValue) {
        this.node.setDefaultLabelStyle(newValue);
    }

    public StaticPropertyBagInterface getModelDefaultCellStyle() {
        return this.node.getModelDefaultCellStyle();
    }

    public StaticPropertyBagInterface getModelDefaultLabelStyle() {
        return this.node.getModelDefaultLabelStyle();
    }

    public int getPosition() {
        return ((Axis)this.getAxis()).getPosition() + this.m_position;
    }

    public int computePreferredSize(Graphics g) {
        int size = 0;
        int maxl = this.getLevelCount();
        for (int l = 0; l < maxl; ++l) {
            Level lev = (Level)this.getLevel(l);
            lev.setPosition(size);
            int s = lev.getSize();
            if (s == 0) {
                lev.setPreferredSize(lev.computePreferredSize(g));
                s = lev.getSize();
            }
            size += s;
        }
        return size;
    }

    public int getSize() {
        int size = 0;
        int lCount = this.getLevelCount();
        for (int l = 0; l < lCount; ++l) {
            size += ((Level)this.getLevel(l)).getSize();
        }
        return size;
    }

    public final MultidimensionalTableView getTableView() {
        return ((Axis)this.getAxis()).getTableView();
    }

    void setPosition(int newValue) {
        this.m_position = newValue;
    }
}

