/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mdtable;

import com.sas.collection.StaticPropertyBagInterface;
import com.sas.mdtable.AbstractAxis;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.Dimension;
import com.sas.mdtable.DimensionInterface;
import com.sas.mdtable.Label;
import com.sas.mdtable.Level;
import com.sas.mdtable.LevelLabel;
import com.sas.mdtable.MultidimensionalTableView;
import com.sas.mdtable.Node;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.table.CellVector;
import com.sas.table.CellVectorStyle;
import com.sas.table.Column;
import com.sas.table.DataCell;
import com.sas.table.LabelCell;
import com.sas.table.TableException;
import com.sas.table.TableView;
import com.sas.util.PreorderTreeIterator;
import java.awt.Graphics;
import java.util.Vector;

final class Axis
extends AbstractAxis {
    private MultidimensionalTableView m_tableView;
    Node node;
    private Dimension[] dimensions;
    private int m_position;
    Vector m_labelCache;
    Column m_rowLabelsColumn;
    private PreorderTreeIterator m_treeIterator;

    public Axis(MultidimensionalTableView tableView, AxisInterface axis) {
        this.m_tableView = tableView;
        this.node = new Node(axis);
        this.m_labelCache = new Vector(32, 8);
        this.refresh();
    }

    public final MultidimensionalTableView getTableView() {
        return this.m_tableView;
    }

    public final AxisInterface getMetaAxis() {
        return (AxisInterface)this.node.getMetaNode();
    }

    @Override
    public String getLabel() {
        return this.node.getLabel();
    }

    @Override
    public String getName() {
        return this.node.getName();
    }

    @Override
    public int getDimensionCount() {
        return this.dimensions.length;
    }

    @Override
    public DimensionInterface getDimension(int index) {
        return this.dimensions[index];
    }

    Dimension getDimension(DimensionInterface dimI) {
        int maxi = this.getDimensionCount();
        for (int i = 0; i < maxi; ++i) {
            if (!dimI.equals(this.getDimension(i).getMetaDimension())) continue;
            return (Dimension)this.getDimension(i);
        }
        throw new IllegalStateException();
    }

    @Override
    public DimensionInterface[] getDimensions(int index, int count) {
        try {
            return super.getDimensions(index, count);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            return new Dimension[0];
        }
    }

    public int countNodeChildren(int maxChildCount) {
        return this.getDimensionCount();
    }

    @Override
    public int getMagnitude() {
        try {
            return this.getMetaAxis().getMagnitude();
        }
        catch (TableException ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public AxisLabelInterface[] getLabels(int axisCoordinate) {
        AxisLabelInterface[] axisLabels;
        try {
            axisLabels = this.getMetaAxis().getLabels(axisCoordinate);
        }
        catch (TableException ex) {
            ex.printStackTrace();
            axisLabels = new AxisLabelInterface[]{};
        }
        return this.createLabels(axisLabels, this.getCellVector(axisCoordinate));
    }

    private Label[] createLabels(AxisLabelInterface[] axisLabels, CellVector cellVector) {
        Label[] labels;
        int layout;
        if (this.isRowAxis()) {
            layout = this.m_tableView.getRowLabelsLayout();
            if (layout == 3) {
                Label[] labels2 = new Label[]{new Label(this.m_tableView, cellVector, null, axisLabels[axisLabels.length - 1], axisLabels[axisLabels.length - 1].getMember())};
                this.m_labelCache.addElement(labels2[0]);
                return labels2;
            }
        } else {
            layout = 0;
        }
        if ((labels = new Label[axisLabels.length]).length == 0) {
            return labels;
        }
        PreorderTreeIterator treeIterator = this.getTreeIterator();
        int maxi = labels.length - 1;
        Label parentLabel = null;
        Vector labelCache = this.m_labelCache;
        for (int i = 0; i <= maxi; ++i) {
            Label label = layout == 2 ? null : this.findLabel(labelCache, axisLabels[i]);
            if (label == null) {
                CellVector cv;
                if (i == maxi) {
                    cv = cellVector;
                } else if (treeIterator == null) {
                    cv = null;
                } else {
                    treeIterator.setNode((SimpleNodeInterface)axisLabels[i]);
                    cv = this.getCellVector(treeIterator.getNodeIndex() - 1);
                }
                label = new Label(this.m_tableView, cv, parentLabel, axisLabels[i], axisLabels[i].getMember());
                if (parentLabel == null && (maxi > 0 || treeIterator != null)) {
                    this.m_labelCache.addElement(label);
                }
            }
            labels[i] = label;
            parentLabel = label;
            labelCache = label.m_children;
        }
        return labels;
    }

    public StaticPropertyBagInterface getDefaultCellStyle() {
        return this.node.getDefaultCellStyle();
    }

    public void setDefaultCellStyle(StaticPropertyBagInterface newValue) {
        this.node.setDefaultCellStyle(newValue);
    }

    public StaticPropertyBagInterface getDefaultLabelStyle() {
        return this.node.getDefaultLabelStyle();
    }

    public void setDefaultLabelStyle(StaticPropertyBagInterface newValue) {
        this.node.setDefaultLabelStyle(newValue);
    }

    public StaticPropertyBagInterface getModelDefaultCellStyle() {
        return this.node.getModelDefaultCellStyle();
    }

    public StaticPropertyBagInterface getModelDefaultLabelStyle() {
        return this.node.getModelDefaultLabelStyle();
    }

    public int getPosition() {
        return this.m_position;
    }

    public int computePreferredSize(Graphics g) {
        int levSize;
        block12: {
            int width;
            block13: {
                int layout = this.m_tableView.getRowLabelsLayout();
                if (!this.isRowAxis()) break block12;
                if (layout == 1) break block13;
                if (layout != 3) break block12;
            }
            if (this.m_rowLabelsColumn == null) {
                this.m_rowLabelsColumn = new RowLabelsColumn(this.m_tableView);
            }
            if ((width = this.m_rowLabelsColumn.getSize()) == 0) {
                width = this.m_rowLabelsColumn.computePreferredSize(g);
                int levWidth = this.getColumnLevelLabelsWidth(g);
                if (levWidth > width) {
                    width = levWidth;
                }
                this.m_rowLabelsColumn.setPreferredSize(width);
                width = this.m_rowLabelsColumn.getSize();
                if (width == 0) {
                    width = 1;
                }
            }
            return width;
        }
        int size = 0;
        int maxd = this.getDimensionCount();
        for (int d = 0; d < maxd; ++d) {
            Dimension dim = (Dimension)this.getDimension(d);
            dim.setPosition(size);
            size += dim.computePreferredSize(g);
        }
        if (this.isRowAxis() && (levSize = this.getColumnLevelLabelsWidth(g)) > size) {
            int offsetApplied;
            for (int offsetToApply = levSize - size; offsetToApply != 0; offsetToApply -= offsetApplied) {
                offsetApplied = 0;
                int maxd2 = this.getDimensionCount();
                for (int d = 0; d < maxd2; ++d) {
                    Dimension dim = (Dimension)this.getDimension(d);
                    int maxl = dim.getLevelCount();
                    for (int l = 0; l < maxl; ++l) {
                        Level lev = (Level)dim.getLevel(l);
                        int s = lev.getSize();
                        int offset = l == maxl - 1 && d == maxd2 - 1 ? offsetToApply - offsetApplied : (int)((double)offsetToApply * (double)s / (double)size);
                        lev.m_position += offsetApplied;
                        lev.setPreferredSize(s + offset);
                        offset = lev.getSize() - s;
                        offsetApplied += offset;
                    }
                }
                if (offsetApplied == 0) break;
                size += offsetApplied;
            }
        }
        return size;
    }

    private int getColumnLevelLabelsWidth(Graphics g) {
        Axis axis = this.m_tableView.getColumnAxis_();
        int levSize = 0;
        int maxd = axis.getDimensionCount();
        for (int d = 0; d < maxd; ++d) {
            Dimension dim = (Dimension)axis.getDimension(d);
            int maxl = dim.getLevelCount();
            for (int l = 0; l < maxl && (l != maxl - 1 || d != maxd - 1); ++l) {
                Level lev = (Level)dim.getLevel(l);
                int s = lev.getLabelCell().getPreferredWidth(g);
                if (s <= levSize) continue;
                levSize = s;
            }
        }
        return levSize;
    }

    public NodeInterface getRoot() {
        return this.getMetaAxis().getRoot();
    }

    public int getSize() {
        int size = 0;
        int dCount = this.getDimensionCount();
        for (int d = 0; d < dCount; ++d) {
            size += ((Dimension)this.getDimension(d)).getSize();
        }
        return size;
    }

    public void paintLevelLabels(Graphics g) {
        int maxd = this.getDimensionCount();
        for (int d = 0; d < maxd; ++d) {
            Dimension dim = (Dimension)this.getDimension(d);
            int maxl = dim.getLevelCount();
            for (int l = 0; l < maxl; ++l) {
                LevelLabel label = ((Level)dim.getLevel(l)).getLabelCell();
                if (!label.isDisplayed()) continue;
                label.paint(g);
            }
        }
    }

    public void refresh() {
        DimensionInterface[] dims;
        this.m_labelCache.removeAllElements();
        AxisInterface axis = this.getMetaAxis();
        try {
            dims = axis.getDimensions(0, axis.getDimensionCount());
        }
        catch (TableException ex) {
            dims = null;
            ex.printStackTrace();
        }
        this.dimensions = new Dimension[dims != null ? dims.length : 0];
        for (int i = 0; i < this.dimensions.length; ++i) {
            this.dimensions[i] = new Dimension(this, dims[i]);
        }
        this.m_treeIterator = null;
        this.m_rowLabelsColumn = null;
    }

    void setPosition(int newValue) {
        this.m_position = newValue;
    }

    private Label findLabel(Vector labels, AxisLabelInterface axisLabel) {
        int maxi = labels.size();
        for (int i = 0; i < maxi; ++i) {
            Label label = (Label)labels.elementAt(i);
            if (!label.getMetaLabel().equals(axisLabel)) continue;
            return label;
        }
        return null;
    }

    private CellVector getCellVector(int axisCoordinate) {
        if (this.isColumnAxis()) {
            return this.m_tableView.getColumn(axisCoordinate + 1);
        }
        return this.m_tableView.getRow(axisCoordinate + 1);
    }

    public boolean isColumnAxis() {
        return this == this.m_tableView.getColumnAxis_();
    }

    public boolean isRowAxis() {
        return this == this.m_tableView.getRowAxis_();
    }

    void copyLevelSizes(Axis axisClone, double scaleFactor) {
        int dCount = this.getDimensionCount();
        for (int d = 0; d < dCount; ++d) {
            Dimension dim = (Dimension)this.getDimension(d);
            int lCount = dim.getLevelCount();
            for (int l = 0; l < lCount; ++l) {
                Level level = (Level)dim.getLevel(l);
                if (!level.isResized()) continue;
                Level levelClone = (Level)((Dimension)axisClone.getDimension(d)).getLevel(l);
                levelClone.setSize((int)((double)level.getSize() * scaleFactor + 0.5));
            }
        }
        if (this.m_rowLabelsColumn != null && this.m_rowLabelsColumn.isResized()) {
            axisClone.m_rowLabelsColumn = new RowLabelsColumn(axisClone.getTableView());
            axisClone.m_rowLabelsColumn.setSize((int)((double)this.m_rowLabelsColumn.getSize() * scaleFactor + 0.5));
        }
    }

    Label createLabel(int axisCoordinate) {
        Label[] labels;
        PreorderTreeIterator treeIterator = this.getTreeIterator();
        if (treeIterator != null) {
            treeIterator.setNodeIndex(axisCoordinate + 1);
            SimpleNodeInterface[] parents = treeIterator.getNodeParents();
            AxisLabelInterface[] axisLabels = new AxisLabelInterface[parents.length];
            for (int i = 0; i < axisLabels.length - 1; ++i) {
                axisLabels[i] = (AxisLabelInterface)parents[i + 1];
            }
            axisLabels[i] = (AxisLabelInterface)treeIterator.getNode();
            labels = this.createLabels(axisLabels, this.getCellVector(axisCoordinate));
        } else {
            labels = (Label[])this.getLabels(axisCoordinate);
        }
        if (labels.length == 0) {
            return null;
        }
        return labels[labels.length - 1];
    }

    private PreorderTreeIterator getTreeIterator() {
        if (this.m_treeIterator == null && this.isRowAxis()) {
            if (this.m_tableView.getRowLabelsLayout() == 1) {
                this.m_treeIterator = new PreorderTreeIterator((TreeInterface)this);
            }
        }
        return this.m_treeIterator;
    }

    private final class RowLabelsColumn
    extends Column {
        protected RowLabelsColumn(TableView table) {
            super(table, 0);
        }

        @Override
        public LabelCell getLabel() {
            return this.tableView.getOriginCell();
        }

        @Override
        public DataCell getCell(int rowIndex) {
            throw new IllegalStateException();
        }

        protected CellVectorStyle onGetStyle() throws TableException {
            return null;
        }
    }
}

