/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mdtable;

import com.sas.mdtable.AbstractNode;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.AxisLabelInterface;
import com.sas.mdtable.MemberInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.table.TableException;

public abstract class AbstractAxisLabel
extends AbstractNode
implements AxisLabelInterface {
    private MemberInterface m_member;
    private AxisInterface m_axis;
    private int m_minCoord;
    private int m_maxCoord;

    public AbstractAxisLabel(MemberInterface member, int minCoord, int maxCoord) {
        if (member == null || this.m_minCoord > this.m_maxCoord || this.m_minCoord < 0 || this.m_maxCoord < 0) {
            throw new IllegalArgumentException();
        }
        this.m_minCoord = minCoord;
        this.m_maxCoord = maxCoord;
        this.m_member = member;
        this.m_axis = member.getLevel().getDimension().getAxis();
    }

    @Override
    public final AxisInterface getAxis() {
        return this.m_axis;
    }

    @Override
    public String getLabel() throws TableException {
        return this.getMember().getLabel();
    }

    @Override
    public final MemberInterface getMember() {
        return this.m_member;
    }

    @Override
    public int getMinimumCoordinate() {
        return this.m_minCoord;
    }

    @Override
    public int getMaximumCoordinate() {
        return this.m_maxCoord;
    }

    @Override
    public String getName() throws TableException {
        return this.getMember().getName();
    }

    public SimpleNodeInterface[] getNodeChildren(int index, int count) {
        int maxCount = this.getNodeChildCount();
        if (index + count > maxCount) {
            count = maxCount - index;
        }
        SimpleNodeInterface[] array = new SimpleNodeInterface[count];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getNodeChild(index + i);
        }
        return array;
    }

    public String getNodeType() {
        return "label";
    }
}

