/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mdtable;

import com.sas.mdtable.AbstractNode;
import com.sas.mdtable.AxisInterface;
import com.sas.mdtable.DimensionInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.table.TableException;
import java.util.NoSuchElementException;

public abstract class AbstractAxis
extends AbstractNode
implements AxisInterface {
    @Override
    public DimensionInterface[] getDimensions(int index, int count) throws TableException {
        int maxCount = this.getDimensionCount();
        if (index + count > maxCount) {
            count = maxCount - index;
        }
        DimensionInterface[] array = new DimensionInterface[count];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getDimension(index + i);
        }
        return array;
    }

    public final SimpleNodeInterface getNodeChild(int index) {
        try {
            return this.getDimension(index);
        }
        catch (TableException tex) {
            throw new NoSuchElementException();
        }
    }

    public final int getNodeChildCount() {
        try {
            return this.getDimensionCount();
        }
        catch (TableException tex) {
            return 0;
        }
    }

    public final SimpleNodeInterface[] getNodeChildren(int index, int count) {
        try {
            return this.getDimensions(index, count);
        }
        catch (TableException tex) {
            return new SimpleNodeInterface[0];
        }
    }

    public String getNodeType() {
        return "axis";
    }

    public final boolean isLeafNode() {
        return false;
    }
}

