/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail.commands;

import com.sas.lang.StringDataInterface;
import com.sas.util.transforms.IdentityTransform;
import com.sas.util.transforms.ToDataSourceTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.io.Serializable;
import javax.activation.DataSource;

public class TransformAttachment
implements StringDataInterface,
Serializable {
    static final long serialVersionUID = 8538579931464219125L;
    public String attachmentName;
    public TransformInterface attachmentTransform;
    public String contentType;
    public Object contentSource;
    protected String text;

    public TransformAttachment() {
    }

    public TransformAttachment(Object source, String type, String name) {
        this.contentSource = source;
        this.contentType = type;
        this.attachmentName = name;
    }

    public TransformAttachment(TransformInterface transform, Object source, String name) {
        this.attachmentTransform = transform;
        this.contentSource = source;
        this.attachmentName = name;
    }

    public DataSource transformToDataSource() throws TransformException {
        Object dataSource;
        TransformInterface transform = this.attachmentTransform;
        if (transform == null) {
            transform = IdentityTransform.identityTransform;
        }
        if (transform instanceof ToDataSourceTransform) {
            ((ToDataSourceTransform)transform).setName(this.attachmentName);
        }
        if ((dataSource = transform.transform(this.contentSource)) instanceof DataSource) {
            return (DataSource)dataSource;
        }
        return null;
    }

    public String getText() {
        if (this.text == null) {
            String transformName = "";
            if (this.attachmentTransform instanceof StringDataInterface) {
                transformName = ((StringDataInterface)this.attachmentTransform).getText();
            }
            String txt = this.attachmentName;
            if (transformName != null && transformName.length() > 0) {
                txt = txt + " " + transformName;
            }
            if (this.contentType != null && this.contentType.length() > 0) {
                txt = txt + " (" + this.contentType + ") ";
            }
            return txt;
        }
        return this.text;
    }

    public void setText(String txt) {
        this.text = txt;
    }

    public String toString() {
        return this.getText();
    }
}

