/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail.commands;

import com.sas.mail.ComposeMessageForm;
import com.sas.mail.commands.RB;
import com.sas.util.Command;
import java.io.Serializable;

public class ShowAttachmentListCommand
implements Command,
Serializable {
    public static final String RB_KEY = "ShowAttachmentListCommand.";
    protected String text;
    protected boolean showAttachmentList;
    protected ComposeMessageForm composeMsgForm;

    public ShowAttachmentListCommand(ComposeMessageForm msgForm, boolean show) {
        this.composeMsgForm = msgForm;
        this.showAttachmentList = show;
        this.text = show ? RB.getStringResource(RB_KEY, "showAttachmentList.txt") : RB.getStringResource(RB_KEY, "hideAttachmentList.txt");
    }

    public Object clone() throws CloneNotSupportedException {
        return new ShowAttachmentListCommand(this.composeMsgForm, this.showAttachmentList);
    }

    public boolean isExecutable() {
        return true;
    }

    public boolean isUndoable() {
        return false;
    }

    public void undo() {
    }

    public void execute(Object arg) {
        if (this.composeMsgForm != null) {
            this.composeMsgForm.setAttachmentListVisible(this.isAttachmentListVisible());
        }
    }

    public boolean isAttachmentListVisible() {
        return this.showAttachmentList;
    }

    public void setAttachmentListVisible(boolean vis) {
        this.showAttachmentList = vis;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String txt) {
        this.text = txt;
    }
}

