/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail.commands;

import com.sas.awt.util.Util;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.mail.Attachment;
import com.sas.mail.commands.RB;
import com.sas.text.Message;
import com.sas.util.Command;
import com.sas.visuals.MessageBox;
import java.awt.Component;
import java.awt.Frame;
import java.io.Serializable;

public class RemoveAttachmentCommand
implements Command,
Serializable {
    public static final String RB_KEY = "RemoveAttachmentCommand.";
    protected String text;
    protected boolean warningDisplayed = true;
    protected Component parentComponent;
    protected OrderedCollectionInterface attachmentList;

    public RemoveAttachmentCommand(Component parent, OrderedCollectionInterface list) {
        this.parentComponent = parent;
        this.attachmentList = list;
    }

    public Object clone() throws CloneNotSupportedException {
        return new RemoveAttachmentCommand(this.parentComponent, this.attachmentList);
    }

    public boolean isExecutable() {
        return true;
    }

    public boolean isUndoable() {
        return false;
    }

    public void undo() {
    }

    public boolean isWarningDisplayed() {
        return this.warningDisplayed;
    }

    public void setWarningDisplayed(boolean d) {
        this.warningDisplayed = d;
    }

    public OrderedCollectionInterface getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(OrderedCollectionInterface list) {
        this.attachmentList = list;
    }

    public void execute(Object arg) {
        OrderedCollectionInterface list;
        if (arg == null || !(arg instanceof Attachment)) {
            return;
        }
        Attachment mailAttachment = (Attachment)arg;
        boolean removeAttachment = true;
        if (this.isWarningDisplayed()) {
            Frame parent = Util.getParentFrame(this.parentComponent);
            if (parent == null) {
                parent = new Frame();
            }
            Message msg = new Message(RB.getResources(), "RemoveAttachmentCommand.removeAttachment.txt", (Object)mailAttachment.toString());
            String title = RB.getStringResource(RB_KEY, "removeAttachmentTitle.txt");
            MessageBox messageBox = new MessageBox(parent, title, true, msg.toString(), 6, 2, 4);
            messageBox.initialize();
            messageBox.pack();
            Util.centerOver(messageBox, this.parentComponent);
            messageBox.setVisible(true);
            if (messageBox.getSelectedButton() != 2) {
                removeAttachment = false;
            }
        }
        if ((list = this.getAttachmentList()) != null && removeAttachment) {
            list.remove((Object)mailAttachment);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String txt) {
        this.text = txt;
    }
}

