/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail.commands;

import com.sas.mail.ComposeMessageForm;
import com.sas.mail.HeaderOptionsFolder;
import com.sas.mail.ServerOptionsFolder;
import com.sas.mail.UserOptionsFolder;
import com.sas.mail.commands.RB;
import com.sas.util.Command;
import com.sas.visuals.OkCancelHelpDialog;
import com.sas.visuals.TabbedView;
import java.awt.Container;
import java.awt.Window;
import java.beans.Customizer;
import java.io.Serializable;

public class ConfigureCommand
implements Command,
Serializable {
    public static final String RB_KEY = "ConfigureCommand.";
    protected String text;
    protected Container parentContainer;
    protected ComposeMessageForm composeMsgForm;
    protected TabbedView configureForm;

    public ConfigureCommand(Container parent, ComposeMessageForm composeForm) {
        this.setText(RB.getStringResource(RB_KEY, "defaultText.txt"));
        this.composeMsgForm = composeForm;
        this.setContainer(parent);
    }

    public Object clone() throws CloneNotSupportedException {
        return new ConfigureCommand(this.parentContainer, this.composeMsgForm);
    }

    public boolean isExecutable() {
        return true;
    }

    public boolean isUndoable() {
        return false;
    }

    public void undo() {
    }

    public void execute(Object arg) {
        ComposeMessageForm composeForm = null;
        if (arg instanceof ComposeMessageForm) {
            composeForm = (ComposeMessageForm)arg;
        }
        if (composeForm == null && (composeForm = this.getComposeMessageForm()) == null) {
            return;
        }
        TabbedView configForm = this.getConfigureForm();
        for (int i = 0; i < this.configureForm.getTabCount(); ++i) {
            Container view = configForm.getView(i);
            if (!(view instanceof Customizer)) continue;
            ((Customizer)((Object)view)).setObject(composeForm);
        }
        Container parent = this.getContainer();
        if (parent != null) {
            if (parent instanceof Window) {
                ((Window)parent).pack();
            }
            parent.setVisible(true);
        }
    }

    public TabbedView getConfigureForm() {
        if (this.configureForm == null) {
            this.configureForm = new TabbedView();
            UserOptionsFolder userOptionsFolder = new UserOptionsFolder();
            ServerOptionsFolder serverOptionsFolder = new ServerOptionsFolder();
            HeaderOptionsFolder headerOptionsFolder = new HeaderOptionsFolder();
            this.configureForm.add(userOptionsFolder);
            this.configureForm.add(serverOptionsFolder);
            this.configureForm.add(headerOptionsFolder);
        }
        return this.configureForm;
    }

    public ComposeMessageForm getComposeMessageForm() {
        return this.composeMsgForm;
    }

    public void setComposeMessageForm(ComposeMessageForm composeForm) {
        this.composeMsgForm = composeForm;
    }

    public Container getContainer() {
        return this.parentContainer;
    }

    public void setContainer(Container viewerContainer) {
        if (viewerContainer != this.parentContainer && viewerContainer != null) {
            this.parentContainer = viewerContainer;
            if (this.parentContainer instanceof OkCancelHelpDialog) {
                ((OkCancelHelpDialog)this.parentContainer).getMainPanel().add(this.getConfigureForm());
            } else {
                this.parentContainer.add(this.getConfigureForm());
            }
            if (this.parentContainer instanceof Window) {
                ((Window)this.parentContainer).pack();
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String txt) {
        this.text = txt;
    }
}

