/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail.commands;

import com.sas.awt.util.Util;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.mail.Attachment;
import com.sas.mail.commands.RB;
import com.sas.text.Message;
import com.sas.util.Command;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsErrorHandlerInterface;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.Serializable;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;

public class AddAttachmentCommand
implements Command,
SupportsErrorHandlerInterface,
Serializable {
    public static final String RB_KEY = "AddAttachmentCommand.";
    protected String text;
    protected OrderedCollectionInterface attachmentList;
    protected Component parentComponent;
    ErrorHandlerInterface errorHandler;

    public AddAttachmentCommand(Component parent, OrderedCollectionInterface list) {
        this.parentComponent = parent;
        this.attachmentList = list;
        this.text = RB.getStringResource(RB_KEY, "defaultText.txt");
    }

    public Object clone() throws CloneNotSupportedException {
        return new AddAttachmentCommand(this.parentComponent, this.attachmentList);
    }

    public boolean isExecutable() {
        return true;
    }

    public boolean isUndoable() {
        return false;
    }

    public void undo() {
    }

    public void execute(Object arg) {
        Frame parentFrame = Util.getParentFrame(this.parentComponent);
        if (parentFrame == null) {
            parentFrame = new Frame();
        }
        String dialogTitle = RB.getStringResource(RB_KEY, "fileDialogTitle.txt");
        FileDialog fileDialog = new FileDialog(parentFrame, dialogTitle, 0);
        fileDialog.pack();
        Util.centerOver(fileDialog, this.parentComponent);
        fileDialog.show();
        String directory = fileDialog.getDirectory();
        String fileName = fileDialog.getFile();
        if (fileName == null) {
            return;
        }
        File file = new File(directory, fileName);
        Message fileError = null;
        try {
            if (!file.exists()) {
                fileError = new Message(RB.getResources(), "AddAttachmentCommand.fileError.txt", (Object)fileName);
            }
        }
        catch (SecurityException e) {
            fileError = new Message(RB.getResources(), "AddAttachmentCommand.securityError.txt", (Object)e.getMessage());
        }
        if (fileError != null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleError(null, fileError, null);
            }
            return;
        }
        FileDataSource fileDS = new FileDataSource(file);
        DataHandler dh = new DataHandler((DataSource)fileDS);
        Attachment fileAttachment = new Attachment(dh, null);
        this.attachmentList.add((Object)fileAttachment);
    }

    public ErrorHandlerInterface getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandlerInterface errHandler) {
        this.errorHandler = errHandler;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String txt) {
        this.text = txt;
    }
}

