/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail;

import com.sas.ModelInterface;
import com.sas.awt.CheckBox;
import com.sas.awt.Container;
import com.sas.awt.Panel;
import com.sas.awt.TextField;
import com.sas.awt.util.Util;
import com.sas.lang.StringData;
import com.sas.lang.StringDataInterface;
import com.sas.mail.RB;
import com.sas.util.validators.ValidationInterface;
import com.sas.util.validators.Validator;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.ButtonPanel;
import com.sas.visuals.LabelView;
import com.sas.visuals.OkCancelHelpDialog;
import com.sas.visuals.PushButton;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;

public class UserInfoAuthenticator
extends Authenticator
implements PropertyChangeListener {
    public static final String RB_KEY = "UserInfoAuthenticator.";
    private Frame parentFrame;
    private StringDataInterface userName;
    private StringDataInterface password;
    private CheckBox saveInfo;
    private OkCancelHelpDialog dialog;

    public UserInfoAuthenticator() {
        this.parentFrame = new Frame();
    }

    public UserInfoAuthenticator(Frame parent) {
        this.parentFrame = parent;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.dialog == null) {
            this.createDialog();
        }
        this.dialog.pack();
        Util.center(this.dialog);
        this.dialog.setVisible(true);
        PasswordAuthentication userAuthentication = new PasswordAuthentication(this.password.getText(), this.userName.getText());
        if (!this.saveInfo.isSelected()) {
            this.userName.setText("");
            this.password.setText("");
        }
        return userAuthentication;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        PushButton closeBtn;
        Object eSource = event.getSource();
        String propName = event.getPropertyName();
        if ((eSource == this.userName || eSource == this.password) && propName != null && propName.equals("text") && (closeBtn = this.dialog.getButtonPanel().getButtonFromActionCommand(OkCancelHelpDialog.CLOSE)) != null) {
            if (this.password.getText() == null || this.userName.getText() == null || this.password.getText().length() == 0 || this.userName.getText().length() == 0) {
                closeBtn.setEnabled(false);
            } else {
                closeBtn.setEnabled(true);
            }
        }
    }

    protected void createDialog() {
        this.dialog = new OkCancelHelpDialog(this.parentFrame, RB.getStringResource(RB_KEY, "dialogTitle.txt"));
        this.dialog.setModal(true);
        ButtonPanel btnPanel = this.dialog.getButtonPanel();
        PushButton closeBtn = btnPanel.getButtonFromActionCommand(OkCancelHelpDialog.CLOSE);
        PushButton cancelBtn = btnPanel.getButtonFromActionCommand(OkCancelHelpDialog.CANCEL);
        PushButton helpBtn = btnPanel.getButtonFromActionCommand(OkCancelHelpDialog.HELP);
        btnPanel.removeButton(cancelBtn);
        btnPanel.removeButton(helpBtn);
        closeBtn.setEnabled(false);
        this.dialog.setValidator((ValidationInterface)new UserValidator());
        LabelView userLabel = new LabelView();
        LabelView passwordLabel = new LabelView();
        TextField passwordField = new TextField(20);
        TextField userField = new TextField(20);
        this.userName = new StringData();
        this.password = new StringData();
        ((StringData)this.userName).addPropertyChangeListener((PropertyChangeListener)this);
        ((StringData)this.password).addPropertyChangeListener((PropertyChangeListener)this);
        userLabel.setText(RB.getStringResource(RB_KEY, "userLabel.txt"));
        passwordLabel.setText(RB.getStringResource(RB_KEY, "passwordLabel.txt"));
        userField.setModelInterface((ModelInterface)this.userName);
        passwordField.setEchoChar('*');
        passwordField.setModelInterface((ModelInterface)this.password);
        Container userInfoContainer = new Container();
        userInfoContainer.setLayout((LayoutManager)new AutoSizingGridLayout(2, 2, 5, 5, true, false, true));
        userInfoContainer.add(userLabel);
        userInfoContainer.add(userField);
        userInfoContainer.add(passwordLabel);
        userInfoContainer.add(passwordField);
        this.saveInfo = new CheckBox();
        this.saveInfo.setState(true);
        this.saveInfo.setText(RB.getStringResource(RB_KEY, "saveInfo.txt"));
        Panel mainPanel = this.dialog.getMainPanel();
        mainPanel.setLayout((LayoutManager)new AutoSizingGridLayout(2, 1, 5, 5, true, true, true));
        mainPanel.add(userInfoContainer);
        mainPanel.add(this.saveInfo);
        mainPanel.setInsets(new Insets(7, 7, 7, 7));
        BaseBorder border = (BaseBorder)mainPanel.getBorder();
        border.setStyle(3);
        border.setSidesPainted(8);
        border.setLightSource(10);
    }

    class UserValidator
    extends Validator {
        UserValidator() {
        }

        public boolean validateValue(Object obj1, Object obj2) {
            return UserInfoAuthenticator.this.password.getText() != null && UserInfoAuthenticator.this.userName.getText() != null && UserInfoAuthenticator.this.password.getText().length() != 0 && UserInfoAuthenticator.this.userName.getText().length() != 0;
        }
    }
}

