/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail;

import com.sas.Component;
import com.sas.ComponentInterface;
import com.sas.mail.AddressFactoryInterface;
import com.sas.mail.InternetAddressFactory;
import com.sas.mail.MessageFactoryInterface;
import com.sas.mail.RB;
import com.sas.text.Message;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.SupportsErrorHandlerInterface;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MimeMessageFactory
extends Component
implements MessageFactoryInterface,
SupportsErrorHandlerInterface {
    static final long serialVersionUID = 2027575145906238737L;
    public static final String RB_KEY = "MimeMessageFactory.";
    private AddressFactoryInterface addressFactory;
    protected ErrorHandlerInterface errorHandler;
    protected Session session;
    protected Properties properties;
    protected Authenticator authenticator;
    public static final String ORGANIZATION = "mail.header.organization";
    public static final String PERSONAL_NAME = "mail.header.personalName";
    public static final String REPLY_TO = "mail.header.replyTo";
    public static final String FROM = "mail.header.from";
    public static final String AUTHENTICATOR_REQUIRED = "mail.authenticator.required";

    public void setDefaultValues() {
        super.setDefaultValues();
        this.addressFactory = new InternetAddressFactory();
        this.properties = new Properties();
    }

    public ErrorHandlerInterface getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandlerInterface errHandler) {
        if (errHandler != this.errorHandler) {
            ErrorHandlerInterface oldErrorHandler = this.errorHandler;
            this.errorHandler = errHandler;
            this.firePropertyChange("errorHandler", oldErrorHandler, this.errorHandler);
        }
    }

    @Override
    public javax.mail.Message newMessage(Session mailSession) {
        MimeMessage msg;
        block6: {
            Session currentSession = mailSession;
            if (currentSession == null) {
                currentSession = this.getSession();
            }
            if (currentSession == null) {
                Properties currentProperties = this.getSessionProperties();
                Authenticator currentAuthenticator = this.getAuthenticator();
                currentSession = currentAuthenticator == null ? Session.getDefaultInstance((Properties)currentProperties, (Authenticator)currentAuthenticator) : Session.getInstance((Properties)currentProperties, (Authenticator)currentAuthenticator);
            }
            msg = null;
            if (currentSession != null) {
                msg = new MimeMessage(currentSession);
            }
            try {
                if (msg != null) {
                    this.readDefaultHeaders((javax.mail.Message)msg);
                }
            }
            catch (MessagingException e) {
                ErrorHandlerInterface errHandler = this.getErrorHandler();
                if (errHandler == null) break block6;
                Message errMsg = new Message(RB.getResources(), RB_KEY, (Object)"messagingException.ex.txt", (Object)e);
                errHandler.handleError((ComponentInterface)this, errMsg, null);
            }
        }
        return msg;
    }

    protected void readDefaultHeaders(javax.mail.Message msg) throws MessagingException {
        InternetAddress[] fromAddressArray;
        InternetAddress[] replyToAddressArray;
        block17: {
            ErrorHandlerInterface errHandler;
            Message errMsg;
            String replyToAddress;
            String personalName;
            block16: {
                String fromAddress;
                block15: {
                    if (this.properties == null) {
                        return;
                    }
                    String organization = this.properties.getProperty(ORGANIZATION);
                    personalName = this.properties.getProperty(PERSONAL_NAME);
                    replyToAddress = this.properties.getProperty(REPLY_TO);
                    fromAddress = this.properties.getProperty(FROM);
                    if (organization != null) {
                        msg.setHeader(RB.getStringResource("MimeMessageFactory.organization.txt"), organization);
                    }
                    replyToAddressArray = null;
                    fromAddressArray = null;
                    try {
                        if (replyToAddress != null) {
                            replyToAddressArray = (InternetAddress[])this.newAddresses(replyToAddress);
                        }
                    }
                    catch (ParseException e) {
                        errMsg = new Message(RB.getResources(), "HeaderForm.addressFieldParseError.txt", (Object)replyToAddress);
                        errHandler = this.getErrorHandler();
                        if (errHandler == null) break block15;
                        errHandler.handleError((ComponentInterface)this, errMsg, null);
                    }
                }
                try {
                    if (fromAddress != null) {
                        fromAddressArray = (InternetAddress[])this.newAddresses(fromAddress);
                    }
                }
                catch (ParseException e) {
                    errMsg = new Message(RB.getResources(), "HeaderForm.addressFieldParseError.txt", (Object)replyToAddress);
                    errHandler = this.getErrorHandler();
                    if (errHandler == null) break block16;
                    errHandler.handleError((ComponentInterface)this, errMsg, null);
                }
            }
            if (personalName != null && personalName.length() > 0) {
                try {
                    int i;
                    for (i = 0; replyToAddressArray != null && i < replyToAddressArray.length; ++i) {
                        replyToAddressArray[i].setPersonal(personalName);
                    }
                    for (i = 0; fromAddressArray != null && i < fromAddressArray.length; ++i) {
                        fromAddressArray[i].setPersonal(personalName);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    errMsg = new Message(RB.getResources(), "MimeMessageFactory.personalNameError.txt", (Object)replyToAddress);
                    errHandler = this.getErrorHandler();
                    if (errHandler == null) break block17;
                    errHandler.handleError((ComponentInterface)this, errMsg, null);
                }
            }
        }
        if (replyToAddressArray != null) {
            msg.setReplyTo((Address[])replyToAddressArray);
        }
        if (fromAddressArray != null) {
            msg.setFrom((Address)fromAddressArray[0]);
        }
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void setSession(Session mailSession) {
        if (this.session != mailSession) {
            Session oldSession = this.session;
            this.session = mailSession;
            this.firePropertyChange("session", oldSession, this.session);
        }
    }

    @Override
    public Properties getSessionProperties() {
        return this.properties;
    }

    @Override
    public void setSessionProperties(Properties props) {
        if (props != this.properties) {
            Properties oldProps = this.properties;
            this.properties = props;
            this.firePropertyChange("sessionProperties", oldProps, props);
        }
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public void setAuthenticator(Authenticator newAuthenticator) {
        if (this.authenticator != newAuthenticator) {
            Authenticator oldAuthenticator = this.authenticator;
            this.authenticator = newAuthenticator;
            this.firePropertyChange("authenticator", oldAuthenticator, this.authenticator);
        }
    }

    @Override
    public Address[] newAddresses(String addressList) throws ParseException {
        return this.addressFactory.newAddresses(addressList);
    }

    @Override
    public String toString(Address[] addresses) {
        return this.addressFactory.toString(addresses);
    }

    @Override
    public BodyPart newBodyPart() {
        return new MimeBodyPart();
    }

    @Override
    public Multipart newMultipart() {
        return new MimeMultipart();
    }
}

