/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail;

import com.sas.awt.CheckBox;
import com.sas.mail.ComposeMessageForm;
import com.sas.mail.HeaderFields;
import com.sas.mail.HeaderFormInterface;
import com.sas.mail.RB;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.TabFolder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;

public class HeaderOptionsFolder
extends TabFolder
implements ItemListener,
Customizer {
    public static final String RB_KEY = "HeaderOptionsFolder.";
    static final long serialVersionUID = 5821250802264165475L;
    protected CheckBox showFromField;
    protected CheckBox showBccField;
    protected CheckBox showCcField;
    protected CheckBox showReplyToField;
    protected CheckBox showToField;
    protected HeaderFormInterface headerForm;

    public HeaderOptionsFolder() {
    }

    public HeaderOptionsFolder(String tabText) {
        super(tabText);
    }

    public HeaderOptionsFolder(HeaderFormInterface header) {
        this.setHeaderForm(header);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object eSource = event.getSource();
        if (eSource == this.showFromField) {
            this.headerForm.setHeaderFieldVisible(HeaderFields.FROM, this.showFromField.isSelected());
        } else if (eSource == this.showBccField) {
            this.headerForm.setHeaderFieldVisible(HeaderFields.BCC, this.showBccField.isSelected());
        } else if (eSource == this.showCcField) {
            this.headerForm.setHeaderFieldVisible(HeaderFields.CC, this.showCcField.isSelected());
        } else if (eSource == this.showReplyToField) {
            this.headerForm.setHeaderFieldVisible(HeaderFields.REPLY_TO, this.showReplyToField.isSelected());
        } else if (eSource == this.showToField) {
            this.headerForm.setHeaderFieldVisible(HeaderFields.TO, this.showToField.isSelected());
        }
        Window windowParent = this.findWindowParent(((Component)((Object)this.headerForm)).getParent());
        if (windowParent != null) {
            windowParent.pack();
        }
        ((Component)((Object)this.headerForm)).repaint();
    }

    private Window findWindowParent(Component component) {
        Container parent = component.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof Window) {
            return (Window)parent;
        }
        return this.findWindowParent(parent);
    }

    public void layoutComponents() {
        this.setLayout((LayoutManager)new AutoSizingGridLayout(0, 1, 0, 3, true, false, false));
        this.setInsets(new Insets(5, 5, 5, 5));
        this.add(this.showFromField);
        this.add(this.showToField);
        this.add(this.showCcField);
        this.add(this.showBccField);
        this.add(this.showReplyToField);
    }

    protected void createComponents() {
        this.showFromField = new CheckBox(RB.getStringResource(RB_KEY, "fromOptionCheckBox.txt"));
        this.showBccField = new CheckBox(RB.getStringResource(RB_KEY, "bccOptionCheckBox.txt"));
        this.showCcField = new CheckBox(RB.getStringResource(RB_KEY, "ccOptionCheckBox.txt"));
        this.showReplyToField = new CheckBox(RB.getStringResource(RB_KEY, "replyToOptionCheckBox.txt"));
        this.showToField = new CheckBox(RB.getStringResource(RB_KEY, "toOptionCheckBox.txt"));
        this.showFromField.addItemListener(this);
        this.showBccField.addItemListener(this);
        this.showCcField.addItemListener(this);
        this.showReplyToField.addItemListener(this);
        this.showToField.addItemListener(this);
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.createComponents();
        this.layoutComponents();
        this.setText(RB.getStringResource("HeaderOptionsFolder.tabText.txt"));
    }

    public HeaderFormInterface getHeaderForm() {
        return this.headerForm;
    }

    public void initHeaderFormOptions() {
        if (this.headerForm == null) {
            return;
        }
        this.showFromField.setSelected(this.headerForm.isHeaderFieldVisible(HeaderFields.FROM));
        this.showCcField.setSelected(this.headerForm.isHeaderFieldVisible(HeaderFields.CC));
        this.showBccField.setSelected(this.headerForm.isHeaderFieldVisible(HeaderFields.BCC));
        this.showReplyToField.setSelected(this.headerForm.isHeaderFieldVisible(HeaderFields.REPLY_TO));
        this.showToField.setSelected(this.headerForm.isHeaderFieldVisible(HeaderFields.TO));
    }

    public void setHeaderForm(HeaderFormInterface header) {
        if (header != this.headerForm) {
            HeaderFormInterface oldHeaderForm = this.headerForm;
            this.headerForm = header;
            this.initHeaderFormOptions();
            this.firePropertyChange("headerForm", oldHeaderForm, this.headerForm);
        }
    }

    @Override
    public void setObject(Object bean) {
        if (bean == null) {
            return;
        }
        if (bean instanceof HeaderFormInterface) {
            this.setHeaderForm((HeaderFormInterface)bean);
        } else if (bean instanceof ComposeMessageForm) {
            this.setHeaderForm(((ComposeMessageForm)bean).getHeaderForm());
        }
    }
}

