/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.ViewInterface;
import com.sas.awt.Container;
import com.sas.awt.Dialog;
import com.sas.awt.ListBox;
import com.sas.awt.Panel;
import com.sas.awt.TextArea;
import com.sas.awt.util.Util;
import com.sas.collection.AssociationList;
import com.sas.collection.AssociationListInterface;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.lang.StringDataInterface;
import com.sas.mail.Attachment;
import com.sas.mail.HeaderFields;
import com.sas.mail.HeaderForm;
import com.sas.mail.HeaderFormInterface;
import com.sas.mail.MessageDataInterface;
import com.sas.mail.MessageFactoryInterface;
import com.sas.mail.MimeMessageFactory;
import com.sas.mail.PopupTrigger;
import com.sas.mail.RB;
import com.sas.mail.ServerOptionsFolder;
import com.sas.mail.UserInfoAuthenticator;
import com.sas.mail.commands.AddAttachmentCommand;
import com.sas.mail.commands.ConfigureCommand;
import com.sas.mail.commands.EditAttachmentCommand;
import com.sas.mail.commands.RemoveAttachmentCommand;
import com.sas.mail.commands.SendMessageCommand;
import com.sas.mail.commands.ShowAttachmentListCommand;
import com.sas.mail.commands.ViewAttachmentCommand;
import com.sas.util.Command;
import com.sas.util.CommandManager;
import com.sas.util.ContextCommandsConsumerInterface;
import com.sas.util.ContextCommandsInterface;
import com.sas.util.MenuSeparatorCommand;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.MessageBoxErrorHandler;
import com.sas.util.errorhandlers.SupportsErrorHandlerInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.ButtonPanel;
import com.sas.visuals.OkCancelHelpDialog;
import com.sas.visuals.PushButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.PopupMenu;
import java.awt.TextComponent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;

public class ComposeMessageForm
extends Container
implements MessageDataInterface,
StringDataInterface,
ContextCommandsConsumerInterface,
ContextCommandsInterface {
    static final long serialVersionUID = -7096868272342604886L;
    protected boolean editable;
    protected HeaderFormInterface headerForm;
    protected StringDataInterface textContent;
    protected ViewInterface attachmentListViewer;
    protected java.awt.Container attachmentViewerContainer;
    protected Message message;
    protected MessageFactoryInterface messageFactory;
    protected OrderedCollectionInterface attachmentList;
    protected ModelInterface defaultModel;
    protected PopupMenu headerMenu;
    protected PopupTrigger headerPopupListener;
    protected PopupMenu attachmentMenu;
    protected PopupTrigger attachmentPopupListener;
    public static final String CONFIGURE_OPTIONS = "CONFIGURE_OPTIONS";
    public static final String SHOW_ATTACHMENT_LIST = "SHOW_ATTACHMENT_LIST";
    public static final String HIDE_ATTACHMENT_LIST = "HIDE_ATTACHMENT_LIST";
    public static final String SEND_MESSAGE = "SEND_MESSAGE";
    public static final String ADD_ATTACHMENT = "ADD_ATTACHMENT";
    public static final String REMOVE_ATTACHMENT = "REMOVE_ATTACHMENT";
    public static final String EDIT_ATTACHMENT = "EDIT_ATTACHMENT";
    public static final String VIEW_ATTACHMENT = "VIEW_ATTACHMENT";
    public static final String SEPARATOR = "SEPARATOR";
    protected transient AssociationListInterface commandList;
    protected transient CommandManager commandManager;
    private static String[] requiredInterfacesString = new String[]{"com.sas.mail.MessageFactoryInterface"};

    public AssociationListInterface getCommandList() {
        if (this.commandList == null) {
            this.commandList = this.newCommandList();
        }
        return this.commandList;
    }

    private CommandManager getCommandManager() {
        if (this.commandManager == null) {
            this.commandManager = new CommandManager();
        }
        return this.commandManager;
    }

    public Command[] getContextCommands(Object context, int x, int y) {
        AssociationListInterface cmdList = this.getCommandList();
        if (context == this.headerForm && cmdList != null) {
            Command[] cmds = new Command[]{(Command)cmdList.get((Object)SEND_MESSAGE), (Command)cmdList.get((Object)SEPARATOR), (Command)cmdList.get((Object)CONFIGURE_OPTIONS), (Command)cmdList.get((Object)SEPARATOR), this.isAttachmentListVisible() ? (Command)cmdList.get((Object)HIDE_ATTACHMENT_LIST) : (Command)cmdList.get((Object)SHOW_ATTACHMENT_LIST)};
            return cmds;
        }
        if (context == this.attachmentList && cmdList != null) {
            Attachment subContext = this.getCurrentSelectedAttachment();
            Command[] cmds = null;
            if (subContext == null) {
                cmds = new Command[]{(Command)cmdList.get((Object)ADD_ATTACHMENT), (Command)cmdList.get((Object)SEPARATOR), (Command)cmdList.get((Object)HIDE_ATTACHMENT_LIST)};
                return cmds;
            }
            if (subContext instanceof Attachment) {
                Attachment attachment = subContext;
                java.awt.Container attachmentContainer = this.getAttachmentContainer();
                if (attachmentContainer.isVisible()) {
                    cmds = new Command[]{(Command)cmdList.get((Object)ADD_ATTACHMENT), (Command)cmdList.get((Object)REMOVE_ATTACHMENT), (Command)cmdList.get((Object)SEPARATOR), (Command)cmdList.get((Object)HIDE_ATTACHMENT_LIST)};
                    com.sas.text.Message msg = new com.sas.text.Message(RB.getResources(), "ComposeMessageForm.removeAttachment.txt", (Object)attachment.toString());
                    cmds[1].setText(msg.toString());
                    return cmds;
                }
                Component editor = attachment.getEditor();
                Component viewer = attachment.getViewer();
                int cmdCount = 6;
                if (editor == null) {
                    --cmdCount;
                }
                if (viewer == null) {
                    --cmdCount;
                }
                int index = 0;
                cmds = new Command[cmdCount];
                cmds[index++] = (Command)cmdList.get((Object)ADD_ATTACHMENT);
                Command editCmd = (Command)cmdList.get((Object)EDIT_ATTACHMENT);
                Command viewCmd = (Command)cmdList.get((Object)VIEW_ATTACHMENT);
                if (editor != null) {
                    cmds[index++] = editCmd;
                }
                if (viewer != null) {
                    cmds[index++] = viewCmd;
                }
                Command removeCmd = (Command)cmdList.get((Object)REMOVE_ATTACHMENT);
                cmds[index++] = removeCmd;
                cmds[index++] = (Command)cmdList.get((Object)SEPARATOR);
                cmds[index++] = (Command)cmdList.get((Object)HIDE_ATTACHMENT_LIST);
                com.sas.text.Message editMsg = new com.sas.text.Message(RB.getResources(), "ComposeMessageForm.editAttachment.txt", (Object)attachment.toString());
                com.sas.text.Message viewMsg = new com.sas.text.Message(RB.getResources(), "ComposeMessageForm.viewAttachment.txt", (Object)attachment.toString());
                com.sas.text.Message removeMsg = new com.sas.text.Message(RB.getResources(), "ComposeMessageForm.removeAttachment.txt", (Object)attachment.toString());
                editCmd.setText(editMsg.toString());
                viewCmd.setText(viewMsg.toString());
                if (editCmd instanceof EditAttachmentCommand) {
                    ((EditAttachmentCommand)editCmd).setContainer(attachmentContainer);
                }
                if (viewCmd instanceof ViewAttachmentCommand) {
                    ((ViewAttachmentCommand)viewCmd).setContainer(attachmentContainer);
                }
                removeCmd.setText(removeMsg.toString());
                return cmds;
            }
        }
        this.getCommandManager();
        return CommandManager.getEmptyCommandArray();
    }

    public ContextCommandsInterface[] getContextCommandsProducers() {
        return this.getCommandManager().getContextCommandsProducers();
    }

    public void addContextCommandsProducer(ContextCommandsInterface producer) {
        this.getCommandManager().addContextCommandsProducer(producer);
    }

    public void removeContextCommandsProducer(ContextCommandsInterface producer) {
        this.getCommandManager().removeContextCommandsProducer(producer);
    }

    public java.awt.Container getAttachmentContainer() {
        if (this.attachmentViewerContainer == null) {
            Frame parentFrame = Util.getParentFrame(this);
            if (parentFrame == null) {
                parentFrame = new Frame();
            }
            this.attachmentViewerContainer = new Dialog(parentFrame);
            ((Dialog)this.attachmentViewerContainer).setModal(true);
            Util.centerOver((Dialog)this.attachmentViewerContainer, this);
        }
        return this.attachmentViewerContainer;
    }

    public void setAttachmentContainer(java.awt.Container viewerContainer) {
        if (this.attachmentViewerContainer != viewerContainer) {
            java.awt.Container oldContainer = this.attachmentViewerContainer;
            this.attachmentViewerContainer = viewerContainer;
            this.firePropertyChange("attachmentContainer", oldContainer, this.attachmentViewerContainer);
        }
    }

    protected HeaderFormInterface newHeaderForm() {
        return new HeaderForm();
    }

    protected StringDataInterface newTextContent() {
        TextArea textArea = new TextArea(24, 80);
        return textArea;
    }

    protected ViewInterface newAttachmentListViewer() {
        ListBox listBox = new ListBox(3);
        listBox.setVisible(false);
        return listBox;
    }

    protected OrderedCollectionInterface newAttachmentList() {
        OrderedCollection orderedCollection = new OrderedCollection();
        orderedCollection.initialize();
        return orderedCollection;
    }

    protected AssociationListInterface newCommandList() {
        Frame parentFrame = Util.getParentFrame(this);
        if (parentFrame == null) {
            parentFrame = new Frame();
        }
        String configuration = RB.getStringResource("ComposeMessageForm.configureMailForm.dialogTitle.txt");
        OkCancelHelpDialog configurationDialog = new OkCancelHelpDialog(parentFrame, configuration);
        configurationDialog.setModal(true);
        configurationDialog.setResizable(false);
        ButtonPanel btnPanel = configurationDialog.getButtonPanel();
        AutoSizingGridLayout asgl = new AutoSizingGridLayout(1, 2, 0, 0);
        btnPanel.setLayout((LayoutManager)asgl);
        asgl.setIgnoreSizeOfNonVisibleComponents(true);
        btnPanel.setInsets(new Insets(5, 5, 5, 5));
        PushButton closeBtn = btnPanel.getButtonFromActionCommand(OkCancelHelpDialog.CLOSE);
        PushButton cancelBtn = btnPanel.getButtonFromActionCommand(OkCancelHelpDialog.CANCEL);
        PushButton helpBtn = btnPanel.getButtonFromActionCommand(OkCancelHelpDialog.HELP);
        closeBtn.setPreferredSize(new Dimension(closeBtn.getDefaultWidth(), closeBtn.getDefaultHeight()));
        btnPanel.removeButton(helpBtn);
        btnPanel.removeButton(cancelBtn);
        btnPanel.remove(closeBtn);
        btnPanel.addButton(OkCancelHelpDialog.CANCEL, OkCancelHelpDialog.CANCEL);
        cancelBtn = btnPanel.getButtonFromActionCommand(OkCancelHelpDialog.CANCEL);
        btnPanel.add(closeBtn);
        cancelBtn.setVisible(false);
        configurationDialog.remove(btnPanel);
        Panel bottomPanel = new Panel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)btnPanel, "East");
        configurationDialog.add(bottomPanel);
        Util.centerOver(configurationDialog, this);
        Properties props = null;
        MessageFactoryInterface messageFactory = this.getMessageFactory();
        if (messageFactory != null) {
            props = messageFactory.getSessionProperties();
        }
        ConfigureCommand configUser = new ConfigureCommand(configurationDialog, this);
        MenuSeparatorCommand separatorCommand = MenuSeparatorCommand.instance();
        ShowAttachmentListCommand showAttachmentList = new ShowAttachmentListCommand(this, true);
        ShowAttachmentListCommand hideAttachmentList = new ShowAttachmentListCommand(this, false);
        SendMessageCommand sendMessage = new SendMessageCommand();
        AddAttachmentCommand addAttachment = new AddAttachmentCommand(this, this.attachmentList);
        EditAttachmentCommand editAttachment = new EditAttachmentCommand();
        ViewAttachmentCommand viewAttachment = new ViewAttachmentCommand();
        RemoveAttachmentCommand removeAttachment = new RemoveAttachmentCommand(this, this.attachmentList);
        AssociationList cmdList = new AssociationList();
        cmdList.set((Object)CONFIGURE_OPTIONS, (Object)configUser);
        cmdList.set((Object)SEPARATOR, (Object)separatorCommand);
        cmdList.set((Object)SHOW_ATTACHMENT_LIST, (Object)showAttachmentList);
        cmdList.set((Object)HIDE_ATTACHMENT_LIST, (Object)hideAttachmentList);
        cmdList.set((Object)SEND_MESSAGE, (Object)sendMessage);
        cmdList.set((Object)ADD_ATTACHMENT, (Object)addAttachment);
        cmdList.set((Object)EDIT_ATTACHMENT, (Object)editAttachment);
        cmdList.set((Object)VIEW_ATTACHMENT, (Object)viewAttachment);
        cmdList.set((Object)REMOVE_ATTACHMENT, (Object)removeAttachment);
        return cmdList;
    }

    protected void createComponents() {
        this.editable = true;
        this.attachmentList = this.newAttachmentList();
        this.headerForm = this.newHeaderForm();
        this.textContent = this.newTextContent();
        this.attachmentListViewer = this.newAttachmentListViewer();
        this.attachmentListViewer.setModelInterface((ModelInterface)this.attachmentList);
        this.attachmentMenu = new PopupMenu();
        this.add(this.attachmentMenu);
        this.attachmentPopupListener = new PopupTrigger(this.attachmentMenu, this);
        this.attachmentPopupListener.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        ((Component)this.attachmentListViewer).addMouseListener(this.attachmentPopupListener);
        this.headerMenu = new PopupMenu();
        this.add(this.headerMenu);
        this.headerPopupListener = new PopupTrigger(this.headerMenu, this);
        this.headerPopupListener.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        ((Component)((Object)this.headerForm)).addMouseListener(this.headerPopupListener);
        this.addContextCommandsProducer(this);
        this.defaultModel = new MimeMessageFactory();
        this.setModelInterface(this.defaultModel);
        MessageBoxErrorHandler mBoxErrorHandler = new MessageBoxErrorHandler(this);
        this.setErrorHandler(mBoxErrorHandler);
    }

    protected void layoutComponents() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 0, 3, true, true, true);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        layout.setRemainderRow(2);
        this.setLayout((LayoutManager)layout);
        this.add((Component)((Object)this.headerForm));
        this.add((Component)this.textContent);
        this.add((Component)this.attachmentListViewer);
    }

    @Override
    public void setErrorHandler(ErrorHandlerInterface errorHandler) {
        super.setErrorHandler(errorHandler);
        this.headerForm.setErrorHandler(errorHandler);
    }

    protected Attachment getCurrentSelectedAttachment() {
        Attachment currentAttachment = null;
        int index = ((ListBox)this.attachmentListViewer).getSelectedIndex();
        if (index != -1) {
            currentAttachment = (Attachment)this.attachmentList.get(index);
        }
        return currentAttachment;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propName = e.getPropertyName();
        Object eSource = e.getSource();
        if (eSource == this.attachmentPopupListener) {
            Attachment currentAttachment = this.getCurrentSelectedAttachment();
            Command[] cmds = this.getCommandManager().getContextCommands((Object)this.attachmentList, -1, -1);
            for (int i = 0; cmds != null && i < cmds.length; ++i) {
                if (!(cmds[i] instanceof SupportsErrorHandlerInterface)) continue;
                ((SupportsErrorHandlerInterface)cmds[i]).setErrorHandler(this.getErrorHandler());
            }
            this.attachmentMenu.removeAll();
            this.getCommandManager();
            CommandManager.addCommands((Menu)this.attachmentMenu, (Command[])cmds, (Object)currentAttachment);
        } else if (eSource == this.headerPopupListener) {
            Command[] cmds = this.getCommandManager().getContextCommands((Object)this.headerForm, -1, -1);
            for (int i = 0; cmds != null && i < cmds.length; ++i) {
                if (!(cmds[i] instanceof SupportsErrorHandlerInterface)) continue;
                ((SupportsErrorHandlerInterface)cmds[i]).setErrorHandler(this.getErrorHandler());
            }
            this.headerMenu.removeAll();
            this.getCommandManager();
            CommandManager.addCommands((Menu)this.headerMenu, (Command[])cmds, (Object)this);
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.createComponents();
        this.layoutComponents();
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public HeaderFormInterface getHeaderForm() {
        return this.headerForm;
    }

    public MessageFactoryInterface getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactoryInterface msgFactory) {
        if (this.messageFactory != msgFactory) {
            MessageFactoryInterface oldFactory = this.messageFactory;
            this.messageFactory = msgFactory;
            this.firePropertyChange("messageFactory", oldFactory, this.messageFactory);
        }
    }

    @Override
    public Message getMessage() throws MessagingException {
        if (this.message != null) {
            this.readHeaderForm(this.message);
            this.readContent(this.message);
        }
        return this.message;
    }

    @Override
    public void setMessage(Message msg) throws MessagingException {
        if (this.message != msg) {
            Message oldMessage = this.message;
            this.message = msg;
            this.messageChanged();
            this.firePropertyChange("message", oldMessage, this.message);
        }
    }

    @Override
    public void messageChanged() throws MessagingException {
        block3: {
            if (this.message == null) {
                return;
            }
            try {
                this.writeHeaderForm(this.message);
                this.writeContent(this.message);
            }
            catch (IOException ioe) {
                ErrorHandlerInterface errHandler = this.getErrorHandler();
                if (errHandler == null) break block3;
                com.sas.text.Message errMsg = new com.sas.text.Message(RB.getResources(), "ComposeMessageForm.messageChanged.IOException.ex.txt", (Object)ioe);
                errHandler.handleError((ComponentInterface)this, errMsg, "messageChanged");
            }
        }
    }

    public boolean sendMessage(boolean save) throws MessagingException {
        Message msg = this.getMessage();
        if (msg == null) {
            msg = this.buildMessage();
            if (save) {
                this.message = msg;
            }
        }
        if (msg != null) {
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            return true;
        }
        return false;
    }

    public void saveMessage() throws MessagingException {
        Message msg = this.getMessage();
        if (msg == null) {
            this.message = msg = this.buildMessage();
            this.firePropertyChange("message", null, this.message);
        }
    }

    public Message buildMessage() throws MessagingException {
        if (this.messageFactory == null) {
            return null;
        }
        Properties props = this.messageFactory.getSessionProperties();
        if (props != null && !props.isEmpty()) {
            String authenticatorRequired = props.getProperty("mail.authenticator.required");
            Authenticator authenticator = this.messageFactory.getAuthenticator();
            if (authenticatorRequired != null && authenticatorRequired.equals("true") && authenticator == null) {
                this.messageFactory.setAuthenticator(this.newAuthenticator());
            }
            if (props.getProperty("mail.host") == null) {
                throw new MessagingException(RB.getStringResource("ComposeMessageForm.serverMissing.txt"));
            }
        } else {
            boolean cancelled = this.configureServer();
            if (cancelled) {
                return null;
            }
        }
        Session session = this.messageFactory.getSession();
        String errMsg = RB.getStringResource("ComposeMessageForm.messageCreationFailed.txt");
        Message msg = this.messageFactory.newMessage(session);
        if (msg == null) {
            throw new MessagingException(errMsg);
        }
        this.readHeaderForm(msg);
        this.readContent(msg);
        return msg;
    }

    protected Authenticator newAuthenticator() {
        Frame parentFrame = Util.getParentFrame(this);
        if (parentFrame == null) {
            parentFrame = new Frame();
        }
        return new UserInfoAuthenticator(parentFrame);
    }

    protected boolean configureServer() {
        Frame parentFrame = Util.getParentFrame(this);
        if (parentFrame == null) {
            parentFrame = new Frame();
        }
        String configuration = RB.getStringResource("ComposeMessageForm.serverOptionsDialog.dialogTitle.txt");
        OkCancelHelpDialog configurationDialog = new OkCancelHelpDialog(parentFrame, configuration);
        ButtonPanel btnPanel = configurationDialog.getButtonPanel();
        PushButton closeBtn = btnPanel.getButtonFromActionCommand(OkCancelHelpDialog.CLOSE);
        PushButton cancelBtn = btnPanel.getButtonFromActionCommand(OkCancelHelpDialog.CANCEL);
        PushButton helpBtn = btnPanel.getButtonFromActionCommand(OkCancelHelpDialog.HELP);
        btnPanel.removeButton(helpBtn);
        closeBtn.setEnabled(false);
        ServerOptionsFolder serverOptionsFolder = new ServerOptionsFolder();
        serverOptionsFolder.setObject(this);
        Panel mainPanel = configurationDialog.getMainPanel();
        mainPanel.setInsets(new Insets(5, 5, 5, 5));
        mainPanel.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 0, 0, true, true, true));
        BaseBorder border = (BaseBorder)mainPanel.getBorder();
        border.setSidesPainted(8);
        border.setStyle(3);
        border.setLightSource(10);
        mainPanel.add(serverOptionsFolder);
        configurationDialog.setModal(true);
        configurationDialog.pack();
        ServerValidator serverValidator = new ServerValidator(serverOptionsFolder, closeBtn);
        Util.centerOver(configurationDialog, this);
        configurationDialog.setVisible(true);
        return configurationDialog.wasCancelled();
    }

    public void resetMessageForm() {
        this.resetHeaderForm();
        this.resetContent();
    }

    public void resetHeaderForm() {
        this.headerForm.resetHeaderForm();
    }

    public void resetContent() {
        if (this.attachmentList != null) {
            this.attachmentList.removeAll();
        }
        this.textContent.setText("");
    }

    protected void readHeaderForm(Message msg) throws MessagingException {
        Address[] toAddresses = this.headerForm.getRecipients(Message.RecipientType.TO);
        Address[] ccAddresses = this.headerForm.getRecipients(Message.RecipientType.CC);
        Address[] bccAddresses = this.headerForm.getRecipients(Message.RecipientType.BCC);
        Address[] fromAddresses = this.headerForm.getFrom();
        Address[] replyToAddresses = this.headerForm.getReplyTo();
        String subject = this.headerForm.getSubject();
        Flags flags = this.headerForm.getFlags();
        if (toAddresses != null) {
            msg.setRecipients(Message.RecipientType.TO, toAddresses);
        }
        if (ccAddresses != null) {
            msg.setRecipients(Message.RecipientType.CC, ccAddresses);
        }
        if (bccAddresses != null) {
            msg.setRecipients(Message.RecipientType.BCC, bccAddresses);
        }
        if (replyToAddresses != null) {
            msg.setReplyTo(replyToAddresses);
        }
        if (fromAddresses != null && fromAddresses.length > 0) {
            msg.setFrom(fromAddresses[0]);
            int addressCount = fromAddresses.length;
            if (addressCount > 1) {
                Address[] addresses = new Address[--addressCount];
                for (int i = 0; i < addressCount; ++i) {
                    addresses[i] = fromAddresses[i];
                }
                msg.addFrom(addresses);
            }
        }
        if (subject != null) {
            msg.setSubject(subject);
        }
        if (flags != null) {
            this.headerForm.setFlags(flags, true);
        }
    }

    protected void readContent(Message msg) throws MessagingException {
        int attachmentCount = this.attachmentList.count();
        if (attachmentCount > 0) {
            String txtContent = this.getText();
            Multipart multipartMsg = this.messageFactory.newMultipart();
            BodyPart firstPart = this.messageFactory.newBodyPart();
            firstPart.setContent((Object)txtContent, "text/plain");
            boolean noText = false;
            if (txtContent != null && txtContent.length() > 0) {
                multipartMsg.addBodyPart(firstPart);
            } else {
                noText = true;
            }
            if (noText && attachmentCount == 1) {
                Attachment attachment = (Attachment)this.attachmentList.get(0);
                DataSource dataSource = attachment.getDataSource();
                Object content = attachment.getContent();
                String type = attachment.getContentType();
                DataHandler dataHandler = attachment.getDataHandler();
                if (dataHandler != null) {
                    msg.setDataHandler(dataHandler);
                    msg.setFileName(dataHandler.getName());
                } else if (content == null && dataSource != null) {
                    DataHandler dh = new DataHandler(dataSource);
                    msg.setDataHandler(dh);
                    msg.setFileName(dataSource.getName());
                } else if (content != null) {
                    msg.setContent(content, type);
                }
            } else {
                for (int i = 0; i < attachmentCount; ++i) {
                    BodyPart bdpart = this.messageFactory.newBodyPart();
                    bdpart.setDisposition("attachment");
                    Attachment attachment = (Attachment)this.attachmentList.get(i);
                    DataSource dataSource = attachment.getDataSource();
                    Object content = attachment.getContent();
                    String type = attachment.getContentType();
                    DataHandler dataHandler = attachment.getDataHandler();
                    if (dataHandler != null) {
                        bdpart.setDataHandler(dataHandler);
                        bdpart.setFileName(dataHandler.getName());
                    } else if (content == null && dataSource != null) {
                        DataHandler dh = new DataHandler(dataSource);
                        bdpart.setDataHandler(dh);
                        bdpart.setFileName(dataSource.getName());
                    } else if (content != null) {
                        bdpart.setContent(content, type);
                    }
                    multipartMsg.addBodyPart(bdpart);
                }
                msg.setContent(multipartMsg);
            }
        } else {
            msg.setContent((Object)this.getText(), "text/plain");
        }
    }

    protected void writeHeaderForm(Message msg) throws MessagingException {
        Address[] toAddresses = msg.getRecipients(Message.RecipientType.TO);
        Address[] ccAddresses = msg.getRecipients(Message.RecipientType.CC);
        Address[] bccAddresses = msg.getRecipients(Message.RecipientType.BCC);
        Address[] fromAddresses = msg.getFrom();
        Address[] replyToAddresses = msg.getReplyTo();
        String subject = msg.getSubject();
        Flags flags = msg.getFlags();
        if (toAddresses != null) {
            this.headerForm.setRecipients(Message.RecipientType.TO, toAddresses);
        }
        if (ccAddresses != null) {
            this.headerForm.setRecipients(Message.RecipientType.CC, ccAddresses);
        }
        if (bccAddresses != null) {
            this.headerForm.setRecipients(Message.RecipientType.BCC, bccAddresses);
        }
        if (replyToAddresses != null) {
            this.headerForm.setReplyTo(replyToAddresses);
        }
        if (fromAddresses != null) {
            this.headerForm.setAddresses(HeaderFields.FROM, fromAddresses);
        }
        this.headerForm.setSubject(subject);
        this.headerForm.setFlags(flags, true);
    }

    protected void writeContent(Message msg) throws MessagingException, IOException {
        this.textContent.setText("");
        this.attachmentList.removeAll();
        String type = msg.getContentType();
        if (type.indexOf("multipart") != -1) {
            Object content = msg.getContent();
            if (content instanceof Multipart) {
                Multipart multipartMsg = (Multipart)content;
                BodyPart firstPart = multipartMsg.getBodyPart(0);
                type = firstPart.getContentType();
                int startIndex = 1;
                content = firstPart.getContent();
                if (type.indexOf("text") != -1 && content != null) {
                    this.textContent.setText(content.toString());
                } else {
                    startIndex = 0;
                }
                for (int i = startIndex; i < multipartMsg.getCount(); ++i) {
                    BodyPart bdpart = multipartMsg.getBodyPart(i);
                    com.sas.text.Message attachmentName = new com.sas.text.Message(RB.getResources(), "ComposeMessageForm.attachmentName.txt", (Object)new Integer(i));
                    Attachment attachment = new Attachment(bdpart.getDataHandler(), attachmentName.toString());
                    this.addAttachment(attachment);
                }
            }
        } else if (type.indexOf("text") != -1) {
            Object content = msg.getContent();
            if (content != null) {
                this.textContent.setText(content.toString());
            }
        } else {
            com.sas.text.Message attachmentName = new com.sas.text.Message(RB.getResources(), "ComposeMessageForm.attachmentName.txt", (Object)new Integer(1));
            Attachment attachment = new Attachment(msg.getDataHandler(), attachmentName.toString());
            this.addAttachment(attachment);
        }
    }

    @Override
    public void refresh(ModelInterface model) {
        if (model instanceof MessageFactoryInterface) {
            this.setMessageFactory((MessageFactoryInterface)model);
        }
    }

    public String getText() {
        return this.textContent.getText();
    }

    public void setText(String text) {
        this.textContent.setText(text);
    }

    public boolean isMessageEditable() {
        return this.editable;
    }

    public void setMessageEditable(boolean e) {
        if (e != this.editable) {
            this.editable = e;
            if (this.textContent instanceof TextComponent) {
                ((TextComponent)this.textContent).setEditable(this.editable);
            }
            this.attachmentMenu.setEnabled(this.editable);
            HeaderFields headerField = HeaderFields.getFirst();
            for (int i = 0; i < headerField.count(); ++i) {
                this.headerForm.setHeaderFieldEditable(headerField, this.editable);
                headerField = headerField.getNext();
            }
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"messageEditable", (boolean)this.editable);
        }
    }

    public boolean isAttachmentListVisible() {
        return ((Component)this.attachmentListViewer).isVisible();
    }

    public void setAttachmentListVisible(boolean v) {
        boolean visible = ((Component)this.attachmentListViewer).isVisible();
        ((Component)this.attachmentListViewer).setVisible(v);
        this.invalidate();
        this.validate();
        if (visible != v) {
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"attachmentListVisible", (boolean)((Component)this.attachmentListViewer).isVisible());
        }
    }

    public OrderedCollectionInterface getAttachmentList() {
        return this.attachmentList;
    }

    public Enumeration getAttachments() {
        return this.attachmentList.getItems(0, -1);
    }

    public int getAttachmentCount() {
        return this.attachmentList.count();
    }

    public void addAttachment(DataSource dataSource) {
        Attachment attachment = new Attachment(dataSource);
        this.attachmentList.add((Object)attachment);
    }

    public void addAttachment(Object content, String contentType, String name) {
        Attachment attachment = new Attachment(content, contentType, name);
        this.attachmentList.add((Object)attachment);
    }

    public void addAttachment(Attachment attachment) {
        this.attachmentList.add((Object)attachment);
    }

    public void removeAttachment(DataSource dataSource) {
        Enumeration attachmentsEnum = this.attachmentList.getItems();
        int index = -1;
        boolean attachmentFound = false;
        while (attachmentsEnum.hasMoreElements() && !attachmentFound) {
            ++index;
            Attachment attachment = (Attachment)attachmentsEnum.nextElement();
            if (!com.sas.util.Util.equal((Object)attachment.getDataSource(), (Object)dataSource)) continue;
            attachmentFound = true;
        }
        if (attachmentFound) {
            this.attachmentList.removeAt(index);
        }
    }

    public void removeAttachment(String name) {
        Enumeration attachmentsEnum = this.attachmentList.getItems();
        int index = -1;
        boolean attachmentFound = false;
        while (attachmentsEnum.hasMoreElements() && !attachmentFound) {
            ++index;
            Attachment attachment = (Attachment)attachmentsEnum.nextElement();
            if (!com.sas.util.Util.equal((Object)attachment.getName(), (Object)name)) continue;
            attachmentFound = true;
        }
        if (attachmentFound) {
            this.attachmentList.removeAt(index);
        }
    }

    public void removeAttachment(Attachment attachment) {
        this.attachmentList.remove((Object)attachment);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.attachmentPopupListener.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.headerPopupListener.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.addContextCommandsProducer(this);
    }

    class ServerValidator
    implements PropertyChangeListener {
        ServerOptionsFolder serverOptionsFolder;
        PushButton closeBtn;

        public ServerValidator(ServerOptionsFolder folder, PushButton btn) {
            this.serverOptionsFolder = folder;
            this.serverOptionsFolder.addPropertyChangeListener(this);
            this.closeBtn = btn;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propName = event.getPropertyName();
            Object source = event.getSource();
            if (source == this.serverOptionsFolder && propName != null && propName.equals("serverHost")) {
                String newValue = (String)event.getNewValue();
                if (newValue != null && newValue.length() > 0) {
                    this.closeBtn.setEnabled(true);
                } else {
                    this.closeBtn.setEnabled(false);
                }
            }
        }
    }
}

