/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail;

import com.sas.ModelInterface;
import com.sas.awt.Container;
import com.sas.awt.Dialog;
import com.sas.collection.AssociationListInterface;
import com.sas.lang.StringDataInterface;
import com.sas.mail.ComposeMessageForm;
import com.sas.mail.MessageDataInterface;
import com.sas.mail.MessageFactoryInterface;
import com.sas.mail.RB;
import com.sas.models.StatusStringData;
import com.sas.util.Command;
import com.sas.util.errorhandlers.CompositeErrorHandler;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.errorhandlers.MessageBoxErrorHandler;
import com.sas.util.errorhandlers.StringDataErrorHandler;
import com.sas.util.errorhandlers.SupportsErrorHandlerInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.LabelView;
import com.sas.visuals.PushButton;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.mail.Message;
import javax.mail.MessagingException;

public class ComposeMessageDialog
extends Dialog
implements ActionListener,
PropertyChangeListener,
MessageDataInterface {
    static final long serialVersionUID = -6170550546049108110L;
    protected ComposeMessageForm composeMsgForm;
    protected Container cmdToolbar;
    protected StringDataInterface statusBar;

    public ComposeMessageDialog(Frame parent) {
        super(parent);
    }

    public ComposeMessageDialog(Frame parent, String title) {
        super(parent, title);
    }

    public ComposeMessageDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
    }

    protected ComposeMessageForm newComposeMessageForm() {
        return new ComposeMessageForm();
    }

    protected Container newCommandToolbar() {
        Container cmdContainer = new Container();
        cmdContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 0, 0, 0, true, false, false));
        cmdContainer.setInsets(new Insets(3, 0, 0, 0));
        PushButton btn1 = new PushButton();
        PushButton btn2 = new PushButton();
        PushButton btn3 = new PushButton();
        String btn1Text = RB.getStringResource("ComposeMessageDialog.sendButton.txt");
        String btn2Text = RB.getStringResource("ComposeMessageDialog.addAttachmentButton.txt");
        String btn3Text = RB.getStringResource("ComposeMessageDialog.optionsButton.txt");
        btn1.setText(btn1Text);
        btn1.setActionCommand("SEND_MESSAGE");
        btn1.addActionListener(this);
        btn2.setText(btn2Text);
        btn2.setActionCommand("ADD_ATTACHMENT");
        btn2.addActionListener(this);
        btn3.setText(btn3Text);
        btn3.setActionCommand("CONFIGURE_OPTIONS");
        btn3.addActionListener(this);
        cmdContainer.add(btn1);
        cmdContainer.add(btn2);
        cmdContainer.add(btn3);
        return cmdContainer;
    }

    protected StringDataInterface newStatusBar() {
        StatusStringData stringData = new StatusStringData(" ");
        LabelView labelView = new LabelView();
        labelView.setModelInterface((ModelInterface)stringData);
        return labelView;
    }

    protected void createComponents() {
        this.composeMsgForm = this.newComposeMessageForm();
        this.cmdToolbar = this.newCommandToolbar();
        this.statusBar = this.newStatusBar();
        this.composeMsgForm.addPropertyChangeListener(this);
    }

    protected void layoutComponents() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 0, 3, true, true, true);
        layout.setRemainderRow(2);
        this.setLayout((LayoutManager)layout);
        this.add(this.cmdToolbar);
        this.add(this.composeMsgForm);
        this.add((Component)this.statusBar);
    }

    public ComposeMessageForm getComposeMessageForm() {
        return this.composeMsgForm;
    }

    public java.awt.Container getCommandToolbar() {
        return this.cmdToolbar;
    }

    public void resetMessageForm() {
        this.composeMsgForm.resetMessageForm();
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.createComponents();
        this.layoutComponents();
        StringDataErrorHandler sDataErrorHandler = new StringDataErrorHandler(this.statusBar);
        MessageBoxErrorHandler mBoxErrorHandler = new MessageBoxErrorHandler(this);
        CompositeErrorHandler compositeErrorHandler = new CompositeErrorHandler((ErrorHandlerInterface)sDataErrorHandler, (ErrorHandlerInterface)mBoxErrorHandler);
        this.setErrorHandler((ErrorHandlerInterface)compositeErrorHandler);
    }

    @Override
    public void setErrorHandler(ErrorHandlerInterface errorHandler) {
        super.setErrorHandler(errorHandler);
        this.composeMsgForm.setErrorHandler(errorHandler);
    }

    public AssociationListInterface getCommandList() {
        return this.composeMsgForm.getCommandList();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object eSource = event.getSource();
        String propName = event.getPropertyName();
        if (eSource == this.composeMsgForm && propName != null) {
            if (propName.equals("attachmentListVisible")) {
                this.pack();
            } else if (propName.equals("message") || propName.equals("messageFactory")) {
                this.firePropertyChange(propName, event.getOldValue(), event.getNewValue());
            }
        }
    }

    public boolean doCommand(String cmdName) {
        AssociationListInterface cmdList = this.getCommandList();
        if (cmdName != null && cmdList.containsKey((Object)cmdName)) {
            Command command = (Command)cmdList.get((Object)cmdName);
            if (command instanceof SupportsErrorHandlerInterface) {
                ((SupportsErrorHandlerInterface)command).setErrorHandler(this.getErrorHandler());
            }
            command.execute((Object)this.composeMsgForm);
            if (cmdName.equals("ADD_ATTACHMENT") && this.composeMsgForm.getAttachmentCount() > 0) {
                this.composeMsgForm.setAttachmentListVisible(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object eSource = event.getSource();
        if (eSource instanceof Component && ((Component)eSource).getParent() == this.cmdToolbar) {
            this.doCommand(event.getActionCommand());
        }
    }

    @Override
    public Message getMessage() throws MessagingException {
        return this.composeMsgForm.getMessage();
    }

    @Override
    public void setMessage(Message msg) throws MessagingException {
        this.composeMsgForm.setMessage(msg);
    }

    @Override
    public void messageChanged() throws MessagingException {
        this.composeMsgForm.messageChanged();
    }

    public MessageFactoryInterface getMessageFactory() {
        return this.composeMsgForm.getMessageFactory();
    }

    public void setMessageFactory(MessageFactoryInterface msgFactory) {
        this.composeMsgForm.setMessageFactory(msgFactory);
    }

    public String getStatus() {
        if (this.statusBar != null) {
            return this.statusBar.getText();
        }
        return null;
    }

    public void setStatus(String status) {
        if (this.statusBar != null) {
            this.statusBar.setText(status);
        }
    }
}

