/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

public class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private String type;
    private String name;

    public ByteArrayDataSource(InputStream is, String type, String name) {
        this.type = type;
        this.name = name;
        try {
            int ch;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            this.data = os.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ByteArrayDataSource(ByteArrayOutputStream os, String type, String name) {
        this.name = name;
        this.type = type;
        this.data = os.toByteArray();
    }

    public ByteArrayDataSource(byte[] data, String type, String name) {
        this.name = name;
        this.data = data;
        this.type = type;
    }

    public ByteArrayDataSource(String data, String type, String name) {
        try {
            this.data = data.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.name = name;
        this.type = type;
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("OutputStream is not supported on the ByteArrayDataSource");
    }

    public String getContentType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

